/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api7;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public final class SubjectDataProxy
implements SubjectData {
    private final LPPermissionService service;
    private final LPSubjectReference ref;
    private final boolean enduring;

    public SubjectDataProxy(LPPermissionService service, LPSubjectReference ref, boolean enduring) {
        this.service = service;
        this.ref = ref;
        this.enduring = enduring;
    }

    private CompletableFuture<LPSubjectData> handle() {
        return this.enduring ? this.ref.resolveLp().thenApply(LPSubject::getSubjectData) : this.ref.resolveLp().thenApply(LPSubject::getTransientSubjectData);
    }

    public @NonNull Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getAllPermissions().entrySet().stream().collect(ImmutableCollectors.toMap(e -> CompatibilityUtil.convertContexts((ContextSet)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull Map<String, Boolean> getPermissions(@NonNull Set<Context> contexts) {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getPermissions(CompatibilityUtil.convertContexts(contexts)))).join();
    }

    public @NonNull CompletableFuture<Boolean> setPermission(@NonNull Set<Context> contexts, @NonNull String permission, @NonNull Tristate value) {
        return this.handle().thenCompose(handle -> handle.setPermission(CompatibilityUtil.convertContexts(contexts), permission, CompatibilityUtil.convertTristate(value)));
    }

    public @NonNull CompletableFuture<Boolean> clearPermissions() {
        return this.handle().thenCompose(LPSubjectData::clearPermissions);
    }

    public @NonNull CompletableFuture<Boolean> clearPermissions(@NonNull Set<Context> contexts) {
        return this.handle().thenCompose(handle -> handle.clearPermissions(CompatibilityUtil.convertContexts(contexts)));
    }

    public @NonNull Map<Set<Context>, List<SubjectReference>> getAllParents() {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getAllParents().entrySet().stream().collect(ImmutableCollectors.toMap(e -> CompatibilityUtil.convertContexts((ContextSet)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull List<SubjectReference> getParents(@NonNull Set<Context> contexts) {
        return (List)((CompletableFuture)this.handle().thenApply(handle -> handle.getParents(CompatibilityUtil.convertContexts(contexts)))).join();
    }

    public @NonNull CompletableFuture<Boolean> addParent(@NonNull Set<Context> contexts, @NonNull SubjectReference ref) {
        return this.handle().thenCompose(handle -> handle.addParent(CompatibilityUtil.convertContexts(contexts), this.service.getReferenceFactory().obtain(ref)));
    }

    public @NonNull CompletableFuture<Boolean> removeParent(@NonNull Set<Context> contexts, @NonNull SubjectReference ref) {
        return this.handle().thenCompose(handle -> handle.removeParent(CompatibilityUtil.convertContexts(contexts), this.service.getReferenceFactory().obtain(ref)));
    }

    public @NonNull CompletableFuture<Boolean> clearParents() {
        return this.handle().thenCompose(LPSubjectData::clearParents);
    }

    public @NonNull CompletableFuture<Boolean> clearParents(@NonNull Set<Context> contexts) {
        return this.handle().thenCompose(handle -> handle.clearParents(CompatibilityUtil.convertContexts(contexts)));
    }

    public @NonNull Map<Set<Context>, Map<String, String>> getAllOptions() {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getAllOptions().entrySet().stream().collect(ImmutableCollectors.toMap(e -> CompatibilityUtil.convertContexts((ContextSet)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull Map<String, String> getOptions(@NonNull Set<Context> contexts) {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getOptions(CompatibilityUtil.convertContexts(contexts)))).join();
    }

    public @NonNull CompletableFuture<Boolean> setOption(@NonNull Set<Context> contexts, @NonNull String key, @Nullable String value) {
        if (value == null) {
            return this.handle().thenCompose(handle -> handle.unsetOption(CompatibilityUtil.convertContexts(contexts), key));
        }
        return this.handle().thenCompose(handle -> handle.setOption(CompatibilityUtil.convertContexts(contexts), key, value));
    }

    public @NonNull CompletableFuture<Boolean> clearOptions() {
        return this.handle().thenCompose(LPSubjectData::clearOptions);
    }

    public @NonNull CompletableFuture<Boolean> clearOptions(@NonNull Set<Context> contexts) {
        return this.handle().thenCompose(handle -> handle.clearOptions(CompatibilityUtil.convertContexts(contexts)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubjectDataProxy)) {
            return false;
        }
        SubjectDataProxy other = (SubjectDataProxy)o;
        return this.ref.equals(other.ref) && this.enduring == other.enduring;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ref.hashCode();
        result = result * 59 + (this.enduring ? 79 : 97);
        return result;
    }

    public String toString() {
        return "luckperms.api7.SubjectDataProxy(ref=" + this.ref + ", enduring=" + this.enduring + ")";
    }
}

