/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.FakeMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.wiring.container.ContainerChargePad;
import ic2.core.block.wiring.misc.EntityChargePadAuraFX;
import ic2.core.block.wiring.tile.TileEntityChargePadHV;
import ic2.core.block.wiring.tile.TileEntityChargePadLV;
import ic2.core.block.wiring.tile.TileEntityChargePadMV;
import ic2.core.block.wiring.tile.TileEntityChargePadNuclear;
import ic2.core.entity.IC2DamageSource;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.upgrades.ItemChargePadUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.IItemContainer;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityChargePadBase
extends TileEntityBlock
implements IEnergySink,
ITickable,
INetworkTileEntityEventListener,
IClickable,
IHasGui,
IEUStorage,
IItemContainer {
    public int defaultMaxEnergy;
    public int defaultTier;
    public int defaultMaxInput;
    @NetworkField(index=3)
    public int maxEnergy;
    @NetworkField(index=4)
    public int storedEnergy = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int tier;
    @NetworkField(index=6)
    public int maxInput;
    @NetworkField(index=7)
    public int transferlimit;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit8, override=true)
    public int extraRange;
    public int activeTime = 0;
    public boolean isForcedOff;
    public int forcedTicker;
    FakeMachine fake = null;
    @NetworkField(index=9, compression=NetworkField.BitLevel.Bit8)
    public boolean[] installedUpgrades = new boolean[PadUpgrade.values().length];
    @NetworkField(index=10)
    public ChargePadType type;
    public PersonalInventory inv;
    public boolean Enet = false;

    public TileEntityChargePadBase(ChargePadType padType) {
        this.type = padType;
        this.defaultMaxEnergy = this.maxEnergy = this.type.getMaxEnergy();
        this.defaultTier = this.tier = this.type.getTier();
        this.defaultMaxInput = this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        this.transferlimit = this.maxInput;
        this.inv = new PersonalInventory(1 + this.type.getUpgradeSlots() + (this.type == ChargePadType.LV ? 0 : 2));
        this.addNetworkFields("extraRange", "type", "installedUpgrades");
        this.addGuiFields("storedEnergy", "maxEnergy", "tier", "transferlimit");
        this.addInfos(new EnergyInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.activeTime = nbt.func_74762_e("ActiveTime");
        this.forcedTicker = nbt.func_74762_e("ForcedTime");
        this.storedEnergy = nbt.func_74762_e("StoredEnergy");
        this.isForcedOff = nbt.func_74767_n("ForcedOff");
        this.inv.readFromNBT(nbt.func_74775_l("Inventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ActiveTime", this.activeTime);
        nbt.func_74768_a("ForcedTime", this.forcedTicker);
        nbt.func_74768_a("StoredEnergy", this.storedEnergy);
        nbt.func_74757_a("ForcedOff", this.isForcedOff);
        this.inv.writeToNBT(this.getTag(nbt, "Inventory"));
        return nbt;
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inv.getSlotCount(); ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            drop.add(stack.func_77946_l());
        }
        return drop;
    }

    @Override
    public LocaleComp getBlockName() {
        return this.type.getName();
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerChargePad(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    protected abstract double getFieldHeight();

    @SideOnly(value=Side.CLIENT)
    protected abstract int getMaxParticalAge();

    @SideOnly(value=Side.CLIENT)
    protected abstract float[] getParticalColour(Random var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract double[] getParticleVelocity(Random var1);

    @SideOnly(value=Side.CLIENT)
    protected abstract int getParticalAmount(Random var1);

    @SideOnly(value=Side.CLIENT)
    public void spawnParticals(Random rand) {
        float multPos = (float)(this.extraRange * 2) + 0.9f;
        int blockX = this.func_174877_v().func_177958_n() - this.extraRange;
        int blockZ = this.func_174877_v().func_177952_p() - this.extraRange;
        boolean swirl = this.type == ChargePadType.Nuclear;
        ParticleManager er = Minecraft.func_71410_x().field_71452_i;
        for (int i = 1 + this.extraRange * 2; i > 0; --i) {
            for (int k = this.getParticalAmount(rand); k > 0; --k) {
                double x = (float)blockX + 0.05f + rand.nextFloat() * multPos;
                double y = (float)this.func_174877_v().func_177956_o() + 0.2f + rand.nextFloat() * 0.2f;
                double z = (float)blockZ + 0.05f + rand.nextFloat() * multPos;
                double[] velocity = this.getParticleVelocity(rand);
                if (k < 4) {
                    velocity[2] = velocity[2] * 0.55;
                }
                float[] colour = this.getParticalColour(rand);
                er.func_78873_a((Particle)new EntityChargePadAuraFX(this.field_145850_b, x, y, z, this.getMaxParticalAge(), velocity, colour, swirl));
            }
        }
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void func_73660_a() {
        this.provideEnergy();
        if (!this.getActive()) {
            if (this.isForcedOff && this.forcedTicker > 0 && --this.forcedTicker <= 0) {
                this.isForcedOff = false;
            }
            return;
        }
        if (this.activeTime > 0 && --this.activeTime <= 0) {
            this.deativateChargePad();
            return;
        }
        int toSend = Math.min(this.storedEnergy, this.transferlimit);
        if (toSend <= 0) {
            this.setForcedOff(20);
            this.activeTime = 0;
            return;
        }
        List<EntityLivingBase> list = this.getEntitiesInRange();
        if (list.isEmpty()) {
            this.deativateChargePad();
            return;
        }
        boolean pvp = IC2.platform.isPVP();
        if (this.installedUpgrades[PadUpgrade.Damage.ordinal()] && pvp) {
            this.damageEntities(list);
            this.storedEnergy -= toSend;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            return;
        }
        List<ItemStack> toCharge = new ArrayList();
        boolean drain = this.tier > 2 && this.installedUpgrades[PadUpgrade.Drain.ordinal()] && pvp;
        for (EntityLivingBase base : list) {
            if (base == null || base.field_70128_L || !(base instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)base;
            if (this.installedUpgrades[PadUpgrade.ArmorPriority.ordinal()]) {
                int check = toCharge.size();
                this.addPlayerArmor(player, toCharge, drain);
                if (check != toCharge.size()) continue;
                this.addPlayerHotbar(player, toCharge, drain);
                continue;
            }
            int amount = toCharge.size();
            this.addPlayerHotbar(player, toCharge, drain);
            if (amount != toCharge.size()) continue;
            this.addPlayerArmor(player, toCharge, drain);
        }
        int size = toCharge.size();
        if (size <= 0) {
            this.setForcedOff(20);
            this.activeTime = 0;
            return;
        }
        if (size > 1) {
            Collections.shuffle(toCharge);
        }
        if (size > toSend) {
            toCharge = toCharge.subList(0, toSend);
            size = toCharge.size();
        }
        for (ItemStack target : toCharge) {
            int added;
            int toAdd = (int)Math.ceil(toSend / size--);
            if (drain) {
                added = (int)ElectricItem.manager.discharge(target, toAdd, this.tier, false, false, false);
                this.storedEnergy -= added;
                toSend -= added;
                this.getNetwork().updateTileGuiField(this, "storedEnergy");
                continue;
            }
            added = (int)ElectricItem.manager.charge(target, toAdd, this.tier, false, false);
            this.storedEnergy -= added;
            toSend -= added;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
        }
    }

    protected void addPlayerHotbar(EntityPlayer player, List<ItemStack> list, boolean drain) {
        int start;
        int end = start = player.field_71071_by.field_70461_c;
        if (this.installedUpgrades[PadUpgrade.Proximity.ordinal()]) {
            start = Math.max(0, start - 1);
            end = Math.min(8, end + 1);
        } else if (this.installedUpgrades[PadUpgrade.WideBand.ordinal()]) {
            start = 0;
            end = 8;
        }
        if (start < 0 || end > 8) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            ItemStack item = player.field_71071_by.func_70301_a(i);
            if (!this.canTransferEnergy(item, drain)) continue;
            list.add(item);
        }
        ItemStack stack = player.func_184586_b(EnumHand.OFF_HAND);
        if (this.canTransferEnergy(stack, drain)) {
            list.add(stack);
        }
    }

    protected void addPlayerArmor(EntityPlayer player, List<ItemStack> list, boolean drain) {
        IHasInventory inv;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND || !this.canTransferEnergy(stack = player.func_184582_a(slot), drain)) continue;
            list.add(stack);
        }
        IBaublesPlugin plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class);
        if (plugin != null && (inv = plugin.getBaublesInventory(player)) != null) {
            for (int i = 0; i < inv.getSlotCount(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (!this.canTransferEnergy(stack, drain)) continue;
                list.add(stack);
            }
        }
    }

    public boolean canTransferEnergy(ItemStack stack, boolean drain) {
        if (stack == null) {
            return false;
        }
        if (drain) {
            return ElectricItem.manager.discharge(stack, 2.147483647E9, this.tier, false, false, true) > 0.0;
        }
        return ElectricItem.manager.charge(stack, 2.147483647E9, this.tier, false, true) > 0.0;
    }

    public void damageEntities(List<EntityLivingBase> list) {
        for (EntityLivingBase base : list) {
            if (base == null || base.field_70128_L) continue;
            base.func_70097_a((DamageSource)IC2DamageSource.electricity, 1.0f);
            if (base.func_70644_a(MobEffects.field_76436_u)) continue;
            base.func_70690_d(new PotionEffect(MobEffects.field_76436_u, this.type.ordinal() * 20, this.type.ordinal() * 10));
        }
    }

    public void setForcedOff(int time) {
        this.isForcedOff = true;
        this.forcedTicker = time;
        this.deativateChargePad();
    }

    public List<EntityLivingBase> getEntitiesInRange() {
        return this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)this.extraRange, this.getFieldHeight(), (double)this.extraRange));
    }

    public void deativateChargePad() {
        this.setActive(false);
        this.getNetwork().initiateTileEntityEvent(this, 0, false);
        this.field_145850_b.func_190524_a(this.func_174877_v(), this.func_145838_q(), this.func_174877_v());
        for (EnumFacing facing : RotationList.ALL) {
            BlockPos newPos = this.func_174877_v().func_177972_a(facing);
            if (!this.field_145850_b.func_175667_e(newPos)) continue;
            this.field_145850_b.func_190524_a(newPos, this.func_145838_q(), this.func_174877_v());
        }
    }

    public void provideEnergy() {
        int needed = this.maxEnergy - this.storedEnergy;
        ItemStack stack = this.inv.getStackInSlot(0);
        if (needed <= 0 || stack.func_190926_b()) {
            return;
        }
        int added = (int)ElectricItem.manager.discharge(stack, needed, this.tier, false, true, false);
        if (added > 0) {
            this.storedEnergy += added;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            return;
        }
        if (stack.func_77973_b() == Items.field_151137_ax) {
            this.storedEnergy = this.maxEnergy;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            stack.func_190918_g(1);
        } else if (StackUtil.isStackEqual(stack, Ic2Items.suBattery)) {
            this.storedEnergy += 1000;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            stack.func_190918_g(1);
        }
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.storedEnergy;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > (double)this.maxInput || amount <= 0.0) {
            return 0.0;
        }
        this.storedEnergy = (int)((double)this.storedEnergy + amount);
        int re = 0;
        if (this.storedEnergy > this.maxEnergy) {
            re = this.storedEnergy - this.maxEnergy;
            this.storedEnergy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "storedEnergy");
        return re;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (event == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else if (event == 1) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setUpgradeStats();
        }
        if (!this.Enet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.Enet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.Enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.Enet = false;
        }
        super.onUnloaded();
    }

    public FakeMachine getMachine() {
        if (this.fake == null) {
            this.fake = new FakeMachine(this, new FilteredList<IMachineUpgradeItem.UpgradeType>((Collection<IMachineUpgradeItem.UpgradeType>)Arrays.asList(IMachineUpgradeItem.UpgradeType.MachineModifierA, IMachineUpgradeItem.UpgradeType.MachineModifierB)));
        }
        return this.fake;
    }

    public void setUpgradeStats() {
        this.getMachine();
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        this.installedUpgrades = new boolean[PadUpgrade.values().length];
        for (int i = 1; i < this.inv.getSlotCount(); ++i) {
            PadUpgrade up;
            ItemStack stack = this.inv.getStackInSlot(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item instanceof IMachineUpgradeItem) {
                IMachineUpgradeItem mach = (IMachineUpgradeItem)item;
                mach.onInstalling(stack, this.fake);
                extraProcessTime += mach.getExtraProcessSpeed(stack, this.fake) * stack.func_190916_E();
                processTimeMultiplier *= Math.pow(mach.getProcessSpeedMultiplier(stack, this.fake), stack.func_190916_E());
                extraEnergyStorage += mach.getExtraEnergyStorage(stack, this.fake) * stack.func_190916_E();
                energyStorageMultiplier *= Math.pow(mach.getEnergyStorageMultiplier(stack, this.fake), stack.func_190916_E());
                extraTier += mach.getExtraTier(stack, this.fake) * stack.func_190916_E();
                continue;
            }
            if (!(item instanceof ItemChargePadUpgrade) || (up = ((ItemChargePadUpgrade)item).getUpgrade(stack)) == null) continue;
            this.installedUpgrades[up.ordinal()] = true;
        }
        int newTransfer = TileEntityChargePadBase.applyModifier(this.defaultMaxInput, extraProcessTime, processTimeMultiplier);
        this.setMaxEnergy(TileEntityChargePadBase.applyModifier(this.defaultMaxEnergy, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.defaultTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        this.transferlimit = newTransfer;
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "transferlimit");
        this.getNetwork().updateTileGuiField(this, "tier");
        this.extraRange = 0;
        List<PadUpgrade> range = Arrays.asList(PadUpgrade.FieldExpI, PadUpgrade.FieldExpII, PadUpgrade.FieldExpIII);
        for (int i = 0; i < range.size(); ++i) {
            if (!this.installedUpgrades[range.get(i).ordinal()]) continue;
            this.extraRange += 1 + i;
        }
        this.getNetwork().updateTileEntityField(this, "extraRange");
        this.getNetwork().updateTileEntityField(this, "installedUpgrades");
    }

    private void setMaxEnergy(int max) {
        this.maxEnergy = max;
        this.getNetwork().updateTileGuiField(this, "maxEnergy");
    }

    static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        return (this.installedUpgrades[PadUpgrade.Drain.ordinal()] || this.installedUpgrades[PadUpgrade.Damage.ordinal()]) && face != EnumFacing.DOWN;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.9 - 0.05 * (double)this.type.getTier();
    }

    public void upgrade(TileEntityChargePadBase old) {
        int src;
        this.inv.setStackInSlot(0, old.inv.getStackInSlot(0));
        if (old.type.getTier() > 1) {
            this.inv.setStackInSlot(1, old.inv.getStackInSlot(1));
            this.inv.setStackInSlot(2, old.inv.getStackInSlot(2));
        }
        int n = src = old.type.getTier() > 1 ? 3 : 1;
        for (int dest = old.type.getTier() > 1 ? 3 : 1; src < old.inv.getSlotCount() && dest < this.inv.getSlotCount(); ++src, ++dest) {
            this.inv.setStackInSlot(dest, old.inv.getStackInSlot(src));
            old.inv.setStackInSlot(src, ItemStack.field_190927_a);
        }
        this.storedEnergy = old.storedEnergy;
        this.getNetwork().updateTileGuiField(this, "storedEnergy");
        old.setFacing(this.getFacing());
    }

    @Override
    public int getMaxEU() {
        return this.maxEnergy;
    }

    @Override
    public int getStoredEU() {
        return this.storedEnergy;
    }

    public static enum ChargePadType {
        LV(40, 1, 1, 3.5f, TileEntityChargePadLV.class, Ic2BlockLang.chargePadLV),
        MV(600, 2, 2, 2.5f, TileEntityChargePadMV.class, Ic2BlockLang.chargePadMV),
        HV(10000, 3, 3, 1.5f, TileEntityChargePadHV.class, Ic2BlockLang.chargePadHV),
        Nuclear(150000, 4, 3, 1.5f, TileEntityChargePadNuclear.class, Ic2BlockLang.chargePadFission);

        int maxEnergy;
        int tier;
        int upgradeSlots;
        float maxImpact;
        LocaleComp name;
        Class<? extends TileEntityChargePadBase> clz;

        private ChargePadType(int par1, int par2, int par3, float par4, Class<? extends TileEntityChargePadBase> par5, LocaleComp par6) {
            this.maxEnergy = par1 * 1000;
            this.tier = par2;
            this.upgradeSlots = par3;
            this.maxImpact = par4;
            this.clz = par5;
            this.name = par6;
        }

        public int getMaxEnergy() {
            return this.maxEnergy;
        }

        public int getTier() {
            return this.tier;
        }

        public int getUpgradeSlots() {
            return this.upgradeSlots;
        }

        public float getMaxImpact() {
            return this.maxImpact;
        }

        public TileEntityChargePadBase createPad() {
            if (this.clz == null) {
                return null;
            }
            try {
                return this.clz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static ChargePadType getType(int meta) {
            ChargePadType[] types = ChargePadType.values();
            if (meta >= 0 && meta < types.length) {
                return types[meta];
            }
            return null;
        }

        public LocaleComp getName() {
            return this.name;
        }

        public ChargePadType upgrade() {
            switch (this) {
                case LV: {
                    return MV;
                }
                case MV: {
                    return HV;
                }
                case HV: {
                    return Nuclear;
                }
                case Nuclear: {
                    return null;
                }
            }
            return null;
        }
    }

    public static enum PadUpgrade {
        Damage(false, true, 2),
        Drain(false, false, 2),
        Proximity(true, false, 2),
        WideBand(true, true, 2),
        ArmorPriority(false, false, 2),
        FieldExpI(true, false, 2),
        FieldExpII(true, false, 3),
        FieldExpIII(true, true, 3);

        public boolean isProject;
        public boolean isRare;
        public int requiredTier;

        private PadUpgrade(boolean par1, boolean par2, int par3) {
            this.isProject = par1;
            this.isRare = par2;
            this.requiredTier = par3;
        }
    }
}

