/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particles.ParticleCloud;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemEarthTalisman;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemNagaFangDagger;
import com.bobmowzie.mowziesmobs.server.item.ItemSpear;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerAttackMob;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerSolarBeam;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerSummonSunstrike;
import com.bobmowzie.mowziesmobs.server.message.MessageUnfreezeEntity;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageLeftMouseDown;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageLeftMouseUp;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageRightMouseDown;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageRightMouseUp;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.property.MowzieLivingProperties;
import com.bobmowzie.mowziesmobs.server.property.MowziePlayerProperties;
import com.bobmowzie.mowziesmobs.server.world.MowzieWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public enum ServerEventHandler {
    INSTANCE;

    private static final int ICE;
    private static final int SUNSTRIKE_COOLDOWN = 55;
    private static final int SOLARBEAM_COOLDOWN = 110;

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityZombie) {
            ((EntityCreature)entity).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityFoliaath.class, 0, true, false, null));
            ((EntityCreature)entity).field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarakoa.class, 0, true, false, null));
            ((EntityCreature)entity).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarako.class, 0, true, false, null));
        }
        if (entity instanceof EntitySkeleton) {
            ((EntityCreature)entity).field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarakoa.class, 0, true, false, null));
            ((EntityCreature)entity).field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityBarako.class, 0, true, false, null));
        }
        if (entity instanceof EntityOcelot) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityParrot) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityAnimal) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityBarakoa.class, 6.0f, 1.0, 1.2));
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof EntityVillager) {
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityBarakoa.class, 6.0f, 1.0, 1.2));
            ((EntityCreature)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            MowzieLivingProperties property = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, MowzieLivingProperties.class);
            if (property != null) {
                Item headItemStack;
                if (property.freezeProgress >= 1.0f) {
                    entity.func_70690_d(new PotionEffect((Potion)PotionHandler.FROZEN, 50, 0, false, false));
                    property.freezeProgress = 1.0f;
                } else if (property.freezeProgress > 0.0f) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 9, MathHelper.func_76141_d((float)(property.freezeProgress * 5.0f + 1.0f)), false, false));
                }
                if (entity.func_70644_a((Potion)PotionHandler.FROZEN) && !property.prevFrozen) {
                    property.onFreeze(entity);
                }
                if (!entity.field_70170_p.field_72995_K && (headItemStack = entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b()) instanceof ItemBarakoaMask) {
                    ItemBarakoaMask mask = (ItemBarakoaMask)headItemStack;
                    entity.func_70690_d(new PotionEffect(mask.getPotion(), 45, 0, true, false));
                }
            }
            if (entity.func_70660_b((Potion)PotionHandler.POISON_RESIST) != null && entity.func_70660_b(MobEffects.field_76436_u) != null) {
                entity.func_184596_c(MobEffects.field_76436_u);
            }
            if (entity.func_70644_a((Potion)PotionHandler.FROZEN)) {
                if (entity.func_70660_b((Potion)PotionHandler.FROZEN).func_76459_b() <= 0) {
                    entity.func_184596_c((Potion)PotionHandler.FROZEN);
                }
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, 50, false, false));
                entity.func_70095_a(false);
                if (entity.field_70170_p.field_72995_K && entity.field_70173_aa % 2 == 0) {
                    double cloudX = entity.field_70165_t + (double)(entity.field_70130_N * entity.func_70681_au().nextFloat()) - (double)(entity.field_70130_N / 2.0f);
                    double cloudZ = entity.field_70161_v + (double)(entity.field_70130_N * entity.func_70681_au().nextFloat()) - (double)(entity.field_70130_N / 2.0f);
                    double cloudY = entity.field_70163_u + (double)(entity.field_70131_O * entity.func_70681_au().nextFloat());
                    MMParticle.CLOUD.spawn(entity.field_70170_p, cloudX, cloudY, cloudZ, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{0.0, -0.01, 0.0, 0.75, 0.75, 1.0, 1, 15.0, 25, ParticleCloud.EnumCloudBehavior.CONSTANT}));
                    double snowX = entity.field_70165_t + (double)(entity.field_70130_N * entity.func_70681_au().nextFloat()) - (double)(entity.field_70130_N / 2.0f);
                    double snowZ = entity.field_70161_v + (double)(entity.field_70130_N * entity.func_70681_au().nextFloat()) - (double)(entity.field_70130_N / 2.0f);
                    double snowY = entity.field_70163_u + (double)(entity.field_70131_O * entity.func_70681_au().nextFloat());
                    MMParticle.SNOWFLAKE.spawn(entity.field_70170_p, snowX, snowY, snowZ, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(0.0, -0.01, 0.0));
                }
            } else if (property != null && property.frozenController != null && !property.frozenController.field_70128_L) {
                property.onUnfreeze(entity);
            }
            if (property != null) {
                if (property.freezeDecayDelay <= 0) {
                    property.freezeProgress = (float)((double)property.freezeProgress - 0.1);
                    if (property.freezeProgress < 0.0f) {
                        property.freezeProgress = 0.0f;
                    }
                } else {
                    --property.freezeDecayDelay;
                }
                property.prevFrozen = entity.func_70644_a((Potion)PotionHandler.FROZEN);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        EntityPlayer player = event.player;
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            property.update();
            if (property.untilSunstrike > 0) {
                --property.untilSunstrike;
            }
            if (property.untilAxeSwing > 0) {
                --property.untilAxeSwing;
            }
            if (event.side == Side.SERVER) {
                for (ItemStack itemStack : event.player.field_71071_by.field_70462_a) {
                    if (!(itemStack.func_77973_b() instanceof ItemEarthTalisman)) continue;
                    player.func_70690_d(new PotionEffect((Potion)PotionHandler.GEOMANCY, 0, 0, false, false));
                }
                if (player.func_184592_cb().func_77973_b() instanceof ItemEarthTalisman) {
                    player.func_70690_d(new PotionEffect((Potion)PotionHandler.GEOMANCY, 0, 0, false, false));
                }
                List<EntityBarakoanToPlayer> pack = property.tribePack;
                float theta = (float)Math.PI * 2 / (float)pack.size();
                for (int i = 0; i < pack.size(); ++i) {
                    EntityBarakoanToPlayer barakoan = (EntityBarakoanToPlayer)pack.get(i);
                    barakoan.index = i;
                    if (barakoan.func_70638_az() != null) continue;
                    if (barakoan.getAnimation() == EntityBarakoanToPlayer.DEACTIVATE_ANIMATION) continue;
                    barakoan.func_70661_as().func_75492_a(player.field_70165_t + (double)((float)property.tribePackRadius * MathHelper.func_76134_b((float)(theta * (float)i))), player.field_70163_u, player.field_70161_v + (double)((float)property.tribePackRadius * MathHelper.func_76126_a((float)(theta * (float)i))), 0.45);
                    if (!(player.func_70032_d((Entity)barakoan) > 20.0f) || !player.field_70122_E) continue;
                    this.tryTeleportBarakoan(player, barakoan);
                }
            }
            if (player.func_184614_ca().func_77973_b() != ItemHandler.ICE_CRYSTAL && player.func_184592_cb().func_77973_b() != ItemHandler.ICE_CRYSTAL && property.usingIceBreath && property.icebreath != null) {
                property.usingIceBreath = false;
                property.icebreath.func_70106_y();
            }
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (property.usingIceBreath || stack.func_77973_b() != ItemHandler.ICE_CRYSTAL) continue;
                stack.func_77964_b(Math.max(stack.func_77952_i() - 1, 0));
            }
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (property.usingIceBreath || stack.func_77973_b() != ItemHandler.ICE_CRYSTAL) continue;
                stack.func_77964_b(Math.max(stack.func_77952_i() - 1, 0));
            }
            if (event.side == Side.CLIENT) {
                if (Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && !property.mouseLeftDown) {
                    property.mouseLeftDown = true;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageLeftMouseDown());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onLeftMouseDown(player);
                    }
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !property.mouseRightDown) {
                    property.mouseRightDown = true;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageRightMouseDown());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onRightMouseDown(player);
                    }
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && property.mouseLeftDown) {
                    property.mouseLeftDown = false;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageLeftMouseUp());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onLeftMouseUp(player);
                    }
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && property.mouseRightDown) {
                    property.mouseRightDown = false;
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessageRightMouseUp());
                    for (int i = 0; i < property.powers.length; ++i) {
                        property.powers[i].onRightMouseUp(player);
                    }
                }
            }
            if (player.func_70093_af() && !property.prevSneaking) {
                for (int i = 0; i < property.powers.length; ++i) {
                    property.powers[i].onSneakDown(player);
                }
            } else if (!player.func_70093_af() && property.prevSneaking) {
                for (int i = 0; i < property.powers.length; ++i) {
                    property.powers[i].onSneakUp(player);
                }
            }
            property.prevSneaking = player.func_70093_af();
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onUpdate(event);
            }
        }
    }

    private void tryTeleportBarakoan(EntityPlayer player, EntityBarakoanToPlayer barakoan) {
        int x = MathHelper.func_76128_c((double)player.field_70165_t) - 2;
        int z = MathHelper.func_76128_c((double)player.field_70161_v) - 2;
        int y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b);
        for (int l = 0; l <= 4; ++l) {
            for (int i1 = 0; i1 <= 4; ++i1) {
                if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !barakoan.isTeleportFriendlyBlock(x, z, y, l, i1)) continue;
                barakoan.func_70012_b((float)(x + l) + 0.5f, y, (float)(z + i1) + 0.5f, barakoan.field_70177_z, barakoan.field_70125_A);
                barakoan.func_70661_as().func_75499_g();
                return;
            }
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            ItemStack item = event.getItem();
            if (item.func_77973_b() == Items.field_151033_d) {
                List<EntityBarako> barakos = this.getEntitiesNearby((EntityLivingBase)player, EntityBarako.class, 20.0);
                for (EntityBarako barako : barakos) {
                    if (barako.func_70638_az() != null && barako.func_70638_az() instanceof EntityPlayer || !EntityAITarget.func_179445_a((EntityLiving)barako, (EntityLivingBase)player, (boolean)false, (boolean)false)) continue;
                    barako.func_70624_b((EntityLivingBase)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        IBlockState block = event.getPlacedBlock();
        if (block == Blocks.field_150480_ab.func_176223_P()) {
            List<EntityBarako> barakos = this.getEntitiesNearby((EntityLivingBase)player, EntityBarako.class, 20.0);
            for (EntityBarako barako : barakos) {
                if (barako.func_70638_az() != null && barako.func_70638_az() instanceof EntityPlayer || !EntityAITarget.func_179445_a((EntityLiving)barako, (EntityLivingBase)player, (boolean)false, (boolean)false)) continue;
                barako.func_70624_b((EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && event.getEmptyBucket() != null && event.getEmptyBucket().func_77973_b() == Items.field_151129_at) {
            List<EntityBarako> barakos = this.getEntitiesNearby((EntityLivingBase)player, EntityBarako.class, 20.0);
            for (EntityBarako barako : barakos) {
                if (barako.func_70638_az() != null && barako.func_70638_az() instanceof EntityPlayer || !EntityAITarget.func_179445_a((EntityLiving)barako, (EntityLivingBase)player, (boolean)false, (boolean)false)) continue;
                barako.func_70624_b((EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        IBlockState block = event.getState();
        if (block == Blocks.field_150340_R.func_176223_P()) {
            List<EntityBarako> barakos = this.getEntitiesNearby((EntityLivingBase)player, EntityBarako.class, 10.0);
            for (EntityBarako barako : barakos) {
                if (barako.func_70638_az() != null && barako.func_70638_az() instanceof EntityPlayer || !EntityAITarget.func_179445_a((EntityLiving)barako, (EntityLivingBase)player, (boolean)false, (boolean)false)) continue;
                barako.func_70624_b((EntityLivingBase)player);
            }
        }
    }

    public <T extends Entity> List<T> getEntitiesNearby(EntityLivingBase startEntity, Class<T> entityClass, double r) {
        return startEntity.field_70170_p.func_175647_a(entityClass, startEntity.func_174813_aQ().func_72314_b(r, r, r), e -> e != startEntity && (double)startEntity.func_70032_d(e) <= r);
    }

    private List<EntityLivingBase> getEntityLivingBaseNearby(EntityLivingBase user, double distanceX, double distanceY, double distanceZ, double radius) {
        List list = user.field_70170_p.func_72839_b((Entity)user, user.func_174813_aQ().func_72314_b(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof EntityLivingBase && (double)user.func_70032_d(entityNeighbor) <= radius).map(entityNeighbor -> (EntityLivingBase)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        EntityPlayer player;
        MowziePlayerProperties property;
        if (event.isCancelable() && event.getEntityLiving().func_70644_a((Potion)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if ((property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)(player = event.getEntityPlayer()), MowziePlayerProperties.class)) != null) {
            if (event.getWorld().field_72995_K && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Potion)PotionHandler.SUNS_BLESSING) && ((MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class)).untilSunstrike <= 0) {
                if (player.func_70093_af()) {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSolarBeam());
                    property.untilSunstrike = 110;
                } else {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSummonSunstrike());
                    property.untilSunstrike = 55;
                }
            }
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        MowziePlayerProperties property;
        if (event.isCancelable() && event.getEntityLiving().func_70644_a((Potion)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if ((property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickEntity(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            if (event.getWorld().field_72995_K && player.field_71071_by.func_70448_g().func_190926_b() && player.func_70644_a((Potion)PotionHandler.SUNS_BLESSING) && ((MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class)).untilSunstrike <= 0) {
                if (player.func_70093_af()) {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSolarBeam());
                    property.untilSunstrike = 110;
                } else {
                    MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerSummonSunstrike());
                    property.untilSunstrike = 55;
                }
            }
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        double range = 6.5;
        EntityPlayer player = event.getEntityPlayer();
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (property != null) {
            EntityLivingBase entityHit;
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ItemHandler.SPEAR && (entityHit = ItemSpear.raytraceEntities(player.func_130014_f_(), player, range)) != null) {
                MowziesMobs.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerAttackMob(entityHit));
            }
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onLeftClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        MowziePlayerProperties property;
        if (event.getSource().func_76347_k() && event.getEntityLiving().func_70644_a((Potion)PotionHandler.FROZEN)) {
            event.getEntityLiving().func_184596_c((Potion)PotionHandler.FROZEN);
            MowziesMobs.NETWORK_WRAPPER.sendToDimension((IMessage)new MessageUnfreezeEntity(event.getEntityLiving()), event.getEntityLiving().field_71093_bK);
        }
        if (event.getEntity() instanceof EntityPlayer && (property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onTakeDamage(event);
            }
        }
        if (event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            Vec3d vecBetween;
            Vec3d lookDir;
            double dot;
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            EntityLivingBase target = event.getEntityLiving();
            ItemStack weapon = attacker.func_184614_ca();
            if (weapon != null && weapon.func_77973_b() instanceof ItemNagaFangDagger && (dot = (lookDir = new Vec3d(target.func_70040_Z().field_72450_a, 0.0, target.func_70040_Z().field_72449_c).func_72432_b()).func_72430_b(vecBetween = new Vec3d(target.field_70165_t - attacker.field_70165_t, 0.0, target.field_70161_v - attacker.field_70161_v).func_72432_b())) > 0.7) {
                event.setAmount(event.getAmount() + 3.0f * ConfigHandler.TOOLS_AND_ABILITIES.nagaDaggerAttackMultiplier);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        MowziePlayerProperties property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class);
        if (property != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onRightClickWithItem(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        MowziePlayerProperties property;
        if (event.isCancelable() && event.getEntityPlayer().func_70644_a((Potion)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if ((property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onLeftClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        MowziePlayerProperties property;
        EntityLivingBase entity;
        MowzieLivingProperties property2;
        if (event.getEntity() instanceof EntityLivingBase && (property2 = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)(entity = (EntityLivingBase)event.getEntity()), MowzieLivingProperties.class)) != null && entity.func_70644_a((Potion)PotionHandler.FROZEN) && entity.field_70122_E) {
            entity.field_70181_x = 0.0;
        }
        if (event.getEntity() instanceof EntityPlayer && (property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            for (int i = 0; i < property.powers.length; ++i) {
                property.powers[i].onJump(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        MowziePlayerProperties property;
        if (event.isCancelable() && event.getEntityLiving().func_70644_a((Potion)PotionHandler.FROZEN)) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof EntityPlayer && (property = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties(event.getEntity(), MowziePlayerProperties.class)) != null) {
            int i;
            for (i = 0; i < property.powers.length; ++i) {
                property.powers[i].onLeftClickEntity(event);
            }
            if (!(event.getTarget() instanceof EntityLivingBase)) {
                return;
            }
            if (event.getTarget() instanceof EntityBarakoanToPlayer) {
                return;
            }
            for (i = 0; i < property.getPackSize(); ++i) {
                property.tribePack.get(i).func_70624_b((EntityLivingBase)event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public void prePopulateWorld(PopulateChunkEvent.Pre event) {
        MowzieWorldGenerator.generatePrePopulate(event.getWorld(), event.getRand(), event.getChunkX(), event.getChunkZ());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mowziesmobs")) {
            ConfigManager.sync((String)"mowziesmobs", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        ICE = Block.func_176210_f((IBlockState)Blocks.field_150432_aD.func_176223_P());
    }
}

