/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.naga;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.DynamicChain;
import com.bobmowzie.mowziesmobs.client.particles.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.server.ai.MMAINearestAttackableTarget;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationProjectileAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityPoisonBall;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNaga
extends MowzieEntity
implements IRangedAttackMob,
IMob {
    @SideOnly(value=Side.CLIENT)
    public DynamicChain dc;
    @SideOnly(value=Side.CLIENT)
    public Vec3d[] mouthPos;
    public static final Animation FLAP_ANIMATION = Animation.create((int)25);
    public static final Animation DODGE_ANIMATION = Animation.create((int)10);
    public static final Animation SPIT_ANIMATION = Animation.create((int)50);
    public static final Animation SWOOP_ANIMATION = Animation.create((int)54);
    public static final Animation HURT_TO_FALL_ANIMATION = Animation.create((int)20);
    public static final Animation LAND_ANIMATION = Animation.create((int)8);
    public static final Animation GET_UP_ANIMATION = Animation.create((int)33);
    public static final Animation TAIL_DEMO_ANIMATION = Animation.create((int)80);
    public static final Animation DIE_AIR_ANIMATION = Animation.create((int)70);
    public static final Animation DIE_GROUND_ANIMATION = Animation.create((int)70);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityNaga.class, (DataSerializer)DataSerializers.field_187198_h);
    private ControlledAnimation hoverAnim = new ControlledAnimation(10);
    private ControlledAnimation flapAnim = new ControlledAnimation(10);
    public float hoverAnimFrac;
    public float prevHoverAnimFrac;
    public float flapAnimFrac;
    public float prevFlapAnimFrac;
    private boolean hasFlapSoundPlayed = false;
    @SideOnly(value=Side.CLIENT)
    public float shoulderRot;
    public static final int ROAR_DURATION = 30;
    public int roarAnimation = 0;
    public EnumNagaMovement movement = EnumNagaMovement.GLIDING;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public static int SPIT_COOLDOWN_MAX = 120;
    public int spitCooldown = 0;
    public static int SWOOP_COOLDOWN_MAX = 90;
    public int swoopCooldown = 0;
    public float swoopTargetCorrectY;
    public float swoopTargetCorrectX;
    public static int GROUND_TIMER_MAX = 60;
    public int onGroundTimer = 0;
    public boolean interrupted = false;

    public EntityNaga(World world) {
        super(world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIFlyAroundTarget(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new MMAINearestAttackableTarget<EntityPlayer>(this, EntityPlayer.class, 0, true, false, true, null));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SimpleAnimationAI<EntityNaga>(this, FLAP_ANIMATION, false){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a(MMSounds.ENTITY_NAGA_FLAP_1, 2.0f, (float)(0.85 + (double)EntityNaga.this.field_70146_Z.nextFloat() * 0.2));
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.getAnimationTick() >= 4 && EntityNaga.this.getAnimationTick() <= 9) {
                    EntityNaga.this.field_70181_x += 0.1;
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityNaga>(this, DODGE_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AnimationProjectileAttackAI<EntityNaga>(this, SPIT_ANIMATION, 30, null){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a(MMSounds.ENTITY_NAGA_ACID_CHARGE, 2.0f, 1.0f);
            }

            @Override
            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                if (EntityNaga.this.getAnimationTick() < 9) {
                    EntityNaga.this.field_70181_x += 0.015;
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SimpleAnimationAI<EntityNaga>(this, SWOOP_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a(MMSounds.ENTITY_NAGA_FLAP_1, 2.0f, 0.7f);
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                Vec3d v = new Vec3d(0.0, 0.0, 0.0);
                int phase1Length = 15;
                int phase2Length = 21;
                if (EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                    EntityLivingBase target = EntityNaga.this.func_70638_az();
                    if (EntityNaga.this.getAnimationTick() >= 1 && EntityNaga.this.getAnimationTick() < 1 + phase1Length) {
                        float frame = (float)(EntityNaga.this.getAnimationTick() - 1) / (float)phase1Length;
                        v = v.func_178787_e(new Vec3d((double)1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)-1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)0.8f * Math.sin((double)frame * Math.PI * 2.0)));
                    } else if (EntityNaga.this.getAnimationTick() >= 16) {
                        if (target != null) {
                            ((EntityNaga)this.entity).func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                        }
                        if (EntityNaga.this.getAnimationTick() == 23) {
                            if (target != null) {
                                EntityNaga.this.swoopTargetCorrectY = 0.09f * (float)Math.abs(EntityNaga.this.field_70163_u - target.field_70163_u);
                                EntityNaga.this.swoopTargetCorrectX = 0.1f * (float)Math.sqrt((EntityNaga.this.field_70165_t - target.field_70165_t) * (EntityNaga.this.field_70165_t - target.field_70165_t) + (EntityNaga.this.field_70161_v - target.field_70161_v) * (EntityNaga.this.field_70161_v - target.field_70161_v));
                                if (EntityNaga.this.swoopTargetCorrectX > 1.8f) {
                                    EntityNaga.this.swoopTargetCorrectX = 1.8f;
                                }
                                if (EntityNaga.this.swoopTargetCorrectY > 2.0f) {
                                    EntityNaga.this.swoopTargetCorrectY = 2.0f;
                                }
                            } else {
                                EntityNaga.this.swoopTargetCorrectY = 1.0f;
                                EntityNaga.this.swoopTargetCorrectX = 1.0f;
                            }
                        }
                        if (EntityNaga.this.getAnimationTick() >= 23 && EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                            float frame = (float)(EntityNaga.this.getAnimationTick() - 23) / (float)phase2Length;
                            v = v.func_178787_e(new Vec3d((double)EntityNaga.this.swoopTargetCorrectX * 1.4 * (1.0 - Math.exp(2.0f * (frame - 1.0f))), (double)EntityNaga.this.swoopTargetCorrectY * -1.5 * (Math.cos((double)frame * Math.PI) * (1.0 - Math.exp(7.0f * (frame - 1.0f)))), 0.0));
                            List<EntityLivingBase> entitiesHit = EntityNaga.this.getEntityLivingBaseNearby(4.0, 4.0, 4.0, 4.0);
                            for (EntityLivingBase entityHit : entitiesHit) {
                                if (entityHit instanceof EntityNaga) continue;
                                EntityNaga.this.func_70652_k((Entity)entityHit);
                            }
                        }
                    }
                    v = v.func_178785_b((float)Math.toRadians(-EntityNaga.this.field_70177_z - 90.0f));
                    EntityNaga.this.field_70159_w = v.field_72450_a;
                    EntityNaga.this.field_70181_x = v.field_72448_b;
                    EntityNaga.this.field_70179_y = v.field_72449_c;
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    MowziesMobs.PROXY.playNagaSwoopSound((EntityNaga)this.entity);
                }
                if (EntityNaga.this.getAnimationTick() == 7) {
                    EntityNaga.this.func_184185_a(MMSounds.ENTITY_NAGA_GRUNT_3, 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    EntityNaga.this.func_184185_a(MMSounds.ENTITY_NAGA_ROAR_1, 3.0f, 1.0f);
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SimpleAnimationAI<EntityNaga>(this, HURT_TO_FALL_ANIMATION, true){

            public void func_75246_d() {
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SimpleAnimationAI<EntityNaga>(this, LAND_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a(MMSounds.MISC_GROUNDHIT_2, 1.5f, 1.0f);
            }
        });
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SimpleAnimationAI<EntityNaga>(this, GET_UP_ANIMATION, true){

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.getAnimationTick() == 13) {
                    EntityNaga.this.func_184185_a(MMSounds.ENTITY_NAGA_FLAP_1, 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 15) {
                    EntityNaga.this.field_70181_x += (double)1.6f;
                }
            }
        });
        this.field_70765_h = new NagaMoveHelper(this);
        this.func_70105_a(3.0f, 1.0f);
        if (world.field_72995_K) {
            this.dc = new DynamicChain((Entity)this);
            this.mouthPos = new Vec3d[]{new Vec3d(0.0, 0.0, 0.0)};
        }
        this.field_70728_aV = 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACKING, (Object)false);
    }

    public boolean func_70112_a(double distance) {
        return distance < 16600.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(12.0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * (double)ConfigHandler.NAGA.combatData.healthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 * (double)ConfigHandler.NAGA.combatData.attackMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(45.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.getAnimation() != NO_ANIMATION) {
            return null;
        }
        int r = this.field_70146_Z.nextInt(4);
        if (r == 0) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_ROAR.get(this.field_70146_Z.nextInt(4))).get(), 5.0f, 1.0f);
            this.roarAnimation = 0;
        } else if (r <= 2) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_GROWL.get(this.field_70146_Z.nextInt(3))).get(), 4.0f, 1.0f);
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_GRUNT.get(this.field_70146_Z.nextInt(3))).get(), 2.0f, 1.0f);
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_ROAR.get(this.field_70146_Z.nextInt(4))).get(), 3.0f, 1.0f);
        return null;
    }

    @Override
    public void func_70071_h_() {
        this.prevMotionX = this.field_70159_w;
        this.prevMotionY = this.field_70181_x;
        this.prevMotionZ = this.field_70179_y;
        this.prevHoverAnimFrac = this.hoverAnimFrac;
        this.prevFlapAnimFrac = this.flapAnimFrac;
        super.func_70071_h_();
        this.field_70761_aq = this.field_70177_z;
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
        }
        if (this.swoopCooldown > 0) {
            --this.swoopCooldown;
        }
        if (this.onGroundTimer > 0) {
            --this.onGroundTimer;
        }
        if (this.roarAnimation < 30) {
            ++this.roarAnimation;
        }
        if (this.getAnimation() == null) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, NO_ANIMATION);
        }
        if (this.func_70644_a(MobEffects.field_76436_u)) {
            this.func_184596_c(MobEffects.field_76436_u);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && (double)this.targetDistance < 29.5 && this.movement != EnumNagaMovement.FALLEN && this.movement != EnumNagaMovement.FALLING) {
                this.setAttacking(true);
                if (this.getAnimation() == NO_ANIMATION && this.swoopCooldown == 0 && this.field_70146_Z.nextInt(80) == 0 && this.field_70163_u - this.func_70638_az().field_70163_u > 0.0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SWOOP_ANIMATION);
                    this.swoopCooldown = SWOOP_COOLDOWN_MAX;
                } else if (this.getAnimation() == NO_ANIMATION && this.spitCooldown == 0 && this.field_70146_Z.nextInt(80) == 0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SPIT_ANIMATION);
                    this.spitCooldown = SPIT_COOLDOWN_MAX;
                }
            } else {
                this.setAttacking(false);
            }
        }
        if (this.movement != EnumNagaMovement.FALLING && this.movement != EnumNagaMovement.FALLEN) {
            if (this.getAttacking()) {
                this.movement = EnumNagaMovement.HOVERING;
                this.hoverAnim.increaseTimer();
                if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                    List<EntityArrow> arrowsNearby = this.getEntitiesNearby(EntityArrow.class, 30.0);
                    for (EntityArrow a : arrowsNearby) {
                        Vec3d aMotion;
                        float dot;
                        Vec3d aActualMotion = new Vec3d(a.field_70165_t - a.field_70169_q, a.field_70163_u - a.field_70167_r, a.field_70161_v - a.field_70166_s);
                        if (aActualMotion.func_72433_c() < 0.1 || a.field_70173_aa <= 1 || !((double)(dot = (float)(aMotion = new Vec3d(a.field_70159_w, a.field_70181_x, a.field_70179_y)).func_72432_b().func_72430_b(this.func_174791_d().func_178788_d(a.func_174791_d()).func_72432_b())) > 0.96)) continue;
                        Vec3d dodgeVec = aMotion.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b().func_186678_a(1.2);
                        Vec3d newPosLeft = this.func_174791_d().func_178787_e(dodgeVec.func_186678_a(2.0));
                        Vec3d newPosRight = this.func_174791_d().func_178787_e(dodgeVec.func_186678_a(-2.0));
                        Vec3d diffLeft = newPosLeft.func_178788_d(a.func_174791_d());
                        Vec3d diffRight = newPosRight.func_178788_d(a.func_174791_d());
                        if (diffRight.func_72430_b(aMotion) > diffLeft.func_72430_b(aMotion)) {
                            dodgeVec = dodgeVec.func_186678_a(-1.0);
                        }
                        this.field_70159_w += dodgeVec.field_72450_a;
                        this.field_70181_x += dodgeVec.field_72448_b;
                        this.field_70179_y += dodgeVec.field_72449_c;
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, DODGE_ANIMATION);
                    }
                }
            } else {
                this.movement = EnumNagaMovement.GLIDING;
                this.hoverAnim.decreaseTimer();
                this.flapAnim.decreaseTimer();
            }
        } else if (this.movement == EnumNagaMovement.FALLING && this.field_70122_E) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LAND_ANIMATION);
            this.movement = EnumNagaMovement.FALLEN;
            this.onGroundTimer = GROUND_TIMER_MAX;
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.func_70661_as().func_75499_g();
        }
        if (this.movement == EnumNagaMovement.FALLEN && this.onGroundTimer <= 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimationTick(0);
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, GET_UP_ANIMATION);
        }
        if (this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 43) {
            this.hoverAnim.increaseTimer();
            this.flapAnim.decreaseTimer();
        } else if (this.getAnimation() == HURT_TO_FALL_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == LAND_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() < 26) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.movement == EnumNagaMovement.FALLEN) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
            this.field_70177_z = this.field_70126_B;
            this.field_70759_as = this.field_70758_at;
            this.field_70125_A = this.field_70127_C;
        } else if (this.movement == EnumNagaMovement.FALLING) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else {
            this.flapAnim.increaseTimer();
        }
        if (this.getAnimation() == SPIT_ANIMATION && this.field_70170_p.field_72995_K && this.mouthPos != null && !this.interrupted) {
            Vec3d particlePos;
            if (this.getAnimationTick() == 33) {
                float explodeSpeed = 2.4f;
                for (int i = 0; i < 25; ++i) {
                    particlePos = new Vec3d(0.25, 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    double value = this.field_70146_Z.nextFloat() * 0.1f;
                    double life = this.field_70146_Z.nextFloat() * 10.0f + 20.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, particlePos.field_72450_a + this.mouthPos[0].field_72450_a, particlePos.field_72448_b + this.mouthPos[0].field_72448_b, particlePos.field_72449_c + this.mouthPos[0].field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                }
            }
            if (this.getAnimationTick() <= 15 && this.mouthPos != null && !this.interrupted) {
                int howMany = 4;
                for (int i = 0; i < howMany; ++i) {
                    particlePos = new Vec3d(3.0, 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    double value = this.field_70146_Z.nextFloat() * 0.15f;
                    ParticleVanillaCloudExtended.spawnVanillaCloudDestination(this.field_70170_p, particlePos.field_72450_a + this.mouthPos[0].field_72450_a, particlePos.field_72448_b + this.mouthPos[0].field_72448_b, particlePos.field_72449_c + this.mouthPos[0].field_72449_c, 0.0, 0.0, 0.0, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.9, 15.0, this.mouthPos);
                }
            }
        }
        if (this.getAnimation() == HURT_TO_FALL_ANIMATION && this.getAnimationTick() == 17) {
            this.movement = EnumNagaMovement.FALLING;
        }
        if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() == 26) {
            this.movement = EnumNagaMovement.HOVERING;
        }
        if (this.field_70170_p.field_72995_K && this.movement == EnumNagaMovement.HOVERING && (double)this.flapAnim.getAnimationFraction() >= 0.5) {
            if ((double)this.shoulderRot > 0.9) {
                this.hasFlapSoundPlayed = false;
            }
            if ((double)this.shoulderRot <= 0.7 && !this.hasFlapSoundPlayed) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, MMSounds.ENTITY_NAGA_FLAP_1, SoundCategory.HOSTILE, 2.0f, (float)(0.85 + (double)this.field_70146_Z.nextFloat() * 0.2), false);
                this.hasFlapSoundPlayed = true;
            }
        }
        this.hoverAnimFrac = this.hoverAnim.getAnimationProgressSinSqrt();
        this.flapAnimFrac = this.flapAnim.getAnimationProgressSinSqrt();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    protected ConfigHandler.SpawnData getSpawnConfig() {
        return ConfigHandler.NAGA.spawnData;
    }

    @Override
    public boolean func_70601_bi() {
        boolean flag = super.func_70601_bi();
        this.func_70107_b(this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v);
        return flag && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public boolean func_70058_J() {
        boolean liquid = !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        boolean worldCollision = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
        boolean mobCollision = this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
        return liquid && worldCollision && mobCollision;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        if (this.field_70725_aQ == 15 && this.movement != EnumNagaMovement.FALLEN) {
            this.movement = EnumNagaMovement.FALLING;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        boolean isSwooping;
        boolean flag = super.func_70097_a(source, damage);
        boolean isSpitting = this.getAnimation() == SPIT_ANIMATION && this.getAnimationTick() < 30;
        boolean bl = isSwooping = this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 25;
        if (flag && this.movement != EnumNagaMovement.FALLING && (isSpitting || isSwooping)) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HURT_TO_FALL_ANIMATION);
            this.interrupted = true;
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.interrupted) {
            return;
        }
        Vec3d projectilePos = new Vec3d(1.0, -0.7, 0.0);
        projectilePos = projectilePos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
        projectilePos = projectilePos.func_178787_e(this.func_174791_d());
        projectilePos = projectilePos.func_178787_e(new Vec3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
        projectilePos = projectilePos.func_178787_e(new Vec3d(0.0, 0.0, 0.0));
        EntityPoisonBall poisonBall = new EntityPoisonBall(this.field_70170_p, (EntityLivingBase)this);
        poisonBall.func_70107_b(projectilePos.field_72450_a, projectilePos.field_72448_b, projectilePos.field_72449_c);
        Vec3d look = this.func_70040_Z();
        Vec3d dir = new Vec3d(look.field_72450_a, 0.0, look.field_72449_c).func_72432_b();
        if (target != null) {
            float dy = (float)(projectilePos.field_72448_b - target.field_70163_u);
            float dx = (float)(projectilePos.field_72450_a - target.field_70165_t);
            float dz = (float)(projectilePos.field_72449_c - target.field_70161_v);
            float dist = (float)Math.sqrt(dx * dx + dz * dz);
            float timeGuess = (float)Math.sqrt(2.0f * dy / EntityPoisonBall.GRAVITY);
            float speed = Math.min(dist / timeGuess, 0.9f);
            poisonBall.func_70186_c(dir.field_72450_a * (double)speed, 0.1, dir.field_72449_c * (double)speed, 1.0f, 0.0f);
        }
        this.field_70170_p.func_72838_d((Entity)poisonBall);
        this.func_184185_a(MMSounds.ENTITY_NAGA_ACID_SPIT, 2.0f, 1.0f);
        this.func_184185_a(MMSounds.ENTITY_NAGA_ACID_SPIT_HISS, 2.0f, 1.0f);
    }

    @Override
    public Animation getDeathAnimation() {
        if (this.movement == EnumNagaMovement.FALLEN) {
            return DIE_GROUND_ANIMATION;
        }
        return DIE_AIR_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.NAGA;
    }

    public Animation[] getAnimations() {
        return new Animation[]{FLAP_ANIMATION, DODGE_ANIMATION, SWOOP_ANIMATION, SPIT_ANIMATION, HURT_TO_FALL_ANIMATION, LAND_ANIMATION, GET_UP_ANIMATION, DIE_AIR_ANIMATION, DIE_GROUND_ANIMATION, TAIL_DEMO_ANIMATION};
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.movement == EnumNagaMovement.FALLING) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (this.movement == EnumNagaMovement.FALLING) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_191986_a(float strafe, float upward, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, upward, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70181_x = 1.0;
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, upward, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else if (this.movement == EnumNagaMovement.HOVERING) {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, upward, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
            EntityMoveHelper entitymovehelper = this.func_70605_aq();
            double dx = entitymovehelper.func_179917_d() - this.field_70165_t;
            double dy = entitymovehelper.func_179919_e() - this.field_70163_u;
            double dz = entitymovehelper.func_179918_f() - this.field_70161_v;
            double distanceToDest = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distanceToDest < 0.1 && this.getAnimation() == NO_ANIMATION) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
        } else if (this.movement == EnumNagaMovement.GLIDING) {
            if (this.field_70181_x > -0.5) {
                this.field_70143_R = 1.0f;
            }
            Vec3d vec3d = this.func_70040_Z();
            float f = this.field_70125_A * ((float)Math.PI / 180);
            double d6 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
            double d8 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            double d1 = vec3d.func_72433_c();
            float f4 = MathHelper.func_76134_b((float)f);
            f4 = (float)((double)f4 * (double)f4 * Math.min(1.0, d1 / 0.4));
            this.field_70181_x += -0.08 + (double)f4 * 0.06;
            if (this.field_70181_x < 0.0 && d6 > 0.0) {
                double d2 = this.field_70181_x * -0.1 * (double)f4;
                this.field_70181_x += d2;
                this.field_70159_w += vec3d.field_72450_a * d2 / d6;
                this.field_70179_y += vec3d.field_72449_c * d2 / d6;
            }
            if (f < 0.0f) {
                double d10 = d8 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                this.field_70181_x += d10 * 3.2;
                this.field_70159_w -= vec3d.field_72450_a * d10 / d6;
                this.field_70179_y -= vec3d.field_72449_c * d10 / d6;
            }
            if (d6 > 0.0) {
                this.field_70159_w += (vec3d.field_72450_a / d6 * d8 - this.field_70159_w) * 0.1;
                this.field_70179_y += (vec3d.field_72449_c / d6 * d8 - this.field_70179_y) * 0.1;
            }
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.99f;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.func_70605_aq().func_179919_e() - this.field_70163_u > 0.0 && this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, FLAP_ANIMATION);
            }
            if (this.field_70123_F && !this.field_70170_p.field_72995_K) {
                double d11 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                double d3 = d8 - d11;
                float f2 = (float)(d3 * 10.0 - 3.0);
            }
            if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                this.func_70052_a(7, false);
            }
        } else if (this.movement == EnumNagaMovement.FALLING || this.movement == EnumNagaMovement.FALLEN || this.func_175446_cd()) {
            float f6 = 0.91f;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
            if (this.field_70122_E) {
                IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                f6 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)this) * 0.91f;
            }
            float f7 = 0.16277136f / (f6 * f6 * f6);
            if (this.field_70122_E) {
                float f8 = this.func_70689_ay() * f7;
            } else {
                float f8 = this.field_70747_aH;
            }
            f6 = 0.91f;
            if (this.field_70122_E) {
                IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v));
                f6 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)this) * 0.91f;
            }
            if (this.func_70617_f_()) {
                float f9 = 0.15f;
                this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.15f, (double)0.15f);
                this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.15f, (double)0.15f);
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && this.func_70617_f_()) {
                this.field_70181_x = 0.2;
            }
            if (this.func_70644_a(MobEffects.field_188424_y)) {
                this.field_70181_x += (0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x) * 0.2;
            } else {
                blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.08;
                    }
                } else {
                    this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                }
            }
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)f6;
            this.field_70179_y *= (double)f6;
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean getAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.func_184212_Q().func_187227_b(ATTACKING, (Object)attacking);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    static class NagaMoveHelper
    extends EntityMoveHelper {
        private final EntityNaga parentEntity;
        private int courseChangeCooldown;

        public NagaMoveHelper(EntityNaga naga) {
            super((EntityLiving)naga);
            this.parentEntity = naga;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(7) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty() || this.parentEntity.field_70170_p.func_72953_d(axisalignedbb)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIFlyAroundTarget
    extends EntityAIBase {
        private final EntityNaga parentEntity;

        public AIFlyAroundTarget(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.parentEntity.func_70638_az() != null) {
                if (!entitymovehelper.func_75640_a()) {
                    return true;
                }
                double dx = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
                double dy = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u;
                double dz = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v;
                double distanceToDest = Math.sqrt(dx * dx + dy * dy + dz * dz);
                EntityLivingBase target = this.parentEntity.func_70638_az();
                double dx2 = entitymovehelper.func_179917_d() - target.field_70165_t;
                double dy2 = entitymovehelper.func_179919_e() - target.field_70163_u;
                double dz2 = entitymovehelper.func_179918_f() - target.field_70161_v;
                double distanceDestToTarget = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
                boolean randomChance = this.parentEntity.field_70146_Z.nextInt(60) == 0;
                return distanceToDest > 60.0 || distanceDestToTarget > 20.0 || distanceDestToTarget < 5.0 || randomChance;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            EntityLivingBase target = this.parentEntity.func_70638_az();
            float yaw = (float)((double)random.nextFloat() * Math.PI * 2.0);
            float radius = 16.0f;
            double d0 = target.field_70165_t + Math.cos(yaw) * (double)radius;
            double d1 = target.field_70163_u + 8.0 + (double)(random.nextFloat() * 5.0f);
            double d2 = target.field_70161_v + Math.sin(yaw) * (double)radius;
            double speed = this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, speed);
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityNaga parentEntity;

        public AIRandomFly(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.parentEntity.getAttacking()) {
                return false;
            }
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 24.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 24.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityNaga parentEntity;

        public AILookAround(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    public static enum EnumNagaMovement {
        GLIDING,
        HOVERING,
        SWIMMING,
        FALLING,
        FALLEN;

    }
}

