/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.main;

import com.erigitic.commands.AdminPayCommand;
import com.erigitic.commands.BalanceCommand;
import com.erigitic.commands.BalanceTopCommand;
import com.erigitic.commands.JobCommand;
import com.erigitic.commands.PayCommand;
import com.erigitic.commands.SetBalanceCommand;
import com.erigitic.commands.ShopCommand;
import com.erigitic.commands.ViewBalanceCommand;
import com.erigitic.config.AccountManager;
import com.erigitic.config.TECurrency;
import com.erigitic.config.TECurrencyRegistryModule;
import com.erigitic.jobs.JobManager;
import com.erigitic.shops.PlayerShopInfo;
import com.erigitic.shops.Shop;
import com.erigitic.shops.ShopItem;
import com.erigitic.shops.ShopManager;
import com.erigitic.shops.data.ImmutablePlayerShopInfoData;
import com.erigitic.shops.data.ImmutableShopData;
import com.erigitic.shops.data.ImmutableShopItemData;
import com.erigitic.shops.data.PlayerShopInfoData;
import com.erigitic.shops.data.ShopData;
import com.erigitic.shops.data.ShopItemData;
import com.erigitic.shops.data.ShopKeys;
import com.erigitic.sql.SqlManager;
import com.erigitic.util.MessageManager;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;

@Plugin(id="totaleconomy", name="Total Economy", version="1.8.1", description="All in one economy plugin for Minecraft/Sponge")
public class TotalEconomy {
    @Inject
    private Logger logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private File configDir;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private File defaultConf;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    @Inject
    private Game game;
    @Inject
    private PluginContainer pluginContainer;
    private UserStorageService userStorageService;
    private ConfigurationNode config;
    private TECurrency defaultCurrency;
    private SqlManager sqlManager;
    private AccountManager accountManager;
    private JobManager jobManager;
    private MessageManager messageManager;
    private ShopManager shopManager;
    private TECurrencyRegistryModule teCurrencyRegistryModule;
    private HashSet<Currency> currencies = new HashSet();
    private String languageTag;
    private int saveInterval;
    private boolean jobFeatureEnabled = true;
    private boolean jobNotificationEnabled = true;
    private boolean jobSalaryEnabled = true;
    private boolean chestShopEnabled = true;
    private boolean databaseEnabled = false;
    private String databaseUrl;
    private String databaseUser;
    private String databasePassword;
    private boolean moneyCapEnabled = false;
    private BigDecimal moneyCap;

    @Listener
    public void preInit(GamePreInitializationEvent event) {
        this.loadConfig();
        this.loadCurrencies();
        this.setFeaturesEnabledStatus();
        this.languageTag = this.config.getNode(new Object[]{"language"}).getString("en");
        this.saveInterval = this.config.getNode(new Object[]{"save-interval"}).getInt(30);
        if (this.databaseEnabled) {
            this.databaseUrl = this.config.getNode(new Object[]{"database", "url"}).getString();
            this.databaseUser = this.config.getNode(new Object[]{"database", "user"}).getString();
            this.databasePassword = this.config.getNode(new Object[]{"database", "password"}).getString();
            this.sqlManager = new SqlManager(this, this.logger);
        }
        this.messageManager = new MessageManager(this, this.logger, Locale.forLanguageTag(this.languageTag));
        this.accountManager = new AccountManager(this, this.messageManager, this.logger);
        this.teCurrencyRegistryModule = new TECurrencyRegistryModule(this);
        this.game.getServiceManager().setProvider((Object)this, EconomyService.class, (Object)this.accountManager);
        if (this.jobFeatureEnabled) {
            this.jobManager = new JobManager(this, this.accountManager, this.messageManager, this.logger);
        }
        if (this.moneyCapEnabled) {
            this.moneyCap = BigDecimal.valueOf(this.config.getNode(new Object[]{"features", "moneycap", "amount"}).getFloat()).setScale(2, 1);
        }
        if (this.chestShopEnabled) {
            this.shopManager = new ShopManager(this, this.accountManager, this.messageManager);
        }
        this.game.getRegistry().registerModule(Currency.class, (CatalogRegistryModule)this.teCurrencyRegistryModule);
    }

    @Listener
    public void init(GameInitializationEvent event) {
        this.createAndRegisterData();
        this.createAndRegisterCommands();
        this.registerListeners();
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.userStorageService = (UserStorageService)this.game.getServiceManager().provideUnchecked(UserStorageService.class);
        this.logger.info("Total Economy Started");
    }

    @Listener(order=Order.LAST)
    public void onServerStopping(GameStoppingServerEvent event) {
        this.logger.info("Total Economy Stopping");
        if (!this.databaseEnabled) {
            this.accountManager.saveConfiguration();
        }
        for (Player player : this.game.getServer().getOnlinePlayers()) {
            this.checkForAndRemovePlayerShopInfoData(player);
        }
    }

    @Listener
    public void onServerStop(GameStoppedServerEvent event) {
        this.logger.info("Total Economy Stopped");
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event) {
        Player player = event.getTargetEntity();
        this.accountManager.getOrCreateAccount(player.getUniqueId());
        this.checkForAndRemovePlayerShopInfoData(player);
    }

    @Listener
    public void onGameReload(GameReloadEvent event) {
        if (this.jobFeatureEnabled) {
            this.jobManager.reloadJobsAndSets();
        }
        this.accountManager.reloadConfig();
    }

    private void loadConfig() {
        try {
            if (!this.defaultConf.exists()) {
                ((Asset)this.pluginContainer.getAsset("totaleconomy.conf").get()).copyToFile(this.defaultConf.toPath());
            }
            this.config = this.loader.load();
        }
        catch (IOException e) {
            this.logger.warn("[TE] Main configuration file could not be loaded/created/changed!");
        }
    }

    private void createAndRegisterData() {
        DataManager dm = Sponge.getDataManager();
        dm.registerBuilder(Shop.class, (DataBuilder)new Shop.Builder());
        dm.registerBuilder(ShopItem.class, (DataBuilder)new ShopItem.Builder());
        dm.registerBuilder(PlayerShopInfo.class, (DataBuilder)new PlayerShopInfo.Builder());
        DataRegistration.builder().dataClass(ShopData.class).immutableClass(ImmutableShopData.class).builder((DataManipulatorBuilder)new ShopData.Builder()).manipulatorId("shop").dataName("shop").buildAndRegister(this.pluginContainer);
        DataRegistration.builder().dataClass(ShopItemData.class).immutableClass(ImmutableShopItemData.class).builder((DataManipulatorBuilder)new ShopItemData.Builder()).manipulatorId("shopitem").dataName("shopitem").buildAndRegister(this.pluginContainer);
        DataRegistration.builder().dataClass(PlayerShopInfoData.class).immutableClass(ImmutablePlayerShopInfoData.class).builder((DataManipulatorBuilder)new PlayerShopInfoData.Builder()).manipulatorId("playershopinfo").dataName("playershopinfo").buildAndRegister(this.pluginContainer);
        Key<Value<PlayerShopInfo>> unused = ShopKeys.PLAYER_SHOP_INFO;
    }

    private void createAndRegisterCommands() {
        CommandSpec adminPayCommand = CommandSpec.builder().description((Text)Text.of((String)"Pay a player without removing money from your balance.")).permission("totaleconomy.command.adminpay").executor((CommandExecutor)new AdminPayCommand(this, this.accountManager, this.messageManager)).arguments(new CommandElement[]{GenericArguments.user((Text)Text.of((String)"player")), GenericArguments.string((Text)Text.of((String)"amount")), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"currencyName")))}).build();
        this.game.getCommandManager().register((Object)this, (CommandCallable)adminPayCommand, new String[]{"adminpay"});
        CommandSpec balanceCommand = CommandSpec.builder().description((Text)Text.of((String)"Display your balance")).permission("totaleconomy.command.balance").executor((CommandExecutor)new BalanceCommand(this, this.accountManager, this.messageManager)).arguments(GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"currencyName")))).build();
        this.game.getCommandManager().register((Object)this, (CommandCallable)balanceCommand, new String[]{"balance", "bal", "money"});
        CommandSpec balanceTopCommand = BalanceTopCommand.commandSpec(this);
        this.game.getCommandManager().register((Object)this, (CommandCallable)balanceTopCommand, new String[]{"balancetop", "baltop"});
        CommandSpec payCommand = CommandSpec.builder().description((Text)Text.of((String)"Pay another player")).permission("totaleconomy.command.pay").executor((CommandExecutor)new PayCommand(this, this.accountManager, this.messageManager)).arguments(new CommandElement[]{GenericArguments.player((Text)Text.of((String)"player")), GenericArguments.string((Text)Text.of((String)"amount")), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"currencyName")))}).build();
        this.game.getCommandManager().register((Object)this, (CommandCallable)payCommand, new String[]{"pay"});
        CommandSpec setBalanceCommand = CommandSpec.builder().description((Text)Text.of((String)"Set a player's balance")).permission("totaleconomy.command.setbalance").executor((CommandExecutor)new SetBalanceCommand(this, this.accountManager, this.messageManager)).arguments(new CommandElement[]{GenericArguments.user((Text)Text.of((String)"player")), GenericArguments.string((Text)Text.of((String)"amount")), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"currencyName")))}).build();
        this.game.getCommandManager().register((Object)this, (CommandCallable)setBalanceCommand, new String[]{"setbalance", "setbal"});
        CommandSpec viewBalanceCommand = CommandSpec.builder().description((Text)Text.of((String)"View the balance of another player")).permission("totaleconomy.command.viewbalance").executor((CommandExecutor)new ViewBalanceCommand(this, this.accountManager, this.messageManager)).arguments(new CommandElement[]{GenericArguments.user((Text)Text.of((String)"player")), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"currencyName")))}).build();
        this.game.getCommandManager().register((Object)this, (CommandCallable)viewBalanceCommand, new String[]{"viewbalance", "vbal"});
        if (this.jobFeatureEnabled) {
            this.game.getCommandManager().register((Object)this, (CommandCallable)new JobCommand(this, this.accountManager, this.jobManager, this.messageManager).commandSpec(), new String[]{"job"});
        }
        if (this.chestShopEnabled) {
            this.game.getCommandManager().register((Object)this, (CommandCallable)new ShopCommand(this, this.accountManager, this.shopManager, this.messageManager).getCommandSpec(), new String[]{"shop"});
        }
    }

    private void loadCurrencies() {
        this.config.getNode(new Object[]{"currency"}).getChildrenMap().keySet().forEach(currencyName -> {
            ConfigurationNode currencyNode = this.config.getNode(new Object[]{"currency", currencyName.toString()});
            String currencySingular = currencyNode.getNode(new Object[]{"currency-singular"}).getString();
            String currencyPlural = currencyNode.getNode(new Object[]{"currency-plural"}).getString();
            String currencySymbol = currencyNode.getNode(new Object[]{"symbol"}).getString();
            boolean isDefault = currencyNode.getNode(new Object[]{"default"}).getBoolean();
            boolean prefixSymbol = currencyNode.getNode(new Object[]{"prefix-symbol"}).getBoolean();
            boolean isTransferable = currencyNode.getNode(new Object[]{"transferable"}).getBoolean();
            BigDecimal startBalance = new BigDecimal(currencyNode.getNode(new Object[]{"startbalance"}).getDouble());
            TECurrency currency = new TECurrency((Text)Text.of((String)currencySingular), (Text)Text.of((String)currencyPlural), (Text)Text.of((String)currencySymbol), 2, isDefault, prefixSymbol, isTransferable, startBalance);
            if (isDefault) {
                this.defaultCurrency = currency;
            }
            this.currencies.add(currency);
        });
    }

    private void registerListeners() {
        EventManager eventManager = this.game.getEventManager();
        if (this.jobFeatureEnabled) {
            eventManager.registerListeners((Object)this, (Object)this.jobManager);
        }
        if (this.chestShopEnabled) {
            eventManager.registerListeners((Object)this, (Object)this.shopManager);
        }
    }

    private void setFeaturesEnabledStatus() {
        this.jobFeatureEnabled = this.config.getNode(new Object[]{"features", "jobs", "enable"}).getBoolean(true);
        this.jobNotificationEnabled = this.config.getNode(new Object[]{"features", "jobs", "notifications"}).getBoolean(true);
        this.jobSalaryEnabled = this.config.getNode(new Object[]{"features", "jobs", "salary"}).getBoolean(true);
        this.databaseEnabled = this.config.getNode(new Object[]{"database", "enable"}).getBoolean(false);
        this.moneyCapEnabled = this.config.getNode(new Object[]{"features", "moneycap", "enable"}).getBoolean(true);
        this.chestShopEnabled = this.config.getNode(new Object[]{"features", "shops", "chestshop", "enable"}).getBoolean(true);
    }

    private void checkForAndRemovePlayerShopInfoData(Player player) {
        Optional playerShopInfoOpt = player.get(ShopKeys.PLAYER_SHOP_INFO);
        if (playerShopInfoOpt.isPresent()) {
            player.remove(ShopKeys.PLAYER_SHOP_INFO);
        }
    }

    public ConfigurationNode getShopNode() {
        return this.config.getNode(new Object[]{"features", "shops"});
    }

    public HashSet<Currency> getCurrencies() {
        return this.currencies;
    }

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public TECurrencyRegistryModule getTECurrencyRegistryModule() {
        return this.teCurrencyRegistryModule;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public Server getServer() {
        return this.game.getServer();
    }

    public Game getGame() {
        return this.game;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    public TECurrency getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public boolean isJobSalaryEnabled() {
        return this.jobSalaryEnabled;
    }

    public boolean isDatabaseEnabled() {
        return this.databaseEnabled;
    }

    public boolean isJobNotificationEnabled() {
        return this.jobNotificationEnabled;
    }

    public int getSaveInterval() {
        return this.saveInterval;
    }

    public BigDecimal getMoneyCap() {
        return this.moneyCapEnabled ? this.moneyCap : new BigDecimal(Double.MAX_VALUE);
    }

    public UserStorageService getUserStorageService() {
        return this.userStorageService;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public SqlManager getSqlManager() {
        return this.sqlManager;
    }
}

