/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.world.distribution.Distribution;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DistributionUniform
extends Distribution {
    private final WorldGenerator worldGen;
    private final INumberProvider count;
    private final INumberProvider minY;
    private final INumberProvider maxY;

    public DistributionUniform(String name, WorldGenerator worldGen, INumberProvider count, INumberProvider minY, INumberProvider maxY, boolean regen) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        int maxY;
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(pos);
        int count = this.count.intValue(world, random, data);
        int minY = Math.max(this.minY.intValue(world, random, data), 0);
        if (minY > (maxY = this.maxY.intValue(world, random, data))) {
            return false;
        }
        this.worldGen.func_175904_e();
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int x = blockX + random.nextInt(16);
            int y = minY + (minY != maxY ? random.nextInt(maxY - minY) : 0);
            int z = blockZ + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z, random)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

