/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.forge;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.api.power.ExternalPowerHandler;
import reborncore.api.power.ExternalPowerManager;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.powerSystem.forge.ForgePowerHandler;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.registration.RebornRegistry;

@RebornRegistry
public class ForgePowerManager
implements ExternalPowerManager {
    @Override
    public ExternalPowerHandler createPowerHandler(TilePowerAcceptor acceptor) {
        if (!RebornCoreConfig.enableFE) {
            return null;
        }
        return new ForgePowerHandler(acceptor);
    }

    @Override
    public boolean isPoweredItem(ItemStack stack) {
        if (!RebornCoreConfig.enableFE) {
            return false;
        }
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    @Override
    public boolean isPoweredTile(TileEntity tileEntity, EnumFacing side) {
        if (!RebornCoreConfig.enableFE) {
            return false;
        }
        return tileEntity.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    @Override
    public void dischargeItem(TilePowerAcceptor powerAcceptor, ItemStack stack) {
        if (!RebornCoreConfig.enableFE || ForgePowerManager.isOtherPoweredItem(stack)) {
            return;
        }
        IEnergyStorage powerItem = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (powerItem == null) {
            return;
        }
        double chargeEnergy = Math.min(powerAcceptor.getFreeSpace(), powerAcceptor.getMaxInput()) * (double)RebornCoreConfig.euPerFU;
        if (chargeEnergy <= 0.0) {
            return;
        }
        if (powerItem.getEnergyStored() > 0) {
            int extracted = powerItem.extractEnergy((int)chargeEnergy, false);
            powerAcceptor.addEnergy(extracted / RebornCoreConfig.euPerFU);
        }
    }

    @Override
    public void chargeItem(TilePowerAcceptor powerAcceptor, ItemStack stack) {
        if (!RebornCoreConfig.enableFE || ForgePowerManager.isOtherPoweredItem(stack)) {
            return;
        }
        IEnergyStorage powerItem = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (powerItem == null) {
            return;
        }
        int maxReceive = powerItem.receiveEnergy((int)powerAcceptor.getMaxOutput() * RebornCoreConfig.euPerFU, true);
        double maxUse = Math.min((double)(maxReceive / RebornCoreConfig.euPerFU), powerAcceptor.getMaxOutput());
        if (powerAcceptor.getEnergy() >= 0.0 && maxReceive > 0) {
            powerItem.receiveEnergy((int)powerAcceptor.useEnergy(maxUse) * RebornCoreConfig.euPerFU, false);
        }
    }

    @Override
    public void chargeItem(ForgePowerItemManager powerAcceptor, ItemStack stack) {
        if (!RebornCoreConfig.enableFE || ForgePowerManager.isOtherPoweredItem(stack)) {
            return;
        }
        IEnergyStorage powerItem = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (powerItem == null) {
            return;
        }
        int maxReceive = powerItem.receiveEnergy(powerAcceptor.extractEnergy(powerAcceptor.getEnergyStored(), true), true);
        if (maxReceive > 0) {
            powerItem.receiveEnergy(powerAcceptor.extractEnergy(maxReceive, false), false);
        }
    }

    private static boolean isOtherPoweredItem(ItemStack stack) {
        return ExternalPowerSystems.externalPowerHandlerList.stream().filter(externalPowerManager -> !(externalPowerManager instanceof ForgePowerManager)).anyMatch(externalPowerManager -> externalPowerManager.isPoweredItem(stack));
    }
}

