/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerPressureChamberInterface;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberInterface;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPressureChamberInterface
extends GuiPneumaticContainerBase<TileEntityPressureChamberInterface> {
    private static final ResourceLocation GUI_TEXTURE_CREATIVE_FILTER = new ResourceLocation("pneumaticcraft:textures/gui/gui_pressure_chamber_interface_creative_filter.png");
    private static final int FILTER_SLOT_START = 41;
    private GuiAnimatedStat statusStat;
    private GuiAnimatedStat filterStat;
    private GuiButtonSpecial filterButton;
    private GuiButton creativeTabButton;
    private GuiTextField nameFilterField;
    private boolean hasEnoughPressure = true;

    public GuiPressureChamberInterface(InventoryPlayer player, TileEntityPressureChamberInterface te) {
        super(new ContainerPressureChamberInterface(player, te), te, "pneumaticcraft:textures/gui/gui_pressure_chamber_interface.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.statusStat = this.addAnimatedStat("Interface Status", new ItemStack(Blockss.PRESSURE_CHAMBER_INTERFACE), -22016, false);
        this.filterStat = this.addAnimatedStat("Filter", new ItemStack((Block)Blocks.field_150438_bZ), -16755456, false);
        this.filterStat.setTextWithoutCuttingString(this.getFilterText());
        Rectangle buttonRect = this.filterStat.getButtonScaledRectangle(5, 30, 170, 20);
        this.filterButton = new GuiButtonSpecial(1, buttonRect.x, buttonRect.y, buttonRect.width, buttonRect.height, "-");
        this.filterStat.addWidget(this.filterButton);
        this.creativeTabButton = new GuiButton(2, xStart + 91, yStart + 58, 78, 20, "-");
        this.nameFilterField = new GuiTextField(-1, this.field_146289_q, xStart + 93, yStart + 58, 74, 10);
        this.nameFilterField.func_146180_a(((TileEntityPressureChamberInterface)this.te).itemNameFilter);
        this.field_146292_n.add(this.creativeTabButton);
        if (((TileEntityPressureChamberInterface)this.te).filterMode != TileEntityPressureChamberInterface.EnumFilterMode.ITEM) {
            if (((Slot)this.field_147002_h.field_75151_b.get((int)41)).field_75223_e < 1000) {
                this.adjustFilterSlotXPos(1000);
            }
        } else if (((Slot)this.field_147002_h.field_75151_b.get((int)41)).field_75223_e > 1000) {
            this.adjustFilterSlotXPos(-1000);
        }
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Item Filter", 115, 15, 0x404040);
        this.field_146289_q.func_78276_b("Upgr.", 24, 16, 0x404040);
        this.creativeTabButton.field_146125_m = false;
        switch (((TileEntityPressureChamberInterface)this.te).filterMode) {
            case ITEM: {
                this.filterButton.field_146126_j = "Items";
                this.nameFilterField.func_146195_b(false);
                this.nameFilterField.func_146189_e(false);
                break;
            }
            case CREATIVE_TAB: {
                this.filterButton.field_146126_j = "Creative Tab";
                this.field_146289_q.func_78276_b("Tab Name:", 106, 45, 0x404040);
                String tabName = I18n.func_135052_a((String)CreativeTabs.field_78032_a[((TileEntityPressureChamberInterface)this.te).creativeTabID].func_78013_b(), (Object[])new Object[0]);
                if (this.field_146289_q.func_78256_a(tabName) > 75) {
                    while (this.field_146289_q.func_78256_a(tabName) > 75) {
                        tabName = tabName.substring(0, tabName.length() - 2);
                    }
                    tabName = tabName + ".";
                }
                this.creativeTabButton.field_146126_j = tabName;
                this.creativeTabButton.field_146125_m = true;
                this.nameFilterField.func_146195_b(false);
                this.nameFilterField.func_146189_e(false);
                break;
            }
            case NAME_BEGINS: {
                this.filterButton.field_146126_j = "Item Name (begins with)";
                this.field_146289_q.func_78276_b("Item Name", 106, 35, 0x404040);
                this.field_146289_q.func_78276_b("begins with:", 103, 45, 0x404040);
                this.nameFilterField.func_146189_e(true);
                break;
            }
            case NAME_CONTAINS: {
                this.filterButton.field_146126_j = "Item Name (contains)";
                this.field_146289_q.func_78276_b("Item Name", 106, 35, 0x404040);
                this.field_146289_q.func_78276_b("contains:", 108, 45, 0x404040);
                this.nameFilterField.func_146189_e(true);
            }
        }
        int inputShift = (int)((1.0f - (float)Math.cos((double)((float)((TileEntityPressureChamberInterface)this.te).inputProgress / 40.0f) * Math.PI)) * 11.0f);
        int outputShift = (int)((1.0f - (float)Math.cos((double)((float)((TileEntityPressureChamberInterface)this.te).outputProgress / 40.0f) * Math.PI)) * 11.0f);
        Gui.func_73734_a((int)(63 + inputShift), (int)30, (int)(87 + inputShift), (int)32, (int)-10853633);
        Gui.func_73734_a((int)(63 + outputShift), (int)54, (int)(87 + outputShift), (int)56, (int)-22528);
    }

    @Override
    protected Point getInvNameOffset() {
        return new Point(0, -2);
    }

    @Override
    protected void bindGuiTexture() {
        if (((TileEntityPressureChamberInterface)this.te).filterMode == TileEntityPressureChamberInterface.EnumFilterMode.ITEM) {
            super.bindGuiTexture();
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE_CREATIVE_FILTER);
        }
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        this.nameFilterField.func_146194_f();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
        this.filterButton.field_146125_m = this.filterStat.isDoneExpanding();
        if (this.hasEnoughPressure && !((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = false;
            this.problemTab.openWindow();
        } else if (((TileEntityPressureChamberInterface)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = true;
        }
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add("\u00a77Interface Mode:");
        switch (((TileEntityPressureChamberInterface)this.te).interfaceMode.ordinal()) {
            case 0: {
                text.add("\u00a70None");
                break;
            }
            case 1: {
                text.add("\u00a70Import Mode");
                break;
            }
            case 2: {
                text.add("\u00a70Export Mode");
            }
        }
        return text;
    }

    private List<String> getFilterText() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add("\u00a77Filter on                            ");
        for (int i = 0; i < 3; ++i) {
            textList.add("");
        }
        return textList;
    }

    private void adjustFilterSlotXPos(int amount) {
        for (int i = 41; i < 50; ++i) {
            ((Slot)this.field_147002_h.field_75151_b.get((int)i)).field_75223_e += amount;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (((TileEntityPressureChamberInterface)this.te).filterMode == TileEntityPressureChamberInterface.EnumFilterMode.NAME_BEGINS || ((TileEntityPressureChamberInterface)this.te).filterMode == TileEntityPressureChamberInterface.EnumFilterMode.NAME_CONTAINS) {
            this.nameFilterField.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget.getID() == 1 && this.filterStat != null) {
            this.filterStat.closeWindow();
            if (((TileEntityPressureChamberInterface)this.te).filterMode == TileEntityPressureChamberInterface.EnumFilterMode.ITEM) {
                this.adjustFilterSlotXPos(1000);
            } else if (((TileEntityPressureChamberInterface)this.te).filterMode.ordinal() == TileEntityPressureChamberInterface.EnumFilterMode.values().length - 1) {
                this.adjustFilterSlotXPos(-1000);
            }
        }
        super.actionPerformed(widget);
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        curInfo.addAll(((TileEntityPressureChamberInterface)this.te).getProblemStat());
    }

    @Override
    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.nameFilterField.func_146206_l() && par2 != 1) {
            this.nameFilterField.func_146201_a(par1, par2);
            ((TileEntityPressureChamberInterface)this.te).itemNameFilter = this.nameFilterField.func_146179_b();
            NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
        } else {
            super.func_73869_a(par1, par2);
        }
    }
}

