/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.common.config.AmadronOfferPeriodicConfig;
import me.desht.pneumaticcraft.common.config.AmadronOfferStaticConfig;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AmadronOfferManager {
    private static final AmadronOfferManager CLIENT_INSTANCE = new AmadronOfferManager();
    private static final AmadronOfferManager SERVER_INSTANCE = new AmadronOfferManager();
    private final LinkedHashSet<AmadronOffer> staticOffers = new LinkedHashSet();
    private final List<AmadronOffer> periodicOffers = new ArrayList<AmadronOffer>();
    private final LinkedHashSet<AmadronOffer> selectedPeriodicOffers = new LinkedHashSet();
    private final LinkedHashSet<AmadronOffer> allOffers = new LinkedHashSet();

    public static AmadronOfferManager getInstance() {
        return FMLCommonHandler.instance().getSide() == Side.SERVER ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public Collection<AmadronOffer> getStaticOffers() {
        return this.staticOffers;
    }

    public Collection<AmadronOffer> getPeriodicOffers() {
        return this.periodicOffers;
    }

    public LinkedHashSet<AmadronOffer> getSelectedPeriodicOffers() {
        return this.selectedPeriodicOffers;
    }

    public Collection<AmadronOffer> getAllOffers() {
        return this.allOffers;
    }

    public boolean addStaticOffer(AmadronOffer offer) {
        this.allOffers.add(offer);
        return this.staticOffers.add(offer);
    }

    public boolean removeStaticOffer(AmadronOffer offer) {
        this.allOffers.remove(offer);
        return this.staticOffers.remove(offer);
    }

    public boolean addPeriodicOffer(AmadronOffer offer) {
        if (this.periodicOffers.contains(offer)) {
            return false;
        }
        this.periodicOffers.add(offer);
        return true;
    }

    public void removePeriodicOffer(AmadronOffer offer) {
        this.periodicOffers.remove(offer);
    }

    public boolean hasOffer(AmadronOffer offer) {
        return this.allOffers.contains(offer);
    }

    public void recompileOffers() {
        this.allOffers.clear();
        this.allOffers.addAll(this.staticOffers);
        this.allOffers.addAll(this.selectedPeriodicOffers);
    }

    @SideOnly(value=Side.CLIENT)
    public void syncOffers(Collection<AmadronOffer> newStaticOffers, Collection<AmadronOffer> newSelectedPeriodicOffers) {
        this.staticOffers.clear();
        this.staticOffers.addAll(newStaticOffers);
        this.selectedPeriodicOffers.clear();
        this.selectedPeriodicOffers.addAll(newSelectedPeriodicOffers);
        this.recompileOffers();
    }

    public AmadronOffer get(AmadronOffer offer) {
        for (AmadronOffer o : this.allOffers) {
            if (!o.equals(offer)) continue;
            return o;
        }
        return null;
    }

    public int countOffers(String playerId) {
        int count = 0;
        for (AmadronOffer offer : this.allOffers) {
            if (!(offer instanceof AmadronOfferCustom) || !((AmadronOfferCustom)offer).getPlayerId().equals(playerId)) continue;
            ++count;
        }
        return count;
    }

    public void tryRestockCustomOffers() {
        boolean needSave = false;
        for (AmadronOffer offer : this.allOffers) {
            if (!(offer instanceof AmadronOfferCustom)) continue;
            AmadronOfferCustom custom = (AmadronOfferCustom)offer;
            TileEntity input = custom.getProvidingTileEntity();
            TileEntity output = custom.getReturningTileEntity();
            int possiblePickups = ContainerAmadron.capShoppingAmount(custom.invert(), 50, AmadronOfferManager.getItemHandler(input), AmadronOfferManager.getItemHandler(output), AmadronOfferManager.getFluidHandler(input), AmadronOfferManager.getFluidHandler(output), null);
            if (possiblePickups > 0 && input != null) {
                BlockPos pos = new BlockPos(input.func_174877_v().func_177958_n(), input.func_174877_v().func_177956_o(), input.func_174877_v().func_177952_p());
                EntityDrone drone = ContainerAmadron.retrieveOrderItems(custom, possiblePickups, input.func_145831_w(), pos, input.func_145831_w(), pos);
                if (drone != null) {
                    drone.setHandlingOffer(custom.copy(), possiblePickups, ItemStack.field_190927_a, "Restock");
                }
            }
            custom.invert();
            if (!custom.payout()) continue;
            needSave = true;
        }
        if (needSave) {
            try {
                AmadronOfferStaticConfig.INSTANCE.writeToFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static IItemHandler getItemHandler(TileEntity te) {
        return te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) : null;
    }

    static IFluidHandler getFluidHandler(TileEntity te) {
        return te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) ? (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) : null;
    }

    public void shufflePeriodicOffers() {
        Random rand = new Random();
        this.selectedPeriodicOffers.clear();
        int toBeSelected = Math.min(AmadronOfferPeriodicConfig.offersPer, this.periodicOffers.size());
        while (this.selectedPeriodicOffers.size() < toBeSelected) {
            this.selectedPeriodicOffers.add(this.periodicOffers.get(rand.nextInt(this.periodicOffers.size())));
        }
        this.recompileOffers();
    }

    public void saveAll() {
        try {
            AmadronOfferStaticConfig.INSTANCE.writeToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            AmadronOfferPeriodicConfig.INSTANCE.writeToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

