/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.text.Text;

public class ItemAliasArgument
extends CommandElement {
    public ItemAliasArgument(@Nullable Text key) {
        super(key);
        Preconditions.checkNotNull((Object)key);
    }

    @Nullable
    protected Object parseValue(@Nonnull CommandSource source, @Nonnull CommandArgs args) throws ArgumentParseException {
        Optional<BlockState> obs;
        String arg = args.next().toLowerCase();
        Optional<CatalogType> result = this.parseAlias(arg, args);
        if (result.isPresent()) {
            return result.get();
        }
        String modifiedArg = !arg.contains(":") ? "minecraft:" + arg : arg;
        if (!modifiedArg.contains("[") && (obs = Sponge.getRegistry().getAllOf(BlockState.class).stream().filter(x -> x.getId().equalsIgnoreCase(modifiedArg + "[variant=" + modifiedArg + "]")).findFirst()).isPresent()) {
            return obs.get();
        }
        obs = Sponge.getRegistry().getAllOf(BlockState.class).stream().filter(x -> x.getId().equalsIgnoreCase(modifiedArg)).findFirst();
        if (obs.isPresent()) {
            return obs.get();
        }
        Optional<ItemType> oit = Sponge.getRegistry().getAllOf(ItemType.class).stream().filter(x -> x.getId().equalsIgnoreCase(modifiedArg)).findFirst();
        if (oit.isPresent()) {
            return oit.get();
        }
        throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.itemarg.nomatch", arg));
    }

    private Optional<CatalogType> parseAlias(String arg, @Nonnull CommandArgs args) throws ArgumentParseException {
        Optional<String> oid = Nucleus.getNucleus().getItemDataService().getIdFromAlias(arg);
        if (!oid.isPresent()) {
            return Optional.empty();
        }
        String id = oid.get();
        Optional<ItemType> obs = Sponge.getRegistry().getAllOf(ItemType.class).stream().filter(x -> x.getId().equalsIgnoreCase(id)).findFirst();
        if (obs.isPresent()) {
            return Optional.of(obs.get());
        }
        Optional<BlockState> blockState = Sponge.getRegistry().getAllOf(BlockState.class).stream().filter(x -> x.getId().equalsIgnoreCase(id)).findFirst();
        if (blockState.isPresent()) {
            return Optional.of(blockState.get());
        }
        throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.itemarg.orphanedarg", arg, id));
    }

    @Nonnull
    public List<String> complete(@Nonnull CommandSource src, @Nonnull CommandArgs args, @Nonnull CommandContext context) {
        ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
        try {
            String arg = args.peek().toLowerCase();
            return itemDataService.getAliases().stream().filter(x -> x.startsWith(arg)).sorted().collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return new ArrayList<String>(itemDataService.getAliases());
        }
    }
}

