/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices.modular;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.configurate.datatypes.LocationNode;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataModule;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularDataService;
import io.github.nucleuspowered.nucleus.internal.LocationData;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public abstract class LocationDataModule<R extends ModularDataService<R>>
extends DataModule<R> {
    protected final BiFunction<String, LocationNode, NamedLocation> getLocationData = (s, l) -> new LocationData((String)s, l.getWorld(), l.getPosition(), l.getRotation());

    protected final boolean addLocation(String name, Location<World> loc, Vector3d rot, Map<String, LocationNode> m) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(loc);
        Preconditions.checkNotNull((Object)rot);
        if (Util.getKeyIgnoreCase(m, name).isPresent()) {
            return false;
        }
        m.put(name, new LocationNode(loc, rot));
        return true;
    }

    protected final boolean removeLocation(String name, Map<String, LocationNode> m) {
        Optional<Map.Entry> o = m.entrySet().stream().filter(k -> ((String)k.getKey()).equalsIgnoreCase(name)).findFirst();
        return o.isPresent() && m.remove(o.get().getKey()) != null;
    }

    protected final <S extends LocationNode, T extends NamedLocation> Optional<T> get(Map<String, S> input, BiFunction<String, S, T> convert, String name) {
        return Util.getValueIgnoreCase(this.convert(input, convert), name);
    }

    protected final <S extends LocationNode, T extends NamedLocation> Map<String, T> convert(Map<String, S> input, BiFunction<String, S, T> convert) {
        return input.entrySet().stream().map(x -> (NamedLocation)convert.apply((String)x.getKey(), (Object)x.getValue())).filter(Objects::nonNull).collect(Collectors.toMap(NamedLocation::getName, x -> x));
    }
}

