/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.util.Tuple;

public class NucleusTextTemplateFactory {
    public static final NucleusTextTemplateFactory INSTANCE = new NucleusTextTemplateFactory();
    private final Set<Tuple<String, String>> registered = Sets.newHashSet();
    private final List<Function<String, String>> replacements = Lists.newArrayList();

    public static NucleusTextTemplateImpl createFromString(String string) throws Throwable {
        return INSTANCE.create(string);
    }

    public static NucleusTextTemplateImpl createFromAmpersandString(String string) {
        return new NucleusTextTemplateImpl.Ampersand(string);
    }

    public static NucleusTextTemplateImpl createFromAmpersandString(String string, @Nullable Text prefix, @Nullable Text suffix) {
        return new NucleusTextTemplateImpl.Ampersand(string, prefix, suffix);
    }

    public static NucleusTextTemplateImpl createFromTextTemplate(TextTemplate textTemplate) {
        return new NucleusTextTemplateImpl.Json(textTemplate);
    }

    private NucleusTextTemplateFactory() {
    }

    boolean registerTokenTranslator(String tokenStart, String tokenEnd, String replacement) {
        String s = tokenStart.trim();
        String e = tokenEnd.trim();
        Preconditions.checkArgument((!s.contains("{{") && !e.contains("}}") ? 1 : 0) != 0);
        if (this.registered.stream().anyMatch(x -> ((String)x.getFirst()).equalsIgnoreCase(s) || ((String)x.getSecond()).equalsIgnoreCase(e))) {
            return false;
        }
        String replacementRegex = Pattern.quote(tokenStart.trim()) + "([^\\s{}]+)" + Pattern.quote(tokenEnd.trim());
        this.replacements.add(st -> st.replaceAll(replacementRegex, "{{" + replacement + "}}"));
        this.registered.add((Tuple<String, String>)Tuple.of((Object)s, (Object)e));
        return true;
    }

    public NucleusTextTemplateImpl create(String string) throws Throwable {
        if (string.isEmpty()) {
            return NucleusTextTemplateImpl.Empty.INSTANCE;
        }
        try {
            return new NucleusTextTemplateImpl.Json(string);
        }
        catch (NullPointerException e) {
            return this.createFromAmpersand(string);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof ObjectMappingException) {
                return this.createFromAmpersand(string);
            }
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public NucleusTextTemplateImpl createFromAmpersand(String string) {
        return new NucleusTextTemplateImpl.Ampersand(string);
    }

    public NucleusTextTemplateImpl.Json fromTextTemplate(TextTemplate textTemplate) {
        return new NucleusTextTemplateImpl.Json(textTemplate);
    }

    String performReplacements(String string) {
        for (Function<String, String> replacementFunction : this.replacements) {
            string = replacementFunction.apply(string);
        }
        return string;
    }
}

