/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.exceptions.PluginAlreadyRegisteredException;
import io.github.nucleuspowered.nucleus.api.service.NucleusMessageTokenService;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.internal.text.Tokens;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;

public class NucleusTokenServiceImpl
implements NucleusMessageTokenService {
    private static final Pattern suffixPattern = Pattern.compile(":([sp]+)$", 2);
    private final Map<String, NucleusMessageTokenService.TokenParser> tokenStore = Maps.newHashMap();
    private final Map<String, Tuple<NucleusMessageTokenService.TokenParser, String>> primaryTokenStore = Maps.newHashMap();
    private final NucleusPlugin plugin;
    private final Optional<Text> EMPTY = Optional.empty();

    public NucleusTokenServiceImpl(NucleusPlugin plugin) {
        this.plugin = plugin;
        try {
            PluginContainer pluginContainer = plugin.getPluginContainer();
            this.register(pluginContainer, Tokens.INSTANCE);
            Tokens.INSTANCE.getTokenNames().forEach(x -> this.registerPrimaryToken(x.toLowerCase(), pluginContainer, x.toLowerCase()));
        }
        catch (PluginAlreadyRegisteredException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void register(PluginContainer pluginContainer, NucleusMessageTokenService.TokenParser textFunction) throws PluginAlreadyRegisteredException {
        Preconditions.checkNotNull((Object)pluginContainer);
        Preconditions.checkNotNull((Object)textFunction);
        if (this.tokenStore.containsKey(pluginContainer.getId())) {
            throw new PluginAlreadyRegisteredException(pluginContainer);
        }
        this.tokenStore.put(pluginContainer.getId(), textFunction);
    }

    @Override
    public boolean unregister(PluginContainer pluginContainer) {
        Preconditions.checkNotNull((Object)pluginContainer, (Object)"pluginContainer");
        Preconditions.checkState((!pluginContainer.getId().equalsIgnoreCase("nucleus") ? 1 : 0) != 0, (Object)"Cannot remove Nucleus tokens");
        NucleusMessageTokenService.TokenParser parser = this.tokenStore.remove(pluginContainer.getId());
        if (parser != null) {
            this.primaryTokenStore.entrySet().removeIf(x -> ((NucleusMessageTokenService.TokenParser)((Tuple)x.getValue()).getFirst()).equals(parser));
            return true;
        }
        return false;
    }

    @Override
    public boolean registerPrimaryToken(String primaryIdentifier, PluginContainer registeringPlugin, String identiferToMapTo) {
        Preconditions.checkArgument((!primaryIdentifier.matches("^.*[\\s|{}:].*$") ? 1 : 0) != 0, (Object)"Token cannot contain spaces or \":|{}\"");
        if (this.tokenStore.containsKey(registeringPlugin.getId()) && !this.primaryTokenStore.containsKey(primaryIdentifier.toLowerCase())) {
            this.primaryTokenStore.put(primaryIdentifier.toLowerCase(), (Tuple<NucleusMessageTokenService.TokenParser, String>)Tuple.of((Object)this.tokenStore.get(registeringPlugin.getId()), (Object)identiferToMapTo.toLowerCase()));
            return true;
        }
        return false;
    }

    @Override
    public Optional<NucleusMessageTokenService.TokenParser> getTokenParser(String plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"pluginContainer");
        return Optional.ofNullable(this.tokenStore.get(plugin.toLowerCase()));
    }

    @Override
    public Optional<Tuple<NucleusMessageTokenService.TokenParser, String>> getPrimaryTokenParserAndIdentifier(String primaryToken) {
        return Optional.ofNullable(this.primaryTokenStore.get(primaryToken.toLowerCase()));
    }

    @Override
    public List<String> getPrimaryTokens() {
        return ImmutableList.copyOf(this.primaryTokenStore.keySet());
    }

    @Override
    public Optional<Text> parseToken(String token, CommandSource source, @Nullable Map<String, Object> variables) {
        return this.getTextFromToken(token, source, variables);
    }

    @Override
    public boolean registerTokenFormat(String tokenStart, String tokenEnd, String replacement) throws IllegalArgumentException {
        return NucleusTextTemplateFactory.INSTANCE.registerTokenTranslator(tokenStart, tokenEnd, replacement);
    }

    @Override
    public NucleusTextTemplate createFromString(String string) throws NucleusException {
        try {
            return NucleusTextTemplateFactory.INSTANCE.create(string);
        }
        catch (Throwable throwable) {
            throw new NucleusException((Text)Text.of((String)"Error creating template."), throwable, NucleusException.ExceptionType.UNKNOWN_ERROR);
        }
    }

    private Optional<Text> getTextFromToken(String token, CommandSource source, Map<String, Object> variables) {
        token = token.toLowerCase().trim().replace("{{", "").replace("}}", "");
        Matcher m = suffixPattern.matcher(token);
        boolean addSpace = false;
        boolean prependSpace = false;
        if (m.find(0)) {
            String match = m.group(1).toLowerCase();
            addSpace = match.contains("s");
            prependSpace = match.contains("p");
            token = token.replaceAll(":[sp]+$", "");
        }
        try {
            Optional<Text> toReturn;
            if (token.startsWith("pl:") || token.startsWith("p:")) {
                String[] tokSplit = token.split(":", 3);
                if (tokSplit.length < 3) {
                    return this.EMPTY;
                }
                toReturn = this.applyToken(tokSplit[1], tokSplit[2], source, variables);
            } else {
                toReturn = token.startsWith("o:") ? this.getTextFromOption(source, token.substring(2)) : this.applyPrimaryToken(token, source, variables);
            }
            if (addSpace) {
                toReturn = toReturn.map(x -> x.isEmpty() ? x : Text.join((Text[])new Text[]{x, Util.SPACE}));
            }
            if (prependSpace) {
                toReturn = toReturn.map(x -> x.isEmpty() ? x : Text.join((Text[])new Text[]{Util.SPACE, x}));
            }
            return toReturn;
        }
        catch (Exception e) {
            if (this.plugin.isDebugMode()) {
                e.printStackTrace();
            }
            return this.EMPTY;
        }
    }

    private Optional<Text> getTextFromOption(CommandSource cs, String option) {
        if (cs instanceof Player) {
            return Util.getOptionFromSubject((Subject)cs, option).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0));
        }
        return Optional.empty();
    }

    public Tokens getNucleusTokenParser() {
        return (Tokens)this.tokenStore.get("nucleus");
    }
}

