/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateMessageSender;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@RunAsync
@NoModifiers
@Permissions(suggestedLevel=SuggestedLevel.OWNER)
@RegisterCommand(value={"plainbroadcast", "pbcast", "pbc"})
public class PlainBroadcastCommand
extends AbstractCommand<CommandSource> {
    private final String message = "message";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.remainingJoinedStrings((Text)Text.of((String)this.message)))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        try {
            new NucleusTextTemplateMessageSender(NucleusTextTemplateFactory.createFromString((String)args.getOne(this.message).get()), src).send(cause);
        }
        catch (Throwable throwable) {
            if (Nucleus.getNucleus().isDebugMode()) {
                throwable.printStackTrace();
            }
            throw ReturnMessageException.fromKey("command.plainbroadcast.failed", new Object[0]);
        }
        return CommandResult.success();
    }
}

