/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.chat.util;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfig;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatTemplateConfig;
import io.github.nucleuspowered.nucleus.modules.chat.config.WeightedChatTemplateConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.Subject;

public class TemplateUtil
implements Reloadable,
ServiceBase {
    private final AtomicBoolean currentlyReloading = new AtomicBoolean(false);
    private LinkedHashMap<String, WeightedChatTemplateConfig> cachedTemplates = null;
    private ChatConfig config = (ChatConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ChatConfigAdapter.class).getNodeOrDefault();

    public ChatTemplateConfig getDefaultTemplate() {
        return this.config.getDefaultTemplate();
    }

    public ChatTemplateConfig getTemplateNow(Subject subject) {
        if (!this.config.isUseGroupTemplates()) {
            return this.config.getDefaultTemplate();
        }
        Optional groupString = subject.getOption("nucleus.chat.group");
        List<Object> groups = new ArrayList();
        if (groupString.isPresent()) {
            groups.add(groupString.get());
        } else if (this.config.isCheckPermissionGroups()) {
            try {
                groups = Util.getParentSubjects(subject).get(100L, TimeUnit.MILLISECONDS).stream().map(Contextual::getIdentifier).collect(Collectors.toList());
            }
            catch (Exception e) {
                Nucleus.getNucleus().getLogger().error(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("chat.templates.timeout", subject.getIdentifier()));
                return this.config.getDefaultTemplate();
            }
            if (groups == null || groups.isEmpty()) {
                return this.config.getDefaultTemplate();
            }
        } else {
            return this.config.getDefaultTemplate();
        }
        for (Map.Entry<String, WeightedChatTemplateConfig> templates : this.cachedTemplates.entrySet()) {
            for (String string : groups) {
                if (!templates.getKey().equalsIgnoreCase(string)) continue;
                return templates.getValue();
            }
        }
        return this.config.getDefaultTemplate();
    }

    @Override
    public void onReload() {
        try {
            this.config = (ChatConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ChatConfigAdapter.class).getNodeOrDefault();
            if (!this.currentlyReloading.get()) {
                this.currentlyReloading.set(true);
                Task.builder().async().execute(() -> {
                    try {
                        if (this.config.isUseGroupTemplates()) {
                            LinkedHashMap sw = new LinkedHashMap();
                            TreeMap firstStage = new TreeMap(Comparator.reverseOrder());
                            for (Map.Entry<String, WeightedChatTemplateConfig> me : this.config.getGroupTemplates().entrySet()) {
                                Set sme = firstStage.computeIfAbsent(me.getValue().getWeight(), s -> new HashSet());
                                sme.add(me);
                            }
                            Iterator<Map.Entry<String, WeightedChatTemplateConfig>> iterator = firstStage.keySet().iterator();
                            while (iterator.hasNext()) {
                                int i = (Integer)((Object)iterator.next());
                                ((Set)firstStage.get(i)).forEach(x -> {
                                    WeightedChatTemplateConfig cfr_ignored_0 = (WeightedChatTemplateConfig)sw.put(x.getKey(), x.getValue());
                                });
                            }
                            this.cachedTemplates = sw;
                        } else {
                            this.cachedTemplates = new LinkedHashMap();
                        }
                    }
                    finally {
                        this.currentlyReloading.set(false);
                    }
                }).submit((Object)Nucleus.getNucleus());
            }
        }
        catch (Exception e) {
            this.currentlyReloading.set(false);
        }
    }
}

