/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.argumentparsers.UUIDArgument;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import java.nio.file.Files;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanTypes;

@Permissions(prefix="nucleus", suggestedLevel=SuggestedLevel.OWNER)
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"resetuser"}, subcommandOf=NucleusCommand.class)
public class ResetUserCommand
extends AbstractCommand<CommandSource> {
    private final String userKey = "user";
    private final String uuidKey = "UUID";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"a", "-all"}).buildWith(GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.user((Text)Text.of((String)this.userKey)), new UUIDArgument((Text)Text.of((String)this.uuidKey), u -> ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(u))}))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        User user = args.getOne(this.userKey).orElseGet(() -> (User)args.getOne(this.uuidKey).get());
        boolean deleteall = args.hasAny("a");
        ArrayList<Text> messages = new ArrayList<Text>();
        messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning", new String[0]));
        messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning2", user.getName()));
        messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning3", new String[0]));
        messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning4", new String[0]));
        messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning5", new String[0]));
        messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning6", new String[0]));
        if (deleteall) {
            messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning8", new String[0]));
        } else {
            messages.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.warning7", new String[0]));
        }
        messages.add(Text.builder().append(new Text[]{NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.reset", new String[0])}).style(new TextStyle[]{TextStyles.UNDERLINE}).onClick((ClickAction)TextActions.executeCallback((Consumer)new Delete(user, deleteall))).build());
        src.sendMessages(messages);
        return CommandResult.success();
    }

    private class Delete
    implements Consumer<CommandSource> {
        private final User user;
        private final boolean all;

        public Delete(User user, boolean all) {
            this.user = user;
            this.all = all;
        }

        @Override
        public void accept(CommandSource source) {
            if (this.user.isOnline()) {
                ((Player)this.user.getPlayer().get()).kick(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kick.defaultreason", new String[0]));
                Task.builder().execute(() -> this.accept(source)).delayTicks(1L).submit((Object)Nucleus.getNucleus());
                return;
            }
            source.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.reset.starting", this.user.getName()));
            BanService bss = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
            boolean isBanned = bss.getBanFor(this.user.getProfile()).isPresent();
            bss.addBan(Ban.builder().type(BanTypes.PROFILE).expirationDate(Instant.now().plus(30L, ChronoUnit.SECONDS)).profile(this.user.getProfile()).build());
            MessageProvider messageProvider = NucleusPlugin.getNucleus().getMessageProvider();
            Sponge.getScheduler().createAsyncExecutor((Object)Nucleus.getNucleus()).schedule(() -> {
                UserDataManager ucl = Nucleus.getNucleus().getUserDataManager();
                try {
                    ucl.forceUnloadAndDelete(this.user.getUniqueId());
                    if (this.all) {
                        String uuid = this.user.getUniqueId() + ".dat";
                        if (((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).delete(this.user)) {
                            Files.deleteIfExists(Sponge.getGame().getSavesDirectory().resolve("data/sponge").resolve(uuid));
                            source.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.reset.completeall", this.user.getName()));
                        } else {
                            source.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.reset.completenonm", this.user.getName()));
                        }
                    } else {
                        source.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.reset.complete", this.user.getName()));
                    }
                    source.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.reset.restartadvised", this.user.getName()));
                }
                catch (Exception e) {
                    source.sendMessage(messageProvider.getTextMessageWithFormat("command.nucleus.reset.failed", this.user.getName()));
                }
                finally {
                    if (!isBanned) {
                        bss.getBanFor(this.user.getProfile()).ifPresent(arg_0 -> ((BanService)bss).removeBan(arg_0));
                    }
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }
}

