/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.datamodules;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularGeneralService;
import io.github.nucleuspowered.nucleus.dataservices.modular.TransientModule;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.user.UserStorageService;

public class UniqueUserCountTransientModule
extends TransientModule<ModularGeneralService> {
    private static boolean ERROR_REPORTED = false;
    private long userCount = 0L;
    private boolean userCountIsDirty = false;

    public void resetUniqueUserCount() {
        this.resetUniqueUserCount(null);
    }

    public void resetUniqueUserCount(@Nullable Consumer<Long> resultConsumer) {
        if (!this.userCountIsDirty) {
            this.userCountIsDirty = true;
            ERROR_REPORTED = false;
            Task.builder().async().execute(task -> {
                boolean accurate = ((CoreConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(CoreConfigAdapter.class).getNodeOrDefault()).isMoreAccurate();
                UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
                UserDataManager userDataManager = Nucleus.getNucleus().getUserDataManager();
                this.userCount = accurate ? uss.getAll().stream().filter(GameProfile::isFilled).map(arg_0 -> ((UserStorageService)uss).get(arg_0)).filter(Optional::isPresent).filter(x -> {
                    boolean ret;
                    block5: {
                        boolean bl = ret = ((User)x.get()).getPlayer().isPresent() || Nucleus.getNucleus().getUserDataManager().has(((User)x.get()).getUniqueId());
                        if (!ret) {
                            try {
                                return ((User)x.get()).get(JoinData.class).map(y -> y.firstPlayed().getDirect().isPresent()).orElse(false);
                            }
                            catch (IllegalStateException e) {
                                if (!ERROR_REPORTED) {
                                    ERROR_REPORTED = true;
                                    Nucleus.getNucleus().getLogger().warn("The Sponge player data provider has not yet been initialised, not using join data in this count.");
                                }
                            }
                            catch (NoSuchElementException e) {
                                if (ERROR_REPORTED) break block5;
                                ERROR_REPORTED = true;
                                Nucleus.getNucleus().getLogger().warn("The join data can not be constructed on some users.");
                            }
                        }
                    }
                    return ret;
                }).count() : uss.getAll().stream().filter(GameProfile::isFilled).filter(x -> userDataManager.has(x.getUniqueId())).count();
                this.userCountIsDirty = false;
                if (resultConsumer != null) {
                    resultConsumer.accept(this.userCount);
                }
            }).submit((Object)Nucleus.getNucleus());
        }
    }

    public long getUniqueUserCount() {
        if (this.userCountIsDirty) {
            return this.userCount + 1L;
        }
        return this.userCount;
    }
}

