/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fly.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.fly.datamodules.FlyUserDataModule;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(supportsSelectors=true)
@RegisterCommand(value={"fly"})
@EssentialsEquivalent(value={"fly"})
@NonnullByDefault
public class FlyCommand
extends AbstractCommand.SimpleTargetOtherPlayer {
    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("others", new PermissionInformation(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("permission.others", this.getAliases()[0]), SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] additionalArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    protected CommandResult executeWithPlayer(CommandSource src, Player pl, CommandContext args, boolean isSelf) {
        FlyUserDataModule uc = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)pl).get(FlyUserDataModule.class);
        boolean fly = args.getOne("true|false").orElse(pl.get(Keys.CAN_FLY).orElse(false) == false);
        if (!this.setFlying(pl, fly)) {
            src.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.fly.error", new String[0])});
            return CommandResult.empty();
        }
        uc.setFlying(fly);
        if (pl != src) {
            src.sendMessages(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(fly ? "command.fly.player.on" : "command.fly.player.off", pl.getName())});
        }
        pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(fly ? "command.fly.on" : "command.fly.off", new String[0]));
        return CommandResult.success();
    }

    private boolean setFlying(Player pl, boolean fly) {
        return (fly || pl.offer(Keys.IS_FLYING, (Object)false).isSuccessful()) && pl.offer(Keys.CAN_FLY, (Object)fly).isSuccessful();
    }
}

