/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ignore.listeners;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.chat.NucleusNoIgnoreChannel;
import io.github.nucleuspowered.nucleus.api.events.NucleusMailEvent;
import io.github.nucleuspowered.nucleus.api.events.NucleusMessageEvent;
import io.github.nucleuspowered.nucleus.dataservices.loaders.UserDataManager;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.ignore.commands.IgnoreCommand;
import io.github.nucleuspowered.nucleus.modules.ignore.datamodules.IgnoreUserDataModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public class IgnoreListener
implements ListenerBase {
    private final UserDataManager loader = Nucleus.getNucleus().getUserDataManager();
    private CommandPermissionHandler ignoreHandler = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(IgnoreCommand.class);

    @Listener(order=Order.LATE)
    public void onChat(MessageChannelEvent.Chat event) {
        if (event.getChannel().orElseGet(() -> ((MessageChannelEvent.Chat)event).getOriginalChannel()) instanceof NucleusNoIgnoreChannel) {
            return;
        }
        Util.onPlayerSimulatedOrPlayer(event, this::onChat);
    }

    private void onChat(MessageChannelEvent.Chat event, Player player) {
        this.checkCancels(event.getChannel().orElseGet(() -> ((MessageChannelEvent.Chat)event).getOriginalChannel()).getMembers(), player).ifPresent(x -> {
            MutableMessageChannel mmc = event.getChannel().orElseGet(() -> ((MessageChannelEvent.Chat)event).getOriginalChannel()).asMutable();
            x.forEach(arg_0 -> ((MutableMessageChannel)mmc).removeMember(arg_0));
            event.setChannel((MessageChannel)mmc);
        });
    }

    @Listener(order=Order.FIRST)
    public void onMessage(NucleusMessageEvent event, @Root Player player) {
        block3: {
            if (event.getRecipient() instanceof User) {
                try {
                    event.setCancelled(this.loader.getUnchecked((User)event.getRecipient()).get(IgnoreUserDataModule.class).getIgnoreList().contains(player.getUniqueId()));
                }
                catch (Exception e) {
                    if (!Nucleus.getNucleus().isDebugMode()) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    @Listener(order=Order.FIRST)
    public void onMail(NucleusMailEvent event, @Root Player player) {
        block2: {
            try {
                event.setCancelled(this.loader.getUnchecked(event.getRecipient()).get(IgnoreUserDataModule.class).getIgnoreList().contains(player.getUniqueId()));
            }
            catch (Exception e) {
                if (!Nucleus.getNucleus().isDebugMode()) break block2;
                e.printStackTrace();
            }
        }
    }

    private Optional<Collection<MessageReceiver>> checkCancels(Collection<MessageReceiver> collection, Player player) {
        if (this.ignoreHandler.testSuffix((Subject)player, "exempt.chat")) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList(collection);
        list.removeIf(x -> {
            try {
                if (!(x instanceof Player)) {
                    return true;
                }
                if (x.equals(player)) {
                    return true;
                }
                return this.loader.get((User)((Player)x)).map(y -> y.get(IgnoreUserDataModule.class).getIgnoreList().contains(player.getUniqueId())).orElse(false) == false;
            }
            catch (Exception e) {
                if (Nucleus.getNucleus().isDebugMode()) {
                    e.printStackTrace();
                }
                return true;
            }
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list);
    }
}

