/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.service.permission.Subject;

public class KeepInventoryListener
implements ListenerBase.Conditional {
    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap perms = Maps.newHashMap();
        perms.put("nucleus.inventory.keepondeath", PermissionInformation.getWithTranslation("permission.inventory.keep", SuggestedLevel.ADMIN));
        return perms;
    }

    @Listener
    public void onEntityDeath(DestructEntityEvent.Death event, @Getter(value="getTargetEntity") Player living) {
        if (this.hasPermission((Subject)living, "nucleus.inventory.keepondeath")) {
            event.setKeepInventory(true);
        }
    }

    @Override
    public boolean shouldEnable() {
        return !ServiceChangeListener.isOpOnly();
    }
}

