/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.itemname;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.modules.item.commands.itemname.ItemNameCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="itemname")
@NonnullByDefault
@RegisterCommand(value={"set"}, subcommandOf=ItemNameCommand.class, rootAliasRegister={"setitemname", "renameitem"})
public class ItemNameSetCommand
extends AbstractCommand<Player> {
    private final String nameKey = "name";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.remainingJoinedStrings((Text)Text.of((String)this.nameKey))};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        Text name;
        MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            throw ReturnMessageException.fromKey("command.itemname.set.noitem", new Object[0]);
        }
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        if (stack.offer(Keys.DISPLAY_NAME, (Object)(name = TextSerializers.FORMATTING_CODE.deserialize((String)args.getOne(this.nameKey).get()))).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            src.sendMessage(provider.getTextMessageWithFormat("command.itemname.set.success", new String[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.itemname.set.fail", new Object[0]);
    }
}

