/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mail.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.MailMessage;
import io.github.nucleuspowered.nucleus.api.service.NucleusMailService;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.mail.data.MailData;
import io.github.nucleuspowered.nucleus.modules.mail.services.MailHandler;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class MailReadBase
implements InternalServiceManagerTrait {
    public static MailReadBase INSTANCE = new MailReadBase();
    private final MailHandler handler = this.getServiceUnchecked(MailHandler.class);
    static final String filters = "filters";

    private MailReadBase() {
    }

    public CommandResult executeCommand(CommandSource src, User target, Collection<NucleusMailService.MailFilter> lmf) {
        List<MailData> lmd = !lmf.isEmpty() ? this.handler.getMailInternal(target, lmf.toArray(new NucleusMailService.MailFilter[0])) : this.handler.getMailInternal(target, new NucleusMailService.MailFilter[0]);
        if (lmd.isEmpty()) {
            if (src instanceof Player && target.getUniqueId().equals(((Player)src).getUniqueId())) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(!lmf.isEmpty() ? "command.mail.none.filter" : "command.mail.none.normal.self", new String[0]));
            } else {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(!lmf.isEmpty() ? "command.mail.none.filter" : "command.mail.none.normal.other", target.getName()));
            }
            return CommandResult.success();
        }
        List mails = lmd.stream().sorted(Comparator.comparing(MailMessage::getDate)).map(x -> this.createMessage((MailData)x, target)).collect(Collectors.toList());
        PaginationService ps = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
        PaginationList.Builder b = ps.builder().padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(this.getHeader(src, target, !lmf.isEmpty())).contents(mails);
        if (!(src instanceof Player)) {
            b.linesPerPage(-1);
        } else {
            b.header(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("mail.header", new String[0]));
        }
        b.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text getHeader(CommandSource src, User user, boolean isFiltered) {
        if (src instanceof Player && user.getUniqueId().equals(((Player)src).getUniqueId())) {
            return Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(isFiltered ? "mail.title.filter.self" : "mail.title.nofilter.self", new String[0]);
        }
        return Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(isFiltered ? "mail.title.filter.other" : "mail.title.nofilter.other", user.getName());
    }

    private Text createMessage(MailData md, User user) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MMM dd, yyyy").withZone(ZoneId.systemDefault());
        String name = Nucleus.getNucleus().getNameUtil().getNameFromUUID(md.getUuid());
        return Text.builder().append(new Text[]{Text.builder((String)name).color(TextColors.GREEN).style(new TextStyle[]{TextStyles.UNDERLINE}).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.hover", new String[0]))).onClick((ClickAction)TextActions.executeCallback(src -> {
            src.sendMessage(Text.builder().append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.date", new String[0])}).append(new Text[]{Text.of((Object[])new Object[]{" ", TextColors.WHITE, dtf.format(md.getDate())})}).build());
            Text.Builder tb = Text.builder().append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.sender", new String[0])}).append(new Text[]{Text.of((Object[])new Object[]{" ", TextColors.WHITE, Nucleus.getNucleus().getNameUtil().getNameFromUUID(md.getUuid())})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, " - "})});
            if (!md.getUuid().equals(Util.consoleFakeUUID)) {
                tb.append(new Text[]{Text.builder((String)Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.reply", new String[0])).color(TextColors.GREEN).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.reply.label", name))).onClick((ClickAction)TextActions.suggestCommand((String)("/mail send " + name + " "))).build()}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, " - "})});
            }
            src.sendMessage(tb.append(new Text[]{Text.builder((String)Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.delete", new String[0])).color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.delete.label", new String[0]))).onClick((ClickAction)TextActions.executeCallback(s -> {
                if (this.handler.removeMail(user, md)) {
                    src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.delete.success", new String[0]));
                } else {
                    src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.delete.fail", new String[0]));
                }
            })).build()}).build());
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.mail.message", new String[0]));
            src.sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, md.getMessage()}));
        })).build()}).append(new Text[]{Text.of((String)(": " + md.getMessage()))}).build();
    }
}

