/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.qsml.module.ConfigurableModule;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.message.MessageUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.message.commands.SocialSpyCommand;
import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import java.util.ArrayList;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

@ModuleData(id="message", name="Message")
public class MessageModule
extends ConfigurableModule<MessageConfigAdapter> {
    public static final String ID = "message";

    @Override
    public MessageConfigAdapter createAdapter() {
        return new MessageConfigAdapter();
    }

    @Override
    public void performEnableTasks() {
        this.createSeenModule(SocialSpyCommand.class, (CommandSource cs, User user) -> {
            MessageHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(MessageHandler.class);
            boolean socialSpy = handler.isSocialSpy((User)user);
            boolean msgToggle = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(UserPreferenceService.class).getUnwrapped(user.getUniqueId(), MessageUserPrefKeys.RECEIVING_MESSAGES);
            MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
            ArrayList lt = Lists.newArrayList((Object[])new Text[]{mp.getTextMessageWithFormat("seen.socialspy", mp.getMessageWithFormat("standard.yesno." + Boolean.toString(socialSpy).toLowerCase(), new String[0]))});
            this.getConfigAdapter().ifPresent(x -> lt.add(mp.getTextMessageWithFormat("seen.socialspylevel", String.valueOf(Util.getPositiveIntOptionFromSubject((Subject)user, "nucleus.socialspy.level").orElse(0)))));
            lt.add(mp.getTextMessageWithFormat("seen.msgtoggle", mp.getMessageWithFormat("standard.yesno." + Boolean.toString(msgToggle).toLowerCase(), new String[0])));
            return lt;
        });
    }
}

