/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@Permissions(prefix="globalmute")
@RegisterCommand(value={"voice"})
@NonnullByDefault
public class VoiceCommand
extends AbstractCommand<CommandSource> {
    private final MuteHandler muteHandler = (MuteHandler)this.getServiceUnchecked(MuteHandler.class);

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> m = super.permissionSuffixesToRegister();
        m.put("auto", PermissionInformation.getWithTranslation("permission.voice.auto", SuggestedLevel.ADMIN));
        m.put("notify", PermissionInformation.getWithTranslation("permission.voice.notify", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_PLAYER, NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        UUID voice;
        if (!this.muteHandler.isGlobalMuteEnabled()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.globaloff", new String[0]));
            return CommandResult.empty();
        }
        Player pl = (Player)args.getOne("player").get();
        if (this.permissions.testSuffix((Subject)pl, "auto")) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.autovoice", pl.getName()));
            return CommandResult.empty();
        }
        boolean turnOn = args.getOne("true|false").orElse(!this.muteHandler.isVoiced(pl.getUniqueId()));
        if (turnOn == this.muteHandler.isVoiced(voice = pl.getUniqueId())) {
            if (turnOn) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.alreadyvoiced", pl.getName()));
            } else {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.alreadynotvoiced", pl.getName()));
            }
            return CommandResult.empty();
        }
        MutableMessageChannel mmc = new PermissionMessageChannel(this.permissions.getPermissionWithSuffix("notify")).asMutable();
        mmc.addMember((MessageReceiver)src);
        if (turnOn) {
            this.muteHandler.addVoice(pl.getUniqueId());
            mmc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.voiced.source", pl.getName()));
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.voiced.target", new String[0]));
        } else {
            this.muteHandler.removeVoice(pl.getUniqueId());
            mmc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.voiced.source", pl.getName()));
            pl.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.voice.voiced.target", new String[0]));
        }
        return CommandResult.success();
    }
}

