/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.nickname.datamodules.NicknameUserDataModule;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

@RegisterCommand(value={"realname"})
@Permissions(suggestedLevel=SuggestedLevel.USER)
@EssentialsEquivalent(value={"realname"})
public class RealnameCommand
extends AbstractCommand<CommandSource> {
    private final String playerKey = "name";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.string((Text)Text.of((String)"name"))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String argname = (String)args.getOne("name").get();
        String name = argname.toLowerCase();
        Collection players = Sponge.getServer().getOnlinePlayers();
        List realNames = players.stream().map(x -> {
            Optional<Text> ot;
            Optional<ModularUserService> ous = Nucleus.getNucleus().getUserDataManager().get((User)x);
            if (ous.isPresent() && (ot = ous.get().get(NicknameUserDataModule.class).getNicknameAsText()).isPresent()) {
                return new NameTuple(ot.get().toPlain().toLowerCase(), (Player)x);
            }
            Optional displayName = x.getDisplayNameData().displayName().getDirect();
            if (displayName.isPresent()) {
                return new NameTuple(((Text)displayName.get()).toPlain().toLowerCase(), (Player)x);
            }
            return new NameTuple(x.getName().toLowerCase(), (Player)x);
        }).filter(x -> ((NameTuple)x).nickname.startsWith(name.toLowerCase())).map(x -> Text.builder().append(new Text[]{Nucleus.getNucleus().getNameUtil().getName((User)((NameTuple)x).player)}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GRAY, " -> "})}).append(new Text[]{Text.of((String)((NameTuple)x).player.getName())}).toText()).collect(Collectors.toList());
        if (realNames.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.realname.nonames", argname));
        } else {
            PaginationList.Builder plb = ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().contents(realNames).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.realname.title", argname));
            if (!(src instanceof Player)) {
                plb.linesPerPage(-1);
            }
            plb.sendTo((MessageReceiver)src);
        }
        return CommandResult.success();
    }

    private class NameTuple {
        private final String nickname;
        private final Player player;

        private NameTuple(String nickname, Player player) {
            this.nickname = nickname;
            this.player = player;
        }
    }
}

