/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.services;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Warp;
import io.github.nucleuspowered.nucleus.api.nucleusdata.WarpCategory;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarpService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.warp.datamodules.WarpGeneralDataModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@APIService(value=NucleusWarpService.class)
@NonnullByDefault
public class WarpHandler
implements NucleusWarpService,
ServiceBase {
    private WarpGeneralDataModule getModule() {
        return Nucleus.getNucleus().getGeneralService().get(WarpGeneralDataModule.class);
    }

    @Override
    public Optional<Warp> getWarp(String warpName) {
        return this.getModule().getWarpLocation(warpName);
    }

    @Override
    public boolean removeWarp(String warpName) {
        return this.getModule().removeWarp(warpName);
    }

    @Override
    public boolean setWarp(String warpName, Location<World> location, Vector3d rotation) {
        return this.getModule().addWarp(warpName, location, rotation);
    }

    @Override
    public List<Warp> getAllWarps() {
        return new ArrayList<Warp>(this.getModule().getWarps().values());
    }

    @Override
    public List<Warp> getUncategorisedWarps() {
        return this.getWarpsForCategory((Warp x) -> !x.getCategory().isPresent());
    }

    @Override
    public List<Warp> getWarpsForCategory(String category) {
        return this.getWarpsForCategory((Warp x) -> x.getCategory().isPresent() && x.getCategory().get().equalsIgnoreCase(category));
    }

    @Override
    public Map<WarpCategory, List<Warp>> getWarpsWithCategories(Predicate<Warp> warpDataPredicate) {
        Preconditions.checkNotNull(warpDataPredicate);
        Map<String, List<Warp>> map = this.getModule().getWarps().values().stream().filter(warpDataPredicate).collect(Collectors.groupingBy(x -> x.getCategory().orElse("")));
        if (map.containsKey("")) {
            map.put(null, map.get(""));
            map.remove("");
        }
        return map.entrySet().stream().collect(Collectors.toMap(x -> x.getKey() == null ? null : this.getModule().getWarpCategoryOrDefault((String)x.getKey()), Map.Entry::getValue));
    }

    @Override
    public boolean removeWarpCost(String warpName) {
        return this.getModule().setWarpCost(warpName, -1.0);
    }

    @Override
    public boolean setWarpCost(String warpName, double cost) {
        return this.getModule().setWarpCost(warpName, cost);
    }

    @Override
    public boolean setWarpCategory(String warpName, @Nullable String category) {
        return this.getModule().setWarpsWarpCategory(warpName, category);
    }

    @Override
    public boolean setWarpDescription(String warpName, @Nullable Text description) {
        return this.getModule().setWarpDescription(warpName, description);
    }

    @Override
    public Set<String> getWarpNames() {
        return this.getModule().getWarps().keySet();
    }

    public WarpCategory getWarpCategoryOrDefault(String category) {
        return this.getModule().getWarpCategoryOrDefault(category);
    }

    @Override
    public Optional<WarpCategory> getWarpCategory(String category) {
        return this.getModule().getWarpCategory(category);
    }

    @Override
    public boolean setWarpCategoryDisplayName(String category, @Nullable Text displayName) {
        Optional<WarpCategory> cat = this.getWarpCategory(category);
        if (!cat.isPresent()) {
            return false;
        }
        this.getModule().updateOrSetWarpCategory(category, displayName, cat.get().getDescription().orElse(null));
        return true;
    }

    @Override
    public boolean setWarpCategoryDescription(String category, @Nullable Text description) {
        Optional<WarpCategory> cat = this.getWarpCategory(category);
        if (!cat.isPresent()) {
            return false;
        }
        this.getModule().updateOrSetWarpCategory(category, cat.get().getDisplayName(), description);
        return true;
    }

    private List<Warp> getWarpsForCategory(Predicate<Warp> filter) {
        return this.getModule().getWarps().values().stream().filter(filter).collect(Collectors.toList());
    }
}

