/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.GameruleCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NoModifiers
@NonnullByDefault
@Permissions(prefix="world.gamerule", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"set"}, subcommandOf=GameruleCommand.class)
public class SetGameruleCommand
extends AbstractCommand<CommandSource> {
    private static final String worldKey = "world";
    private static final String gameRuleKey = "gamerule";
    private static final String valueKey = "value";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.world((Text)Text.of((String)worldKey)))), GenericArguments.string((Text)Text.of((String)gameRuleKey)), GenericArguments.string((Text)Text.of((String)valueKey))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties worldProperties = this.getWorldFromUserOrArgs(src, worldKey, args);
        String gameRule = (String)args.getOne(gameRuleKey).get();
        String value = (String)args.getOne(valueKey).get();
        worldProperties.setGameRule(gameRule, value);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.gamerule.set.success", gameRule, value, worldProperties.getWorldName()));
        return CommandResult.success();
    }
}

