/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.util;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.util.ThrownConsumer;
import io.github.nucleuspowered.nucleus.util.ThrownFunction;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;

public class CauseStackHelper {
    private CauseStackHelper() {
    }

    public static <T, X extends Throwable> T createFrameWithCausesAndContextWithReturn(ThrownFunction<Cause, T, X> function, EventContext context, Object ... causeStack) throws X {
        try (CauseStackManager.StackFrame csf = CauseStackHelper.createFrameWithCauses(context, causeStack);){
            T t = function.apply(Sponge.getCauseStackManager().getCurrentCause());
            return t;
        }
    }

    public static <T, X extends Throwable> T createFrameWithCausesWithReturn(ThrownFunction<Cause, T, X> function, Object ... causeStack) throws X {
        try (CauseStackManager.StackFrame csf = CauseStackHelper.createFrameWithCauses(causeStack);){
            T t = function.apply(Sponge.getCauseStackManager().getCurrentCause());
            return t;
        }
    }

    public static <X extends Throwable> void createFrameWithCausesWithConsumer(ThrownConsumer<Cause, X> supplier, Object ... causeStack) throws X {
        try (CauseStackManager.StackFrame csf = CauseStackHelper.createFrameWithCauses(causeStack);){
            supplier.accept(Sponge.getCauseStackManager().getCurrentCause());
        }
    }

    public static CauseStackManager.StackFrame createFrameWithCauses(Object ... causeStack) {
        return CauseStackHelper.createFrameWithCauses(EventContext.empty(), causeStack);
    }

    public static CauseStackManager.StackFrame createFrameWithCauses(EventContext eventContext, Object ... causeStack) {
        CauseStackManager.StackFrame csf = Sponge.getCauseStackManager().pushCauseFrame();
        eventContext.asMap().forEach((context, object) -> Sponge.getCauseStackManager().addContext(context, object));
        if (causeStack.length > 0) {
            for (int i = causeStack.length - 1; i >= 0; --i) {
                Sponge.getCauseStackManager().pushCause(causeStack[i]);
            }
        }
        return csf;
    }

    public static Cause createCause(Object ... causeStack) {
        return CauseStackHelper.createCause(EventContext.empty(), causeStack);
    }

    public static Cause createCause(EventContext eventContext, Object ... causeStack) {
        if (Sponge.getServer().isMainThread()) {
            try (CauseStackManager.StackFrame frame = CauseStackHelper.createFrameWithCauses(eventContext, causeStack);){
                Cause cause = Sponge.getCauseStackManager().getCurrentCause();
                return cause;
            }
        }
        Cause.Builder cb = Cause.builder();
        if (causeStack.length > 0) {
            for (Object cause : causeStack) {
                cb.append(cause);
            }
        } else {
            cb.append((Object)Nucleus.getNucleus());
        }
        return cb.build(eventContext);
    }
}

