/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.nucleus.neutrino.objectmapper;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.relocate.nucleus.neutrino.annotations.Default;
import io.github.nucleuspowered.relocate.nucleus.neutrino.annotations.DoNotGenerate;
import io.github.nucleuspowered.relocate.nucleus.neutrino.annotations.ProcessSetting;
import io.github.nucleuspowered.relocate.nucleus.neutrino.annotations.RequiresProperty;
import io.github.nucleuspowered.relocate.nucleus.neutrino.settingprocessor.SettingProcessor;
import io.github.nucleuspowered.relocate.nucleus.neutrino.settingprocessor.SettingProcessorCache;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;

public class NeutrinoObjectMapper<T>
extends ObjectMapper<T> {
    private final Function<Setting, String> commentProcessor;
    private Map<String, ObjectMapper.FieldData> fieldDataMapCache;
    private List<Field> fieldsToProcess;

    NeutrinoObjectMapper(Class<T> clazz, Function<Setting, String> commentProcessor) throws ObjectMappingException {
        super(clazz);
        this.commentProcessor = commentProcessor;
        this.collectFields();
    }

    protected void collectFields(Map<String, ObjectMapper.FieldData> cachedFields, Class<? super T> clazz) throws ObjectMappingException {
        if (this.fieldDataMapCache == null) {
            this.fieldDataMapCache = cachedFields;
            this.fieldsToProcess = Lists.newArrayList();
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Setting.class)) continue;
            this.fieldsToProcess.add(field);
        }
    }

    protected void collectFields() throws ObjectMappingException {
        for (Field field : this.fieldsToProcess) {
            ObjectMapper.FieldData data;
            Setting setting = field.getAnnotation(Setting.class);
            String path = setting.value();
            if (path.isEmpty()) {
                path = field.getName();
            }
            String comment = this.commentProcessor.apply(setting);
            if (field.isAnnotationPresent(ProcessSetting.class)) {
                try {
                    data = new PreprocessedFieldData(field, comment);
                }
                catch (IllegalArgumentException e) {
                    data = new ObjectMapper.FieldData(field, comment);
                }
            } else if (field.isAnnotationPresent(DoNotGenerate.class)) {
                Object defaultValue = null;
                try {
                    field.setAccessible(true);
                    defaultValue = field.get(field.getDeclaringClass().newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                data = new DoNotGenerateFieldData(field, comment, defaultValue);
            } else {
                data = new ObjectMapper.FieldData(field, comment);
            }
            if (field.isAnnotationPresent(Default.class)) {
                Default de = field.getAnnotation(Default.class);
                data = new DefaultFieldData(field, comment, data, de.value(), de.saveDefaultIfNull(), de.useDefaultIfEmpty(), this.canEdit(field));
            } else if (!this.canEdit(field)) {
                data = new JavaPropertyFieldData(field, comment);
            }
            field.setAccessible(true);
            if (this.fieldDataMapCache.containsKey(path)) continue;
            this.fieldDataMapCache.put(path, data);
        }
    }

    private boolean canEdit(Field field) {
        if (!field.isAnnotationPresent(RequiresProperty.class)) {
            return true;
        }
        try {
            RequiresProperty annotation = field.getAnnotation(RequiresProperty.class);
            String propertyValue = System.getProperty(annotation.value());
            return propertyValue != null && Pattern.compile(annotation.matchedName()).matcher(propertyValue).matches();
        }
        catch (Exception e) {
            Logger.getGlobal().warning("Field %s checks for property %s but the value regex \"%s\" is invalid. Not loading.");
            return false;
        }
    }

    protected static class PreprocessedFieldData
    extends ObjectMapper.FieldData {
        private final List<SettingProcessor> processors = new ArrayList<SettingProcessor>();

        protected PreprocessedFieldData(Field field, String comment) throws ObjectMappingException, IllegalArgumentException {
            super(field, comment);
            try {
                for (Class<? extends SettingProcessor> pro : field.getAnnotation(ProcessSetting.class).value()) {
                    this.processors.add(SettingProcessorCache.getOrAdd(pro));
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("No setting processor", e);
            }
        }

        public void deserializeFrom(Object instance, ConfigurationNode node) throws ObjectMappingException {
            for (SettingProcessor processor : this.processors) {
                processor.onGet(node);
            }
            super.deserializeFrom(instance, node);
        }

        public void serializeTo(Object instance, ConfigurationNode node) throws ObjectMappingException {
            super.serializeTo(instance, node);
            for (SettingProcessor processor : this.processors) {
                processor.onSet(node);
            }
        }
    }

    protected static class JavaPropertyFieldData
    extends ObjectMapper.FieldData {
        private static String COMMENT = "This config option is currently ignored.";

        public JavaPropertyFieldData(Field field, String comment) throws ObjectMappingException {
            super(field, comment);
        }

        public void deserializeFrom(Object instance, ConfigurationNode node) throws ObjectMappingException {
        }

        public void serializeTo(Object instance, ConfigurationNode node) throws ObjectMappingException {
            CommentedConfigurationNode ccn;
            String comment;
            if (!node.isVirtual() && node instanceof CommentedConfigurationNode && !(comment = (ccn = (CommentedConfigurationNode)node).getComment().orElse("")).endsWith(COMMENT)) {
                ccn.setComment(ccn.getComment() + System.lineSeparator() + COMMENT);
            }
        }
    }

    protected static class DoNotGenerateFieldData
    extends ObjectMapper.FieldData {
        private final Object defaultValue;
        private final Field field;

        protected DoNotGenerateFieldData(Field field, String comment, Object defaultValue) throws ObjectMappingException {
            super(field, comment);
            this.field = field;
            this.defaultValue = defaultValue;
        }

        public void serializeTo(Object instance, ConfigurationNode node) throws ObjectMappingException {
            try {
                this.field.setAccessible(true);
                if (!this.defaultValue.equals(this.field.get(instance))) {
                    super.serializeTo(instance, node);
                }
            }
            catch (IllegalAccessException e) {
                super.serializeTo(instance, node);
            }
        }
    }

    protected static class DefaultFieldData
    extends ObjectMapper.FieldData {
        private final boolean useIfNullWhenSaving;
        private final String defaultValue;
        private final ObjectMapper.FieldData fieldData;
        private final TypeToken<?> typeToken;
        private final Field field;
        private final boolean useIfEmpty;
        private final boolean set;
        private final String comment;

        protected DefaultFieldData(Field field, String comment, ObjectMapper.FieldData data, String defaultValue, boolean useIfNullWhenSaving, boolean useIfEmpty, boolean set) throws ObjectMappingException {
            super(field, comment);
            this.comment = comment;
            this.field = field;
            this.typeToken = TypeToken.of((Type)field.getGenericType());
            this.defaultValue = defaultValue;
            this.fieldData = data;
            this.useIfNullWhenSaving = useIfNullWhenSaving;
            this.useIfEmpty = useIfEmpty;
            this.set = set;
        }

        public void deserializeFrom(Object instance, ConfigurationNode node) throws ObjectMappingException {
            if (!this.set) {
                try {
                    this.setDefaultOnField(instance, node);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                return;
            }
            try {
                this.fieldData.deserializeFrom(instance, node);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (node.isVirtual() || node.getValue() == null || this.useIfEmpty && node.getString().isEmpty()) {
                    this.setDefaultOnField(instance, node);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        private void setDefaultOnField(Object instance, ConfigurationNode node) throws ObjectMappingException, IllegalAccessException {
            this.field.setAccessible(true);
            this.field.set(instance, node.getOptions().getSerializers().get(this.typeToken).deserialize(this.typeToken, (ConfigurationNode)SimpleConfigurationNode.root((ConfigurationOptions)node.getOptions()).setValue((Object)this.defaultValue)));
        }

        public void serializeTo(Object instance, ConfigurationNode node) throws ObjectMappingException {
            Object i;
            try {
                i = this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                i = null;
            }
            if (this.set) {
                if (this.useIfNullWhenSaving && i == null) {
                    node.setValue((Object)this.defaultValue);
                    if (this.comment != null && !this.comment.isEmpty() && node instanceof CommentedConfigurationNode) {
                        ((CommentedConfigurationNode)node).setComment(this.comment);
                    }
                } else {
                    this.fieldData.serializeTo(instance, node);
                }
            }
        }
    }
}

