/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.command;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mcsimonflash.sponge.cmdcontrol.CmdControl;
import com.mcsimonflash.sponge.cmdcontrol.command.parser.SourceParser;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.source.ConsoleSource;

@Singleton
@Aliases(value={"execute", "ex"})
@Permission(value="cmdcontrol.command.execute.base")
public class Execute
extends Command {
    @Inject
    private Execute(Command.Settings settings) {
        super(settings.elements(Arguments.flags().flag(Arguments.duration().toElement("delay"), "delay", "d").flag(SourceParser.PARSER.toElement("source"), "source", "s").build(), Arguments.command().toElement("command")).usage(CmdUtils.usage("/cmdcontrol execute ", CmdUtils.info("Execute", "Executes a command from a source.\n", "", "execute, ex\n", "cmdcontrol.command.execute.base"), CmdUtils.arg(false, "-delay", CmdUtils.info("Delay", "The delay for this execution\n", "Duration (10s800ms = 10 seconds, 800 milliseconds)\n", "-delay, -d\n", "cmdcontrol.command.execute.delay")), CmdUtils.arg(false, "-source", CmdUtils.info("Source", "The source of the command\n", "CommandSource (a player or #console)\n", "-source, -s\n", "cmdcontrol.command.execute.other, cmdcontrol.command.execute.console")), CmdUtils.arg(true, "command", CmdUtils.info("Command", "The command to be executed\n", "Command (no forward slash)\n", "", "")))));
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        long delay;
        CommandSource source = args.getOne("source").orElse(src);
        if (source != src) {
            if (source instanceof ConsoleSource && !src.hasPermission("cmdcontrol.command.execute.console")) {
                throw new CommandException(CmdControl.getMessage(src, "cmdcontrol.command.execute.console.no-permission", new Object[0]));
            }
            if (!src.hasPermission("cmdcontrol.command.execute.other")) {
                throw new CommandException(CmdControl.getMessage(src, "cmdcontrol.command.execute.other.no-permission", new Object[0]));
            }
        }
        if ((delay = args.getOne("delay").orElse(0L).longValue()) > 0L && !src.hasPermission("cmdcontrol.command.execute.delay")) {
            throw new CommandException(CmdControl.getMessage(src, "cmdcontrol.command.execute.delay.no-permission", new Object[0]));
        }
        return CmdUtils.execute(source, (String)args.getOne("command").get(), delay);
    }
}

