/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.CollisionHelper;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public abstract class ComponentMenuTarget
extends ComponentMenu {
    private static final int BUTTON_SIZE_H = 12;
    private static final int BUTTON_SIZE_W = 42;
    private static final int BUTTON_SRC_X = 0;
    private static final int BUTTON_SRC_Y = 106;
    private static final int BUTTON_TEXT_Y = 5;
    private static final int BUTTON_X = 39;
    private static final int DIRECTION_MARGIN = 10;
    private static final int DIRECTION_SIZE_H = 12;
    private static final int DIRECTION_SIZE_W = 31;
    private static final int DIRECTION_SRC_X = 0;
    private static final int DIRECTION_SRC_Y = 70;
    private static final int DIRECTION_TEXT_X = 2;
    private static final int DIRECTION_TEXT_Y = 3;
    private static final int DIRECTION_X_LEFT = 2;
    private static final int DIRECTION_X_RIGHT = 88;
    private static final int DIRECTION_Y = 5;
    private static final String NBT_ACTIVE = "Active";
    private static final String NBT_DIRECTIONS = "Directions";
    private static final String NBT_RANGE = "UseRange";
    public static EnumFacing[] directions = EnumFacing.values();
    protected int selectedDirectionId = -1;
    private boolean[] activatedDirections = new boolean[directions.length];
    private Button[] buttons = new Button[]{new Button(5){

        @Override
        protected String getLabel() {
            return ComponentMenuTarget.this.isActive(ComponentMenuTarget.this.selectedDirectionId) ? Localization.DEACTIVATE.toString() : Localization.ACTIVATE.toString();
        }

        @Override
        protected String getMouseOverText() {
            return ComponentMenuTarget.this.isActive(ComponentMenuTarget.this.selectedDirectionId) ? Localization.DEACTIVATE_LONG.toString() : Localization.ACTIVATE_LONG.toString();
        }

        @Override
        protected void onClicked() {
            ComponentMenuTarget.this.writeData(DataTypeHeader.ACTIVATE, ComponentMenuTarget.this.isActive(ComponentMenuTarget.this.selectedDirectionId) ? 0 : 1);
        }
    }, this.getSecondButton()};
    private boolean[] useRangeForDirections = new boolean[directions.length];

    public ComponentMenuTarget(FlowComponent parent) {
        super(parent);
    }

    protected abstract Button getSecondButton();

    @Override
    public String getName() {
        return Localization.TARGET_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        for (int i = 0; i < directions.length; ++i) {
            int srcDirectionX;
            EnumFacing direction = directions[i];
            int x = this.getDirectionX(i);
            int y = this.getDirectionY(i);
            int n = srcDirectionX = this.isActive(i) ? 1 : 0;
            int srcDirectionY = this.selectedDirectionId != -1 && this.selectedDirectionId != i ? 2 : (CollisionHelper.inBounds(x, y, 31, 12, mX, mY) ? 1 : 0);
            gui.drawTexture(x, y, 0 + srcDirectionX * 31, 70 + srcDirectionY * 12, 31, 12);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            int color = this.selectedDirectionId != -1 && this.selectedDirectionId != i ? 0x70404040 : 0x404040;
            gui.drawString(Localization.getDirectionLocalization(EnumFacing.func_82600_a((int)i)).toString(), x + 2, y + 3, color);
            GlStateManager.func_179121_F();
        }
        if (this.selectedDirectionId != -1) {
            for (Button button : this.buttons) {
                int srcButtonY = CollisionHelper.inBounds(39, button.y, 42, 12, mX, mY) ? 1 : 0;
                gui.drawTexture(39, button.y, 0, 106 + srcButtonY * 12, 42, 12);
                gui.drawCenteredString(button.getLabel(), 39, button.y + 5, 0.5f, 42, 0x404040);
            }
            if (this.useAdvancedSetting(this.selectedDirectionId)) {
                this.drawAdvancedComponent(gui, mX, mY);
            }
        }
    }

    public boolean isActive(int i) {
        return this.activatedDirections[i];
    }

    private int getDirectionX(int i) {
        return i % 2 == 0 ? 2 : 88;
    }

    public boolean useAdvancedSetting(int i) {
        return this.useRangeForDirections[i];
    }

    private int getDirectionY(int i) {
        return 5 + 22 * (i / 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        if (this.selectedDirectionId != -1) {
            for (Button button : this.buttons) {
                if (!CollisionHelper.inBounds(39, button.y, 42, 12, mX, mY)) continue;
                gui.drawMouseOver(button.getMouseOverText(), mX, mY);
            }
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        for (int i = 0; i < directions.length; ++i) {
            if (!CollisionHelper.inBounds(this.getDirectionX(i), this.getDirectionY(i), 31, 12, mX, mY)) continue;
            if (this.selectedDirectionId == i) {
                this.selectedDirectionId = -1;
                break;
            }
            this.selectedDirectionId = i;
            this.refreshAdvancedComponent();
            break;
        }
        if (this.selectedDirectionId != -1) {
            for (Button optionButton : this.buttons) {
                if (!CollisionHelper.inBounds(39, optionButton.y, 42, 12, mX, mY)) continue;
                optionButton.onClicked();
                break;
            }
            if (this.useAdvancedSetting(this.selectedDirectionId)) {
                this.onAdvancedClick(mX, mY, button);
            }
        }
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        for (int i = 0; i < directions.length; ++i) {
            dw.writeBoolean(this.isActive(i));
            dw.writeBoolean(this.useAdvancedSetting(i));
            if (!this.useAdvancedSetting(i)) continue;
            this.writeAdvancedSetting(dw, i);
        }
    }

    protected abstract void writeAdvancedSetting(DataWriter var1, int var2);

    @Override
    public void readData(DataReader dr) {
        for (int i = 0; i < directions.length; ++i) {
            this.activatedDirections[i] = dr.readBoolean();
            this.useRangeForDirections[i] = dr.readBoolean();
            if (this.useAdvancedSetting(i)) {
                this.readAdvancedSetting(dr, i);
                continue;
            }
            this.resetAdvancedSetting(i);
        }
    }

    protected abstract void readAdvancedSetting(DataReader var1, int var2);

    protected abstract void resetAdvancedSetting(int var1);

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuTarget menuTarget = (ComponentMenuTarget)menu;
        for (int i = 0; i < directions.length; ++i) {
            this.activatedDirections[i] = menuTarget.activatedDirections[i];
            this.useRangeForDirections[i] = menuTarget.useRangeForDirections[i];
            this.copyAdvancedSetting(menu, i);
        }
    }

    protected abstract void copyAdvancedSetting(ComponentMenu var1, int var2);

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuTarget newDataTarget = (ComponentMenuTarget)newData;
        for (int i = 0; i < directions.length; ++i) {
            if (this.activatedDirections[i] != newDataTarget.activatedDirections[i]) {
                this.activatedDirections[i] = newDataTarget.activatedDirections[i];
                this.writeUpdatedData(container, i, DataTypeHeader.ACTIVATE, this.activatedDirections[i] ? 1 : 0);
            }
            if (this.useRangeForDirections[i] != newDataTarget.useRangeForDirections[i]) {
                this.useRangeForDirections[i] = newDataTarget.useRangeForDirections[i];
                this.writeUpdatedData(container, i, DataTypeHeader.USE_ADVANCED_SETTING, this.useRangeForDirections[i] ? 1 : 0);
            }
            this.refreshAdvancedComponentData(container, newData, i);
        }
    }

    protected abstract void refreshAdvancedComponentData(ContainerManager var1, ComponentMenu var2, int var3);

    protected void writeUpdatedData(ContainerManager container, int id, DataTypeHeader header, int data) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, id, header, data);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    private void writeData(DataWriter dw, int id, DataTypeHeader header, int data) {
        dw.writeData(id, DataBitHelper.MENU_TARGET_DIRECTION_ID);
        dw.writeData(header.id, DataBitHelper.MENU_TARGET_TYPE_HEADER);
        dw.writeData(data, header.bits);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        NBTTagList directionTagList = nbtTagCompound.func_150295_c(NBT_DIRECTIONS, 10);
        for (int i = 0; i < directionTagList.func_74745_c(); ++i) {
            NBTTagCompound directionTag = directionTagList.func_150305_b(i);
            this.activatedDirections[i] = directionTag.func_74767_n(NBT_ACTIVE);
            this.useRangeForDirections[i] = directionTag.func_74767_n(NBT_RANGE);
            this.loadAdvancedComponent(directionTag, i);
        }
    }

    protected abstract void loadAdvancedComponent(NBTTagCompound var1, int var2);

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        NBTTagList directionTagList = new NBTTagList();
        for (int i = 0; i < directions.length; ++i) {
            NBTTagCompound directionTag = new NBTTagCompound();
            directionTag.func_74757_a(NBT_ACTIVE, this.isActive(i));
            directionTag.func_74757_a(NBT_RANGE, this.useAdvancedSetting(i));
            this.saveAdvancedComponent(directionTag, i);
            directionTagList.func_74742_a((NBTBase)directionTag);
        }
        nbtTagCompound.func_74782_a(NBT_DIRECTIONS, (NBTBase)directionTagList);
    }

    protected abstract void saveAdvancedComponent(NBTTagCompound var1, int var2);

    @Override
    public void addErrors(List<String> errors) {
        for (int i = 0; i < directions.length; ++i) {
            if (!this.isActive(i)) continue;
            return;
        }
        errors.add(Localization.NO_DIRECTION_ERROR.toString());
    }

    protected abstract void refreshAdvancedComponent();

    protected abstract void onAdvancedClick(int var1, int var2, int var3);

    @SideOnly(value=Side.CLIENT)
    protected abstract void drawAdvancedComponent(GuiManager var1, int var2, int var3);

    @Override
    public void readNetworkComponent(DataReader dr) {
        int direction = dr.readData(DataBitHelper.MENU_TARGET_DIRECTION_ID);
        int headerId = dr.readData(DataBitHelper.MENU_TARGET_TYPE_HEADER);
        DataTypeHeader header = this.getHeaderFromId(headerId);
        switch (header) {
            case ACTIVATE: {
                this.activatedDirections[direction] = dr.readData(header.bits) != 0;
                break;
            }
            case USE_ADVANCED_SETTING: {
                boolean bl = this.useRangeForDirections[direction] = dr.readData(header.bits) != 0;
                if (this.useAdvancedSetting(direction)) break;
                this.resetAdvancedSetting(direction);
                break;
            }
            default: {
                this.readAdvancedNetworkComponent(dr, header, direction);
            }
        }
    }

    protected abstract void readAdvancedNetworkComponent(DataReader var1, DataTypeHeader var2, int var3);

    private DataTypeHeader getHeaderFromId(int id) {
        for (DataTypeHeader header : DataTypeHeader.values()) {
            if (id != header.id) continue;
            return header;
        }
        return null;
    }

    protected void writeData(DataTypeHeader header, int data) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, this.selectedDirectionId, header, data);
        PacketHandler.sendDataToServer(dw);
    }

    public void setActive(int side) {
        this.activatedDirections[side] = true;
    }

    protected abstract class Button {
        private int y;

        protected Button(int y) {
            this.y = y;
        }

        protected abstract String getLabel();

        protected abstract String getMouseOverText();

        protected abstract void onClicked();
    }

    protected static enum DataTypeHeader {
        ACTIVATE(0, DataBitHelper.BOOLEAN),
        USE_ADVANCED_SETTING(1, DataBitHelper.BOOLEAN),
        START_OR_TANK_DATA(2, DataBitHelper.MENU_TARGET_RANGE),
        END(3, DataBitHelper.MENU_TARGET_RANGE);

        private DataBitHelper bits;
        private int id;

        private DataTypeHeader(int header, DataBitHelper bits) {
            this.id = header;
            this.bits = bits;
        }

        public int getId() {
            return this.id;
        }

        public DataBitHelper getBits() {
            return this.bits;
        }
    }
}

