/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.network.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.blocks.ITileEntityInterface;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.Connection;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.Point;
import vswe.superfactory.interfaces.ContainerBase;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.IPacketBlock;
import vswe.superfactory.tiles.TileEntityManager;

public class PacketHandler {
    public static final double BLOCK_UPDATE_RANGE = 128.0;

    public static void sendDataToServer(DataWriter dw) {
        dw.sendServerPacket();
        dw.close();
    }

    public static void sendAllData(Container container, IContainerListener crafting, ITileEntityInterface te) {
        DataWriter dw = new DataWriter();
        dw.writeBoolean(true);
        dw.writeByte(container.field_75152_c);
        dw.writeBoolean(false);
        te.writeAllData(dw);
        PacketHandler.sendDataToPlayer(crafting, dw);
        dw.close();
    }

    public static void sendDataToPlayer(IContainerListener crafting, DataWriter dw) {
        if (crafting instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)crafting;
            dw.sendPlayerPacket(player);
        }
    }

    public static DataWriter getWriterForUpdate(Container container) {
        DataWriter dw = new DataWriter();
        dw.writeBoolean(true);
        dw.writeByte(container.field_75152_c);
        dw.writeBoolean(true);
        return dw;
    }

    @SideOnly(value=Side.CLIENT)
    public static DataWriter getWriterForServerActionPacket() {
        DataWriter dw = PacketHandler.getBaseWriterForServerPacket();
        dw.writeBoolean(true);
        return dw;
    }

    @SideOnly(value=Side.CLIENT)
    private static DataWriter getBaseWriterForServerPacket() {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container != null) {
            DataWriter dw = new DataWriter();
            dw.writeBoolean(true);
            dw.writeByte(container.field_75152_c);
            return dw;
        }
        return null;
    }

    public static void sendUpdateInventoryPacket(ContainerManager container) {
        DataWriter dw = PacketHandler.getWriterForSpecificData(container);
        PacketHandler.createNonComponentPacket(dw);
        dw.writeBoolean(true);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    public static void sendDataToListeningClients(ContainerBase container, DataWriter dw) {
        dw.sendPlayerPackets(container);
        dw.close();
    }

    private static DataWriter getWriterForSpecificData(Container container) {
        DataWriter dw = new DataWriter();
        dw.writeBoolean(true);
        dw.writeByte(container.field_75152_c);
        dw.writeBoolean(true);
        dw.writeBoolean(false);
        return dw;
    }

    private static void createNonComponentPacket(DataWriter dw) {
        dw.writeBoolean(false);
    }

    public static DataWriter getWriterForServerComponentPacket(FlowComponent component, ComponentMenu menu) {
        DataWriter dw = PacketHandler.getWriterForServerPacket();
        PacketHandler.createComponentPacket(dw, component, menu);
        return dw;
    }

    @SideOnly(value=Side.CLIENT)
    public static DataWriter getWriterForServerPacket() {
        DataWriter dw = PacketHandler.getBaseWriterForServerPacket();
        dw.writeBoolean(false);
        return dw;
    }

    private static void createComponentPacket(DataWriter dw, FlowComponent component, ComponentMenu menu) {
        dw.writeBoolean(true);
        dw.writeComponentId(component.getManager(), component.getId());
        if (menu != null) {
            dw.writeBoolean(true);
            dw.writeData(menu.getId(), DataBitHelper.FLOW_CONTROL_MENU_COUNT);
        } else {
            dw.writeBoolean(false);
        }
    }

    public static DataWriter getWriterForClientComponentPacket(ContainerManager container, FlowComponent component, ComponentMenu menu) {
        DataWriter dw = PacketHandler.getWriterForSpecificData(container);
        PacketHandler.createComponentPacket(dw, component, menu);
        return dw;
    }

    public static DataWriter getButtonPacketWriter() {
        DataWriter dw = PacketHandler.getWriterForServerPacket();
        PacketHandler.createNonComponentPacket(dw);
        return dw;
    }

    public static void sendNewFlowComponent(ContainerManager container, FlowComponent component) {
        DataWriter dw = new DataWriter();
        dw.writeBoolean(true);
        dw.writeByte(container.field_75152_c);
        dw.writeBoolean(true);
        dw.writeBoolean(true);
        PacketHandler.writeAllComponentData(dw, component);
        PacketHandler.sendDataToListeningClients(container, dw);
        dw.close();
    }

    public static void writeAllComponentData(DataWriter dw, FlowComponent flowComponent) {
        dw.writeData(flowComponent.getX(), DataBitHelper.FLOW_CONTROL_X);
        dw.writeData(flowComponent.getY(), DataBitHelper.FLOW_CONTROL_Y);
        dw.writeData(flowComponent.getType().getId(), DataBitHelper.FLOW_CONTROL_TYPE_ID);
        dw.writeString(flowComponent.getComponentName(), DataBitHelper.NAME_LENGTH);
        if (flowComponent.getParent() != null) {
            dw.writeBoolean(true);
            dw.writeComponentId(flowComponent.getManager(), flowComponent.getParent().getId());
        } else {
            dw.writeBoolean(false);
        }
        for (ComponentMenu menu : flowComponent.getMenus()) {
            menu.writeData(dw);
        }
        for (int i = 0; i < flowComponent.getConnectionSet().getConnections().length; ++i) {
            Connection connection = flowComponent.getConnection(i);
            dw.writeBoolean(connection != null);
            if (connection == null) continue;
            dw.writeComponentId(flowComponent.getManager(), connection.getComponentId());
            dw.writeData(connection.getConnectionId(), DataBitHelper.CONNECTION_ID);
            dw.writeData(connection.getNodes().size(), DataBitHelper.NODE_ID);
            for (Point point : connection.getNodes()) {
                dw.writeData(point.getX(), DataBitHelper.FLOW_CONTROL_X);
                dw.writeData(point.getY(), DataBitHelper.FLOW_CONTROL_Y);
            }
        }
        flowComponent.getManager().updateVariables();
    }

    public static void sendRemovalPacket(ContainerManager container, int idToRemove) {
        DataWriter dw = PacketHandler.getWriterForSpecificData(container);
        PacketHandler.createNonComponentPacket(dw);
        dw.writeBoolean(false);
        dw.writeComponentId((TileEntityManager)container.getTileEntity(), idToRemove);
        PacketHandler.sendDataToListeningClients(container, dw);
        dw.close();
    }

    public static void sendBlockPacket(IPacketBlock block, EntityPlayer player, int id) {
        if (block instanceof TileEntity) {
            TileEntity te = (TileEntity)block;
            BlockPos pos = te.func_174877_v();
            boolean onServer = player == null || !player.field_70170_p.field_72995_K;
            DataWriter dw = new DataWriter();
            dw.writeBoolean(false);
            dw.writeData(pos.func_177958_n(), DataBitHelper.WORLD_COORDINATE);
            dw.writeData(pos.func_177956_o(), DataBitHelper.WORLD_COORDINATE);
            dw.writeData(pos.func_177952_p(), DataBitHelper.WORLD_COORDINATE);
            int length = block.infoBitLength(onServer);
            if (length != 0) {
                dw.writeData(id, length);
            }
            block.writeData(dw, player, onServer, id);
            if (!onServer) {
                dw.sendServerPacket();
            } else if (player != null) {
                dw.sendPlayerPacket((EntityPlayerMP)player);
            } else {
                dw.sendPlayerPackets((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), pos.func_177952_p(), 128.0, te.func_145831_w().field_73011_w.getDimension());
            }
            dw.close();
        }
    }
}

