/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.AllyRequest;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class AllyCommand
extends AbstractCommand {
    public AllyCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Faction selectedFaction = (Faction)context.requireOne((Text)Text.of((String)"faction"));
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (playerFaction.getName().equals(selectedFaction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANNOT_INVITE_YOURSELF_TO_THE_ALLIANCE}));
        }
        if (super.getPlugin().getPlayerManager().hasAdminMode((User)player)) {
            if (playerFaction.getEnemies().contains(selectedFaction.getName())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_ARE_IN_WAR_WITH_THIS_FACTION + " " + Messages.SEND_THIS_FACTION_A_PEACE_REQUEST_FIRST_BEFORE_INVITING_THEM_TO_ALLIES}));
            }
            if (playerFaction.getTruces().contains(selectedFaction.getName())) {
                super.getPlugin().getFactionLogic().removeTruce(playerFaction.getName(), selectedFaction.getName());
                super.getPlugin().getFactionLogic().addAlly(playerFaction.getName(), selectedFaction.getName());
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.FACTION_HAS_BEEN_ADDED_TO_THE_ALLIANCE}));
            }
            if (playerFaction.getAlliances().contains(selectedFaction.getName())) {
                super.getPlugin().getFactionLogic().removeAlly(playerFaction.getName(), selectedFaction.getName());
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.YOU_DISBANDED_YOUR_ALLIANCE_WITH_FACTION, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, selectedFaction.getName()})))}));
            } else {
                super.getPlugin().getFactionLogic().addAlly(playerFaction.getName(), selectedFaction.getName());
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.FACTION_HAS_BEEN_ADDED_TO_THE_ALLIANCE}));
            }
            return CommandResult.success();
        }
        if (!playerFaction.getLeader().equals(player.getUniqueId()) && !playerFaction.getOfficers().contains(player.getUniqueId())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_THE_FACTIONS_LEADER_OR_OFFICER_TO_DO_THIS}));
        }
        if (playerFaction.getEnemies().contains(selectedFaction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_ARE_IN_WAR_WITH_THIS_FACTION + " " + Messages.SEND_THIS_FACTION_A_PEACE_REQUEST_FIRST_BEFORE_INVITING_THEM_TO_ALLIES}));
        }
        if (playerFaction.getTruces().contains(selectedFaction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, Messages.DISBAND_TRUCE_FIRST_TO_INVITE_FACTION_TO_THE_ALLIANCE}));
        }
        if (playerFaction.getAlliances().contains(selectedFaction.getName())) {
            super.getPlugin().getFactionLogic().removeAlly(playerFaction.getName(), selectedFaction.getName());
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.YOU_DISBANDED_YOUR_ALLIANCE_WITH_FACTION, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, selectedFaction.getName()})))}));
        } else {
            AllyRequest checkInvite = new AllyRequest(selectedFaction.getName(), playerFaction.getName());
            if (EagleFactionsPlugin.ALLY_INVITE_LIST.contains(checkInvite)) {
                this.acceptInvite(player, playerFaction, selectedFaction);
                EagleFactionsPlugin.ALLY_INVITE_LIST.remove(checkInvite);
            } else if (!EagleFactionsPlugin.ALLY_INVITE_LIST.contains(checkInvite)) {
                this.sendInvite(player, playerFaction, selectedFaction);
            }
        }
        return CommandResult.success();
    }

    private void acceptInvite(Player player, Faction playerFaction, Faction senderFaction) {
        super.getPlugin().getFactionLogic().addAlly(playerFaction.getName(), senderFaction.getName());
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.YOU_HAVE_ACCEPTED_AN_INVITATION_FROM_FACTION, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, senderFaction.getName()})))}));
        Optional<Player> optionalSenderFactionLeader = super.getPlugin().getPlayerManager().getPlayer(senderFaction.getLeader());
        optionalSenderFactionLeader.ifPresent(x -> ((Player)optionalSenderFactionLeader.get()).sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_INVITE_TO_THE_ALLIANCE, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, playerFaction.getName()})))})));
        senderFaction.getOfficers().forEach(x -> super.getPlugin().getPlayerManager().getPlayer((UUID)x).ifPresent(y -> Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.FACTION_ACCEPTED_YOUR_INVITE_TO_THE_ALLIANCE, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, playerFaction.getName()})))})));
    }

    private void sendInvite(Player player, Faction playerFaction, Faction targetFaction) throws CommandException {
        AllyRequest invite = new AllyRequest(playerFaction.getName(), targetFaction.getName());
        if (EagleFactionsPlugin.ALLY_INVITE_LIST.contains(invite)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, Messages.YOU_HAVE_ALREADY_INVITED_THIS_FACTION_TO_THE_ALLIANCE}));
        }
        EagleFactionsPlugin.ALLY_INVITE_LIST.add(invite);
        Optional<Player> optionalInvitedFactionLeader = super.getPlugin().getPlayerManager().getPlayer(targetFaction.getLeader());
        optionalInvitedFactionLeader.ifPresent(x -> ((Player)optionalInvitedFactionLeader.get()).sendMessage(this.getInviteGetMessage(playerFaction)));
        targetFaction.getOfficers().forEach(x -> super.getPlugin().getPlayerManager().getPlayer((UUID)x).ifPresent(y -> this.getInviteGetMessage(playerFaction)));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.YOU_HAVE_INVITED_FACTION_TO_THE_ALLIANCE, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, targetFaction.getName()})))}));
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.execute(() -> EagleFactionsPlugin.ALLY_INVITE_LIST.remove(invite)).delay(2L, TimeUnit.MINUTES).name("EagleFaction - Remove Invite").submit((Object)super.getPlugin());
    }

    private Text getInviteGetMessage(Faction senderFaction) {
        Text clickHereText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "[", TextColors.GOLD, Messages.CLICK_HERE, TextColors.AQUA, "]"})}).onClick((ClickAction)TextActions.runCommand((String)("/f ally " + senderFaction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, "/f ally " + senderFaction.getName()}))).build();
        return Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.FACTION_HAS_SENT_YOU_AN_INVITE_TO_THE_ALLIANCE, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.FACTION_NAME, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, senderFaction.getName()}))), "\n", Messages.YOU_HAVE_TWO_MINUTES_TO_ACCEPT_IT, "\n", clickHereText, Messages.TO_ACCEPT_INVITATION_OR_TYPE, " ", TextColors.GOLD, "/f ally ", senderFaction.getName()});
    }
}

