/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import java.util.Iterator;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class NotifyNeighborBlockEventListener
extends AbstractListener {
    public NotifyNeighborBlockEventListener(EagleFactions plugin) {
        super(plugin);
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onNeighbourNotify(NotifyNeighborBlockEvent event) {
        Living living;
        Cause cause = event.getCause();
        EventContext context = event.getContext();
        TileEntity tileEntity = event.getCause().first(TileEntity.class).orElse(null);
        LocatableBlock locatableBlock = cause.first(LocatableBlock.class).orElse(null);
        Location sourceLocation = locatableBlock != null ? locatableBlock.getLocation() : (tileEntity != null ? tileEntity.getLocation() : null);
        User user = cause.root() instanceof TileEntity ? (User)context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.CREATOR).orElse(null))) : (User)context.get(EventContextKeys.NOTIFIER).orElse(context.get(EventContextKeys.OWNER).orElse(context.get(EventContextKeys.CREATOR).orElse(null)));
        if (user == null && event instanceof ExplosionEvent && (living = (Living)context.get(EventContextKeys.IGNITER).orElse(null)) instanceof User) {
            user = (User)living;
        }
        if (user == null) {
            return;
        }
        if (sourceLocation == null) {
            Player player = event.getCause().first(Player.class).orElse(null);
            if (player == null) {
                return;
            }
            sourceLocation = player.getLocation();
        }
        if (!super.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)sourceLocation, user, false)) {
            event.setCancelled(true);
            return;
        }
        Location finalSourceLocation = sourceLocation;
        User finalUser = user;
        Iterator directionIterator = event.getNeighbors().keySet().iterator();
        while (directionIterator.hasNext()) {
            Direction direction = (Direction)directionIterator.next();
            Location blockLocation = finalSourceLocation.getBlockRelative(direction);
            if (super.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)blockLocation, finalUser, false)) continue;
            directionIterator.remove();
        }
    }
}

