/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.region;

import com.universeguard.UniverseGuard;
import com.universeguard.region.components.RegionCommand;
import com.universeguard.region.components.RegionExcludedBlocks;
import com.universeguard.region.components.RegionExplosion;
import com.universeguard.region.components.RegionFlag;
import com.universeguard.region.components.RegionInteract;
import com.universeguard.region.components.RegionMob;
import com.universeguard.region.components.RegionVehicle;
import com.universeguard.region.enums.EnumRegionBlock;
import com.universeguard.region.enums.EnumRegionExplosion;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.region.enums.EnumRegionInteract;
import com.universeguard.region.enums.EnumRegionVehicle;
import com.universeguard.region.enums.RegionType;
import com.universeguard.utils.FlagUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.item.ItemType;

public class Region {
    private float VERSION = UniverseGuard.REGION_VERSION;
    private UUID ID = UUID.randomUUID();
    private RegionType TYPE;
    private String NAME;
    private String GAMEMODE;
    private ArrayList<RegionFlag> FLAGS;
    private ArrayList<RegionInteract> INTERACTS;
    private ArrayList<RegionVehicle> VEHICLES;
    private ArrayList<RegionExplosion> EXPLOSIONS;
    private ArrayList<RegionMob> MOBS;
    private ArrayList<RegionCommand> COMMANDS;
    private RegionExcludedBlocks EXCLUDED_BLOCKS;
    private ArrayList<String> DISALLOWED_ITEMS;
    private boolean TEMPLATE;

    public Region(RegionType type) {
        this(type, "", false);
    }

    public Region(RegionType type, String name, boolean template) {
        this(type, name, GameModes.NOT_SET.getId(), template);
    }

    public Region(RegionType type, String name, String gamemode, boolean template) {
        this.TYPE = type;
        this.NAME = name;
        this.GAMEMODE = gamemode;
        this.COMMANDS = new ArrayList();
        this.EXCLUDED_BLOCKS = new RegionExcludedBlocks();
        this.DISALLOWED_ITEMS = new ArrayList();
        this.TEMPLATE = template;
        this.initFlags();
    }

    public void setId(UUID id) {
        this.ID = id;
    }

    public UUID getId() {
        return this.ID;
    }

    public void initFlags() {
        this.FLAGS = new ArrayList();
        this.INTERACTS = new ArrayList();
        this.VEHICLES = new ArrayList();
        this.EXPLOSIONS = new ArrayList();
        this.MOBS = new ArrayList();
        for (EnumRegionFlag enumRegionFlag : EnumRegionFlag.values()) {
            this.FLAGS.add(new RegionFlag(enumRegionFlag));
        }
        for (Enum enum_ : EnumRegionInteract.values()) {
            this.INTERACTS.add(new RegionInteract((EnumRegionInteract)enum_));
        }
        for (Enum enum_ : EnumRegionVehicle.values()) {
            this.VEHICLES.add(new RegionVehicle((EnumRegionVehicle)enum_));
        }
        for (Enum enum_ : EnumRegionExplosion.values()) {
            this.EXPLOSIONS.add(new RegionExplosion((EnumRegionExplosion)enum_));
        }
    }

    public void updateFlags() {
        this.removeOldFlags();
        this.setMissingFlags();
    }

    public void setMissingFlags() {
        boolean update = false;
        for (EnumRegionFlag enumRegionFlag : EnumRegionFlag.values()) {
            RegionFlag flag = new RegionFlag(enumRegionFlag);
            for (RegionFlag flags : this.FLAGS) {
                if (!flags.getName().equalsIgnoreCase(flag.getName())) {
                    update = true;
                    continue;
                }
                update = false;
                break;
            }
            if (!update) continue;
            this.FLAGS.add(flag);
        }
        update = false;
        for (Enum enum_ : EnumRegionInteract.values()) {
            RegionInteract interact = new RegionInteract((EnumRegionInteract)enum_);
            for (RegionInteract interacts : this.INTERACTS) {
                if (!interacts.getBlock().equalsIgnoreCase(interact.getBlock())) {
                    update = true;
                    continue;
                }
                update = false;
                break;
            }
            if (!update) continue;
            this.INTERACTS.add(interact);
        }
        update = false;
        for (Enum enum_ : EnumRegionVehicle.values()) {
            RegionVehicle vehicle = new RegionVehicle((EnumRegionVehicle)enum_);
            for (RegionVehicle vehicles : this.VEHICLES) {
                if (!vehicles.getName().equalsIgnoreCase(vehicle.getName())) {
                    update = true;
                    continue;
                }
                update = false;
                break;
            }
            if (!update) continue;
            this.VEHICLES.add(vehicle);
        }
        update = false;
        for (Enum enum_ : EnumRegionExplosion.values()) {
            RegionExplosion explosion = new RegionExplosion((EnumRegionExplosion)enum_);
            for (RegionExplosion explosions : this.EXPLOSIONS) {
                if (!explosions.getExplosion().equalsIgnoreCase(explosion.getExplosion())) {
                    update = true;
                    continue;
                }
                update = false;
                break;
            }
            if (!update) continue;
            this.EXPLOSIONS.add(explosion);
        }
    }

    public void removeOldFlags() {
        ArrayList<RegionFlag> flagsToRemove = new ArrayList<RegionFlag>();
        ArrayList<RegionInteract> interactsToRemove = new ArrayList<RegionInteract>();
        ArrayList<RegionVehicle> vehiclesToRemove = new ArrayList<RegionVehicle>();
        ArrayList<RegionExplosion> explosionsToRemove = new ArrayList<RegionExplosion>();
        for (RegionFlag f : this.FLAGS) {
            EnumRegionFlag flag = FlagUtils.getFlag(f.getName());
            if (flag != null) continue;
            flagsToRemove.add(f);
        }
        for (RegionInteract i : this.INTERACTS) {
            EnumRegionInteract interact = FlagUtils.getInteract(i.getBlock());
            if (interact != null) continue;
            interactsToRemove.add(i);
        }
        for (RegionVehicle v : this.VEHICLES) {
            EnumRegionVehicle vehicle = FlagUtils.getVehicle(v.getName());
            if (vehicle != null) continue;
            vehiclesToRemove.add(v);
        }
        for (RegionExplosion e : this.EXPLOSIONS) {
            EnumRegionExplosion explosion = FlagUtils.getExplosion(e.getExplosion());
            if (explosion != null) continue;
            explosionsToRemove.add(e);
        }
        this.FLAGS.removeAll(flagsToRemove);
        this.INTERACTS.removeAll(interactsToRemove);
        this.VEHICLES.removeAll(vehiclesToRemove);
        this.EXPLOSIONS.removeAll(explosionsToRemove);
    }

    public void setType(RegionType type) {
        this.TYPE = type;
    }

    public RegionType getType() {
        return this.TYPE;
    }

    public void setName(String name) {
        this.NAME = name;
    }

    public String getName() {
        return this.NAME;
    }

    public void setFlags(ArrayList<RegionFlag> flags) {
        this.FLAGS = flags;
    }

    public ArrayList<RegionFlag> getFlags() {
        return this.FLAGS;
    }

    public void setFlag(EnumRegionFlag flag, boolean value) {
        for (RegionFlag f : this.FLAGS) {
            if (!f.getName().equalsIgnoreCase(flag.getName())) continue;
            f.setValue(value);
        }
    }

    public boolean getFlag(EnumRegionFlag flag) {
        for (RegionFlag f : this.FLAGS) {
            if (!f.getName().equalsIgnoreCase(flag.getName())) continue;
            return f.getValue();
        }
        return false;
    }

    public void setAllInteract(boolean value) {
        for (RegionInteract i : this.INTERACTS) {
            i.setEnabled(value);
        }
    }

    public void setInteract(EnumRegionInteract interact, boolean value) {
        for (RegionInteract i : this.INTERACTS) {
            if (!i.getBlock().equalsIgnoreCase(interact.getName())) continue;
            i.setEnabled(value);
        }
    }

    public boolean getInteract(EnumRegionInteract interact) {
        for (RegionInteract i : this.INTERACTS) {
            if (!i.getBlock().equalsIgnoreCase(interact.getName())) continue;
            return i.isEnabled();
        }
        return false;
    }

    public void setGamemode(String gamemode) {
        this.GAMEMODE = gamemode;
    }

    public String getGameMode() {
        return this.GAMEMODE;
    }

    public void setCommands(ArrayList<RegionCommand> commands) {
        this.COMMANDS = commands;
    }

    public ArrayList<RegionCommand> getCommands() {
        return this.COMMANDS;
    }

    public boolean isCommandEnabled(String command) {
        RegionCommand regionCommand = this.getRegionCommand(command);
        return regionCommand == null ? true : regionCommand.isEnabled();
    }

    public RegionCommand getRegionCommand(String command) {
        for (RegionCommand regionCommand : this.COMMANDS) {
            if (!regionCommand.getCommand().equalsIgnoreCase(command)) continue;
            return regionCommand;
        }
        return null;
    }

    public void enableCommand(String command) {
        RegionCommand regionCommand = this.getRegionCommand(command);
        if (regionCommand != null) {
            regionCommand.setEnabled(true);
            this.COMMANDS.set(this.COMMANDS.indexOf(regionCommand), regionCommand);
        } else {
            this.COMMANDS.add(new RegionCommand(command, true));
        }
    }

    public void disableCommand(String command) {
        RegionCommand regionCommand = this.getRegionCommand(command);
        if (regionCommand != null) {
            regionCommand.setEnabled(false);
            this.COMMANDS.set(this.COMMANDS.indexOf(regionCommand), regionCommand);
        } else {
            this.COMMANDS.add(new RegionCommand(command, false));
        }
    }

    public boolean getVehiclePlace(EnumRegionVehicle vehicle) {
        for (RegionVehicle v : this.VEHICLES) {
            if (!v.getName().equalsIgnoreCase(vehicle.getName())) continue;
            return v.getPlace();
        }
        return true;
    }

    public void setAllVehiclePlace(boolean value) {
        for (RegionVehicle v : this.VEHICLES) {
            v.setPlace(value);
        }
    }

    public void setVehiclePlace(EnumRegionVehicle vehicle, boolean value) {
        for (RegionVehicle v : this.VEHICLES) {
            if (!v.getName().equalsIgnoreCase(vehicle.getName())) continue;
            v.setPlace(value);
        }
    }

    public boolean getVehicleDestroy(EnumRegionVehicle vehicle) {
        for (RegionVehicle v : this.VEHICLES) {
            if (!v.getName().equalsIgnoreCase(vehicle.getName())) continue;
            return v.getDestroy();
        }
        return true;
    }

    public void setAllVehicleDestroy(boolean value) {
        for (RegionVehicle v : this.VEHICLES) {
            v.setDestroy(value);
        }
    }

    public void setVehicleDestroy(EnumRegionVehicle vehicle, boolean value) {
        for (RegionVehicle v : this.VEHICLES) {
            if (!v.getName().equalsIgnoreCase(vehicle.getName())) continue;
            v.setDestroy(value);
        }
    }

    public boolean getExplosionDamage(EnumRegionExplosion explosion) {
        for (RegionExplosion e : this.EXPLOSIONS) {
            if (!e.getExplosion().equalsIgnoreCase(explosion.getName())) continue;
            return e.getDamage();
        }
        return true;
    }

    public void setAllExplosionDamage(boolean value) {
        for (RegionExplosion e : this.EXPLOSIONS) {
            e.setDamage(value);
        }
    }

    public void setExplosionDamage(EnumRegionExplosion explosion, boolean value) {
        for (RegionExplosion e : this.EXPLOSIONS) {
            if (!e.getExplosion().equalsIgnoreCase(explosion.getName())) continue;
            e.setDamage(value);
        }
    }

    public boolean getExplosionDestroy(EnumRegionExplosion explosion) {
        for (RegionExplosion e : this.EXPLOSIONS) {
            if (!e.getExplosion().equalsIgnoreCase(explosion.getName())) continue;
            return e.getDestroy();
        }
        return true;
    }

    public void setAllExplosionDestroy(boolean value) {
        for (RegionExplosion e : this.EXPLOSIONS) {
            e.setDestroy(value);
        }
    }

    public void setExplosionDestroy(EnumRegionExplosion explosion, boolean value) {
        for (RegionExplosion e : this.EXPLOSIONS) {
            if (!e.getExplosion().equalsIgnoreCase(explosion.getName())) continue;
            e.setDestroy(value);
        }
    }

    public boolean getMobSpawn(String mob) {
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            return m.getSpawn();
        }
        return true;
    }

    public void setMobSpawn(String mob, boolean value) {
        RegionMob rm = null;
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            m.setSpawn(value);
            return;
        }
        rm = new RegionMob(mob);
        rm.setSpawn(value);
        this.MOBS.add(rm);
    }

    public boolean getMobPve(String mob) {
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            return m.getPve();
        }
        return true;
    }

    public void setMobPve(String mob, boolean value) {
        RegionMob rm = null;
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            m.setPve(value);
            return;
        }
        rm = new RegionMob(mob);
        rm.setPve(value);
        this.MOBS.add(rm);
    }

    public boolean getMobInteract(String mob) {
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            return m.getInteract();
        }
        return true;
    }

    public void setMobInteract(String mob, boolean value) {
        RegionMob rm = null;
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            m.setInteract(value);
            return;
        }
        rm = new RegionMob(mob);
        rm.setInteract(value);
        this.MOBS.add(rm);
    }

    public boolean getMobDamage(String mob) {
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            return m.getDamage();
        }
        return true;
    }

    public void setMobDamage(String mob, boolean value) {
        RegionMob rm = null;
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            m.setDamage(value);
            return;
        }
        rm = new RegionMob(mob);
        rm.setDamage(value);
        this.MOBS.add(rm);
    }

    public boolean getMobDrop(String mob) {
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            return m.getDrop();
        }
        return true;
    }

    public void setMobDrop(String mob, boolean value) {
        RegionMob rm = null;
        for (RegionMob m : this.MOBS) {
            if (!m.getMob().equalsIgnoreCase(mob)) continue;
            m.setDrop(value);
            return;
        }
        rm = new RegionMob(mob);
        rm.setDrop(value);
        this.MOBS.add(rm);
    }

    public void setInteracts(ArrayList<RegionInteract> interact) {
        this.INTERACTS = interact;
    }

    public ArrayList<RegionInteract> getInteracts() {
        return this.INTERACTS;
    }

    public ArrayList<RegionVehicle> getVehicles() {
        return this.VEHICLES;
    }

    public void setVehicles(ArrayList<RegionVehicle> vehicles) {
        this.VEHICLES = vehicles;
    }

    public ArrayList<RegionExplosion> getExplosions() {
        return this.EXPLOSIONS;
    }

    public void setExplosions(ArrayList<RegionExplosion> explosion) {
        this.EXPLOSIONS = explosion;
    }

    public ArrayList<RegionMob> getMobs() {
        return this.MOBS;
    }

    public void setMobs(ArrayList<RegionMob> mobs) {
        this.MOBS = mobs;
    }

    public void setVersion(float version) {
        this.VERSION = version;
    }

    public void setExcludedBlocks(RegionExcludedBlocks blocks) {
        this.EXCLUDED_BLOCKS = blocks;
    }

    public RegionExcludedBlocks getExcludedBlocks() {
        return this.EXCLUDED_BLOCKS;
    }

    public void excludeBlock(BlockType block, EnumRegionBlock type) {
        switch (type) {
            case PLACE: {
                this.EXCLUDED_BLOCKS.addPlace(block);
                break;
            }
            case DESTROY: {
                this.EXCLUDED_BLOCKS.addDestroy(block);
                break;
            }
            case BOTH: {
                this.EXCLUDED_BLOCKS.addPlace(block);
                this.EXCLUDED_BLOCKS.addDestroy(block);
            }
        }
    }

    public void includeBlock(BlockType block, EnumRegionBlock type) {
        switch (type) {
            case PLACE: {
                this.EXCLUDED_BLOCKS.removePlace(block);
                break;
            }
            case DESTROY: {
                this.EXCLUDED_BLOCKS.removeDestroy(block);
                break;
            }
            case BOTH: {
                this.EXCLUDED_BLOCKS.removePlace(block);
                this.EXCLUDED_BLOCKS.removeDestroy(block);
            }
        }
    }

    public void setDisallowedItems(ArrayList<String> items) {
        this.DISALLOWED_ITEMS = items;
    }

    public ArrayList<String> getDisallowedItems() {
        return this.DISALLOWED_ITEMS;
    }

    public void disallowItem(ItemType item) {
        if (!this.DISALLOWED_ITEMS.contains(item.getId())) {
            this.DISALLOWED_ITEMS.add(item.getId());
        }
    }

    public void allowItem(ItemType item) {
        if (this.DISALLOWED_ITEMS.contains(item.getId())) {
            this.DISALLOWED_ITEMS.remove(item.getId());
        }
    }

    public void setTemplate(boolean template) {
        this.TEMPLATE = template;
    }

    public boolean getTemplate() {
        return this.TEMPLATE;
    }

    public float getVersion() {
        return this.VERSION;
    }

    public boolean isGlobal() {
        return this.TYPE == RegionType.GLOBAL;
    }

    public boolean isLocal() {
        return this.TYPE == RegionType.LOCAL;
    }
}

