/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.tickcentral.asm;

import com.github.terminatornl.tickcentral.TickCentral;
import com.github.terminatornl.tickcentral.api.ClassDebugger;
import com.github.terminatornl.tickcentral.api.ClassSniffer;
import com.github.terminatornl.tickcentral.asm.Utilities;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityTransformer
implements IClassTransformer {
    public static final String ENTITY_CLASS_NON_OBF = "net.minecraft.entity.Entity";
    public static final String ENTITY_CLASS_OBF = FMLDeobfuscatingRemapper.INSTANCE.unmap("net.minecraft.entity.Entity".replace(".", "/"));
    public static final String TRUE_ONUPDATE_TICK_NAME = "TickCentral_TrueOnUpdateTick";
    public static Map.Entry<String, String> ONUPDATE_TICK_METHOD = null;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            if (basicClass == null) {
                return null;
            }
            ClassReader reader = new ClassReader(basicClass);
            if (!ClassSniffer.isInstanceOf(reader, ENTITY_CLASS_OBF)) {
                return basicClass;
            }
            boolean dirty = false;
            if (ONUPDATE_TICK_METHOD == null) {
                ClassNode classNode = ClassSniffer.performOnSource(ENTITY_CLASS_OBF, k -> {
                    ClassNode node = new ClassNode();
                    k.accept((ClassVisitor)node, 0);
                    return node;
                });
                String targetTargetMethod = null;
                for (MethodNode node : classNode.methods) {
                    if (!node.desc.equals("()V") || !Utilities.usesConstant(node.instructions, "entityBaseTick")) continue;
                    TickCentral.LOGGER.info("Found onEntityUpdate as " + FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(classNode.name, node.name, node.desc) + FMLDeobfuscatingRemapper.INSTANCE.mapDesc(node.desc));
                    targetTargetMethod = node.name;
                    break;
                }
                if (targetTargetMethod == null) {
                    TickCentral.LOGGER.fatal("Unable to find the entity onEntityUpdate method! (Stage 1)");
                    FMLCommonHandler.instance().exitJava(1, false);
                    throw new RuntimeException();
                }
                for (MethodNode node : classNode.methods) {
                    if (!Utilities.usesMethodInstruction(182, classNode.name, targetTargetMethod, "()V", node.instructions)) continue;
                    ONUPDATE_TICK_METHOD = new AbstractMap.SimpleEntry<String, String>(FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(classNode.name, node.name, node.desc), FMLDeobfuscatingRemapper.INSTANCE.mapDesc(node.desc));
                    TickCentral.LOGGER.info("Found onUpdate as " + ONUPDATE_TICK_METHOD.getKey() + ONUPDATE_TICK_METHOD.getValue());
                }
                if (ONUPDATE_TICK_METHOD == null) {
                    TickCentral.LOGGER.fatal("Unable to find the entity onUpdate method! (Stage 2)");
                    FMLCommonHandler.instance().exitJava(1, false);
                    throw new RuntimeException();
                }
            }
            String className = reader.getClassName();
            if (TickCentral.CONFIG.DEBUG) {
                TickCentral.LOGGER.info("Entity found: " + className + " (" + transformedName + ")");
            }
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 0);
            MethodNode newUpdateTick = null;
            for (MethodNode method : classNode.methods) {
                if ((method.access & 0x400) != 0 || !ONUPDATE_TICK_METHOD.getKey().equals(method.name) || !ONUPDATE_TICK_METHOD.getValue().equals(method.desc)) continue;
                newUpdateTick = Utilities.CopyMethodAppearance(method);
                newUpdateTick.instructions = new InsnList();
                newUpdateTick.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "com/github/terminatornl/tickcentral/api/TickHub", "INTERCEPTOR", "Lcom/github/terminatornl/tickcentral/api/TickInterceptor;"));
                newUpdateTick.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newUpdateTick.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "com/github/terminatornl/tickcentral/api/TickInterceptor", "redirectOnUpdate", "(Lnet/minecraft/entity/Entity;)V", true));
                newUpdateTick.instructions.add((AbstractInsnNode)new InsnNode(177));
                method.name = TRUE_ONUPDATE_TICK_NAME;
                dirty = true;
            }
            if (newUpdateTick != null) {
                classNode.methods.add(newUpdateTick);
            }
            for (MethodNode method : classNode.methods) {
                dirty = Utilities.convertTargetInstruction(className, ONUPDATE_TICK_METHOD.getKey(), ONUPDATE_TICK_METHOD.getValue(), className, TRUE_ONUPDATE_TICK_NAME, method.instructions) || dirty;
                dirty = Utilities.convertSuperInstructions(ONUPDATE_TICK_METHOD.getKey(), ONUPDATE_TICK_METHOD.getValue(), TRUE_ONUPDATE_TICK_NAME, method.instructions) || dirty;
            }
            if (dirty) {
                return ClassDebugger.WriteClass(classNode, transformedName);
            }
            return basicClass;
        }
        catch (Throwable e) {
            TickCentral.LOGGER.fatal("An error has occurred", e);
            FMLCommonHandler.instance().exitJava(1, false);
            throw new RuntimeException(e);
        }
    }
}

