/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.itemname;

import io.github.nucleuspowered.nucleus.modules.item.commands.itemname.ItemNameCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"clear", "#clearitemname", "#resetitemname"}, basePermission={"nucleus.itemname.clear.base"}, commandDescriptionKey="itemname.clear", parentCommand=ItemNameCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.itemname.clear.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.itemname.clear.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.itemname.clear.exempt.cost")})
public class ItemNameClearCommand
implements ICommandExecutor<Player> {
    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player src = context.getIfPlayer();
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return context.errorResult("command.itemname.clear.noitem", new Object[0]);
        }
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        Optional data = stack.get(Keys.DISPLAY_NAME);
        if (!data.isPresent()) {
            return context.errorResult("command.lore.clear.none", new Object[0]);
        }
        if (stack.remove(Keys.DISPLAY_NAME).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            context.sendMessage("command.itemname.clear.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.itemname.clear.fail", new Object[0]);
    }
}

