/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.data.property.block.PassableProperty;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"jump", "j", "jumpto"})
@NonnullByDefault
@Command(aliases={"jump", "j", "jmp"}, basePermission={"nucleus.jump.base"}, commandDescriptionKey="jump", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.jump.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.jump.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.jump.exempt.cost")})
public class JumpCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private int maxJump = 20;

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player player = context.getIfPlayer();
        BlockRay playerBlockRay = BlockRay.from((Entity)player).distanceLimit((double)this.maxJump).build();
        BlockRayHit finalHitRay = null;
        while (finalHitRay == null && playerBlockRay.hasNext()) {
            BlockRayHit currentHitRay = playerBlockRay.next();
            if (player.getWorld().getBlockType(currentHitRay.getBlockPosition()).equals(BlockTypes.AIR)) continue;
            finalHitRay = currentHitRay;
        }
        if (finalHitRay == null) {
            return context.errorResult("command.jump.noblock", new Object[0]);
        }
        Location finalLocation = finalHitRay.getLocation();
        Optional pp = finalHitRay.getLocation().getProperty(PassableProperty.class);
        if (pp.isPresent() && !this.getFromBoxed((Boolean)((PassableProperty)pp.get()).getValue())) {
            finalLocation = finalLocation.add(0.0, 1.0, 0.0);
        } else {
            Optional ppbelow = finalHitRay.getLocation().getRelative(Direction.DOWN).getProperty(PassableProperty.class);
            if (ppbelow.isPresent() && !this.getFromBoxed((Boolean)((PassableProperty)ppbelow.get()).getValue())) {
                finalLocation = finalLocation.sub(0.0, 1.0, 0.0);
            }
        }
        if (!Util.isLocationInWorldBorder((Location<World>)finalLocation)) {
            return context.errorResult("command.jump.outsideborder", new Object[0]);
        }
        boolean result = context.getServiceCollection().teleportService().teleportPlayerSmart(player, (Location<World>)finalLocation, false, true, TeleportScanners.NO_SCAN.get()).isSuccessful();
        if (result) {
            context.sendMessage("command.jump.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.jump.notsafe", new Object[0]);
    }

    private boolean getFromBoxed(@Nullable Boolean bool) {
        return bool != null ? bool : false;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.maxJump = serviceCollection.moduleDataProvider().getModuleConfig(JumpConfig.class).getMaxJump();
    }
}

