/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mob.commands;

import io.github.nucleuspowered.nucleus.modules.mob.MobPermissions;
import io.github.nucleuspowered.nucleus.modules.mob.config.BlockSpawnsConfig;
import io.github.nucleuspowered.nucleus.modules.mob.config.MobConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.ImprovedCatalogTypeArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.CatalogTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"spawnmob", "mob"})
@NonnullByDefault
@Command(aliases={"spawnmob", "spawnentity", "mobspawn"}, basePermission={"nucleus.spawnmob.base"}, commandDescriptionKey="spawnmob", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.spawnmob.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.spawnmob.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.spawnmob.exempt.cost")}, associatedPermissions={"nucleus.spawnmob.others", "nucleus.spawnmob.mob"})
public class SpawnMobCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final String amountKey = "amount";
    private final String mobTypeKey = "mob";
    private MobConfig mobConfig = new MobConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.spawnmob.others"), new ImprovedCatalogTypeArgument((Text)Text.of((String)this.mobTypeKey), CatalogTypes.ENTITY_TYPE, serviceCollection), GenericArguments.optional((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.amountKey), serviceCollection), (Object)1)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        int amount = context.requireOne(this.amountKey, Integer.class);
        EntityType et = context.requireOne(this.mobTypeKey, EntityType.class);
        if (!Living.class.isAssignableFrom(et.getEntityClass())) {
            return context.errorResult("command.spawnmob.livingonly", et.getTranslation().get());
        }
        String id = et.getId().toLowerCase();
        if (this.mobConfig.isPerMobPermission() && !context.isConsoleAndBypass() && !context.testPermission(MobPermissions.getSpawnMobPermissionFor(et))) {
            return context.errorResult("command.spawnmob.mobnoperm", et.getTranslation().get());
        }
        Optional<BlockSpawnsConfig> config = this.mobConfig.getBlockSpawnsConfigForWorld(pl.getWorld());
        if (config.isPresent() && (config.get().isBlockVanillaMobs() && id.startsWith("minecraft:") || config.get().getIdsToBlock().contains(id))) {
            return context.errorResult("command.spawnmob.blockedinconfig", et.getTranslation().get());
        }
        Location loc = pl.getLocation();
        World w = (World)loc.getExtent();
        int i = 0;
        Entity entityone = null;
        do {
            Entity e;
            if (!w.spawnEntity(e = w.createEntity(et, loc.getPosition()))) {
                return context.errorResult("command.spawnmob.fail", Text.of((Translatable)e, (Object[])new Object[0]));
            }
            if (entityone != null) continue;
            entityone = e;
        } while (++i < Math.min(amount, this.mobConfig.getMaxMobsToSpawn()));
        if (amount > this.mobConfig.getMaxMobsToSpawn()) {
            context.sendMessage("command.spawnmob.limit", String.valueOf(this.mobConfig.getMaxMobsToSpawn()));
        }
        if (i == 0) {
            return context.errorResult("command.spawnmob.fail", et.getTranslation().get());
        }
        if (i == 1) {
            context.sendMessage("command.spawnmob.success.singular", Text.of((Object[])new Object[]{i}), Text.of((Translatable)entityone, (Object[])new Object[0]));
        } else {
            context.sendMessage("command.spawnmob.success.plural", Text.of((Object[])new Object[]{i}), Text.of((Translatable)entityone, (Object[])new Object[0]));
        }
        return context.successResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.mobConfig = serviceCollection.moduleDataProvider().getModuleConfig(MobConfig.class);
    }
}

