/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands.category;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.warp.data.WarpCategory;
import io.github.nucleuspowered.nucleus.modules.warp.commands.category.CategoryCommand;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

@Command(aliases={"list"}, basePermission={"nucleus.warp.category.list.base"}, commandDescriptionKey="warp.category.list", parentCommand=CategoryCommand.class)
public class ListCategoryCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        CommandSource src = context.getCommandSource();
        WarpService handler = context.getServiceCollection().getServiceUnchecked(WarpService.class);
        Util.getPaginationBuilder(src).contents((Iterable)handler.getWarpsWithCategories().keySet().stream().filter(Objects::nonNull).sorted(Comparator.comparing(WarpCategory::getId)).map(x -> {
            ArrayList t = Lists.newArrayList();
            t.add(context.getMessage("command.warp.category.listitem.simple", Text.of((String)x.getId()), x.getDisplayName()));
            x.getDescription().ifPresent(y -> t.add(context.getMessage("command.warp.category.listitem.description", y)));
            return t;
        }).flatMap(Collection::stream).collect(Collectors.toList())).title(context.getMessage("command.warp.category.listitem.title", new Object[0])).padding(Text.of((Object[])new Object[]{"-", TextColors.GREEN})).sendTo((MessageReceiver)src);
        return context.successResult();
    }
}

