/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.nucleuspowered.nucleus.services.impl.compatibility.Message;
import io.github.nucleuspowered.nucleus.services.interfaces.ICompatibilityService;
import io.github.nucleuspowered.nucleus.services.interfaces.IModuleDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.util.Tristate;

@Singleton
public class CompatibilityService
implements ICompatibilityService {
    private final IModuleDataProvider moduleDataProvider;
    private final List<ICompatibilityService.CompatibilityMessages> messages = new ArrayList<ICompatibilityService.CompatibilityMessages>();
    private List<ICompatibilityService.CompatibilityMessages> applicableMessages = null;

    @Inject
    public CompatibilityService(IModuleDataProvider moduleDataProvider) {
        this.moduleDataProvider = moduleDataProvider;
    }

    @Override
    public Collection<ICompatibilityService.CompatibilityMessages> getMessages() {
        return ImmutableList.copyOf(this.messages);
    }

    @Override
    public Collection<ICompatibilityService.CompatibilityMessages> getApplicableMessages() {
        if (this.messages.isEmpty()) {
            return ImmutableList.of();
        }
        if (this.applicableMessages == null) {
            this.applicableMessages = this.applyMessages();
        }
        return this.applicableMessages;
    }

    @Override
    public void set(JsonArray jsonArray) {
        if (this.messages.isEmpty()) {
            for (JsonElement el : jsonArray) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    ArrayList<String> l = null;
                    if (obj.has("modules")) {
                        l = new ArrayList<String>();
                        for (JsonElement element : obj.getAsJsonArray("modules")) {
                            l.add(el.getAsString());
                        }
                    }
                    this.messages.add(new Message(obj.get("modid").getAsString(), this.get(obj.get("severity").getAsInt()), obj.get("symptom").getAsString(), obj.get("message").getAsString(), obj.get("resolution").getAsString(), l));
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<ICompatibilityService.CompatibilityMessages> applyMessages() {
        Collection<String> id = this.moduleDataProvider.getModules(Tristate.TRUE);
        return this.messages.stream().filter(x -> id.contains(x.getModId())).collect(Collectors.toList());
    }

    private ICompatibilityService.Severity get(int i) {
        switch (i) {
            case 3: {
                return ICompatibilityService.Severity.CRITICAL;
            }
            case 2: {
                return ICompatibilityService.Severity.MAJOR;
            }
            case 1: {
                return ICompatibilityService.Severity.MINOR;
            }
        }
        return ICompatibilityService.Severity.INFORMATIONAL;
    }
}

