/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.docgen;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.modules.core.docgen.CommandDoc;
import io.github.nucleuspowered.nucleus.modules.core.docgen.EssentialsDoc;
import io.github.nucleuspowered.nucleus.modules.core.docgen.PermissionDoc;
import io.github.nucleuspowered.nucleus.modules.core.docgen.TokenDoc;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandMetadata;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.placeholder.PlaceholderMetadata;
import io.github.nucleuspowered.nucleus.services.interfaces.ICommandMetadataService;
import io.github.nucleuspowered.nucleus.services.interfaces.IDocumentationGenerationService;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.data.SuggestedLevel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.yaml.snakeyaml.DumperOptions;

@Singleton
public class DocumentationGenerationService
implements IDocumentationGenerationService {
    private static final TypeToken<List<CommandDoc>> COMMAND_DOC_LIST_TYPE_TOKEN = new TypeToken<List<CommandDoc>>(){};
    private static final TypeToken<List<PermissionDoc>> PERMISSION_DOC_LIST_TYPE_TOKEN = new TypeToken<List<PermissionDoc>>(){};
    private static final TypeToken<List<TokenDoc>> TOKEN_DOC_LIST_TYPE_TOKEN = new TypeToken<List<TokenDoc>>(){};
    private static final TypeToken<List<EssentialsDoc>> ESSENTIALS_DOC_LIST_TYPE_TOKEN = new TypeToken<List<EssentialsDoc>>(){};
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public DocumentationGenerationService(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    @Override
    public void generate(Path directory) throws IOException, ObjectMappingException {
        ICommandMetadataService commandMetadataService = this.serviceCollection.commandMetadataService();
        IPermissionService permissionService = this.serviceCollection.permissionService();
        IMessageProviderService messageProviderService = this.serviceCollection.messageProvider();
        Collection<CommandControl> commands = commandMetadataService.getCommandsAndSubcommands();
        HashSet allPermissionDocs = new HashSet();
        ArrayList essentialsDocs = new ArrayList();
        List<CommandDoc> lcd = this.getAndSort(commands, (first, second) -> {
            int m = first.getMetadata().getModuleid().compareToIgnoreCase(second.getMetadata().getModuleid());
            if (m == 0) {
                return first.getCommandKey().compareToIgnoreCase(second.getCommandKey());
            }
            return m;
        }, control -> {
            CommandMetadata metadata = control.getMetadata();
            CommandDoc commandDoc = new CommandDoc();
            String cmdPath = metadata.getCommandKey().replaceAll("\\.", " ");
            commandDoc.setCommandName(cmdPath);
            commandDoc.setModule(metadata.getModuleid());
            if (metadata.isRoot()) {
                commandDoc.setAliases(String.join((CharSequence)", ", metadata.getAliases()));
            } else {
                String key = metadata.getCommandKey().replaceAll("\\.[a-z]+$", " ").replaceAll("\\.", " ");
                commandDoc.setAliases(key + Arrays.stream(metadata.getAliases()).filter(x -> !x.startsWith("#")).map(x -> x.replace("^$", "")).collect(Collectors.joining(", " + key)));
                if (!metadata.getRootAliases().isEmpty()) {
                    commandDoc.setRootAliases(String.join((CharSequence)", ", metadata.getRootAliases()));
                }
            }
            HashSet<PermissionDoc> permissionDocs = new HashSet<PermissionDoc>();
            Command annotation = metadata.getCommandAnnotation();
            for (CommandModifier modifier : annotation.modifiers()) {
                switch (modifier.value()) {
                    case "nucleus:has_cooldown": {
                        commandDoc.setCooldown(true);
                        break;
                    }
                    case "nucleus:has_cost": {
                        commandDoc.setCost(true);
                        break;
                    }
                    case "nucleus:has_warmup": {
                        commandDoc.setWarmup(true);
                    }
                }
                this.getPermissionDoc(modifier.exemptPermission()).ifPresent(permissionDocs::add);
            }
            for (String perm : metadata.getCommandAnnotation().associatedPermissions()) {
                this.getPermissionDoc(perm).ifPresent(permissionDocs::add);
            }
            EssentialsEquivalent essentialsEquivalent = metadata.getEssentialsEquivalent();
            if (essentialsEquivalent != null) {
                List<String> eqiv = Arrays.asList(essentialsEquivalent.value());
                commandDoc.setEssentialsEquivalents(eqiv);
                commandDoc.setEssNotes(essentialsEquivalent.notes());
                commandDoc.setExactEssEquiv(essentialsEquivalent.isExact());
                essentialsDocs.add(new EssentialsDoc().setExact(essentialsEquivalent.isExact()).setNotes(essentialsEquivalent.notes()).setEssentialsCommands(eqiv).setNucleusEquiv(metadata.getRootAliases()));
            }
            String[] base = metadata.getCommandAnnotation().basePermission();
            SuggestedLevel level = SuggestedLevel.USER;
            if (base.length > 0) {
                commandDoc.setPermissionbase(base[0]);
                for (String permission : base) {
                    Optional<IPermissionService.Metadata> pm = this.serviceCollection.permissionService().getMetadataFor(permission);
                    if (!pm.isPresent()) continue;
                    if (pm.get().getSuggestedLevel().compareTo(level) > 0) {
                        level = pm.get().getSuggestedLevel();
                    }
                    permissionDocs.add(this.getFor(pm.get()));
                }
            }
            commandDoc.setDefaultLevel(level.name());
            commandDoc.setOneLineDescription(control.getShortDescription((CommandSource)Sponge.getServer().getConsole()).map(Text::toPlain).orElse("No description provided"));
            commandDoc.setExtendedDescription(control.getExtendedDescription((CommandSource)Sponge.getServer().getConsole()).map(Text::toPlain).orElse(null));
            commandDoc.setUsageString(control.getUsage((CommandSource)Sponge.getServer().getConsole()).toPlain());
            commandDoc.setPermissions(new ArrayList<PermissionDoc>(permissionDocs));
            commandDoc.setSimpleUsage(control.getUsageText((CommandSource)Sponge.getServer().getConsole()).toPlain());
            commandDoc.setContext(control.getContext().getValue());
            allPermissionDocs.addAll(permissionDocs);
            return commandDoc;
        });
        Set permissions = allPermissionDocs.stream().map(PermissionDoc::getPermission).collect(Collectors.toSet());
        permissionService.getAllMetadata().stream().filter(x -> !permissions.contains(x.getPermission())).map(this::getFor).filter(x -> x.getPermission() != null).forEach(allPermissionDocs::add);
        List permdocs = allPermissionDocs.stream().sorted(Comparator.comparing(PermissionDoc::getPermission)).collect(Collectors.toList());
        List tokenDocs = this.serviceCollection.placeholderService().getNucleusParsers().values().stream().filter(PlaceholderMetadata::isDocument).filter(x -> {
            if (!messageProviderService.hasKey("nucleus.token." + x.getToken().toLowerCase())) {
                this.serviceCollection.logger().warn("Could not find message key for nucleus.token.{}", (Object)x.getToken().toLowerCase());
                return false;
            }
            return true;
        }).map(x -> new TokenDoc().setId(x.getParser().getId()).setName(x.getToken()).setDescription(messageProviderService.getMessageString("nucleus.token." + x.getToken().toLowerCase(), new Object[0]))).collect(Collectors.toList());
        Map<String, Class<?>> configs = this.serviceCollection.moduleDataProvider().getModuleToConfigType();
        SimpleConfigurationNode configNode = SimpleConfigurationNode.root();
        for (Map.Entry<String, Class<?>> entry : configs.entrySet()) {
            try {
                configNode.getNode(new Object[]{entry.getKey()}).setValue((Object)this.createConfigString(entry.getValue().newInstance()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        YAMLConfigurationLoader configurationLoader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(directory.resolve("commands.yml"))).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        ConfigurationNode commandConfigurationNode = ConfigurationNode.root().setValue(COMMAND_DOC_LIST_TYPE_TOKEN, lcd);
        configurationLoader.save(commandConfigurationNode);
        YAMLConfigurationLoader permissionsConfigurationLoader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(directory.resolve("permissions.yml"))).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        ConfigurationNode permissionConfiguationNode = ConfigurationNode.root().setValue(PERMISSION_DOC_LIST_TYPE_TOKEN, permdocs);
        permissionsConfigurationLoader.save(permissionConfiguationNode);
        YAMLConfigurationLoader essentialsConfigurationLoader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(directory.resolve("essentials.yml"))).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        ConfigurationNode essentialsConfigurationNode = ConfigurationNode.root().setValue(ESSENTIALS_DOC_LIST_TYPE_TOKEN, essentialsDocs);
        essentialsConfigurationLoader.save(essentialsConfigurationNode);
        YAMLConfigurationLoader configurationConfigurationLoader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(directory.resolve("conf.yml"))).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        configurationConfigurationLoader.save((ConfigurationNode)configNode);
        YAMLConfigurationLoader tokensConfigurationLoader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(directory.resolve("tokens.yml"))).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        ConfigurationNode tokensConfigNode = ConfigurationNode.root().setValue(TOKEN_DOC_LIST_TYPE_TOKEN, tokenDocs);
        tokensConfigurationLoader.save(tokensConfigNode);
    }

    private <T, R> List<R> getAndSort(Collection<T> list, Comparator<T> comparator, Function<T, R> mapper) {
        return list.stream().sorted(comparator).map(mapper).collect(Collectors.toList());
    }

    private Optional<PermissionDoc> getPermissionDoc(String permission) {
        return this.serviceCollection.permissionService().getMetadataFor(permission).map(this::getFor);
    }

    private PermissionDoc getFor(IPermissionService.Metadata metadata) {
        return new PermissionDoc().setDefaultLevel(metadata.getSuggestedLevel().name()).setDescription(metadata.getDescription(this.serviceCollection.messageProvider())).setPermission(metadata.getPermission()).setModule(metadata.getModuleId());
    }

    /*
     * Exception decompiling
     */
    private String createConfigString(Object obj) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> void applyToNode(Class<T> c, Object object, ConfigurationNode node) {
        try {
            node.setValue(TypeToken.of(c), c.cast(object));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ BufferedWriter lambda$createConfigString$8(BufferedWriter writer) throws Exception {
        return writer;
    }
}

