/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.interfaces;

import com.google.inject.ImplementedBy;
import io.github.nucleuspowered.nucleus.services.impl.textstyle.TextStyleService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

@ImplementedBy(value=TextStyleService.class)
public interface ITextStyleService {
    public static final TextFormat EMPTY = new TextFormat(){

        @Override
        public TextColor colour() {
            return TextColors.NONE;
        }

        @Override
        public TextStyle style() {
            return TextStyles.NONE;
        }

        @Override
        public Text textOf() {
            return Text.of();
        }
    };

    public Optional<String> getPermissionFor(String var1, TextColor var2);

    public List<String> getPermissionsFor(String var1, TextStyle var2);

    public String stripPermissionless(String var1, String var2, Subject var3, String var4);

    public String stripPermissionless(String var1, String var2, String var3, Subject var4, String var5);

    public Collection<String> wouldStrip(Collection<String> var1, String var2, Subject var3, String var4);

    default public TextFormat getLastColourAndStyle(TextRepresentable text, @Nullable TextFormat current) {
        return this.getLastColourAndStyle(text, current, TextColors.NONE, TextStyles.NONE);
    }

    public TextFormat getLastColourAndStyle(TextRepresentable var1, @Nullable TextFormat var2, TextColor var3, TextStyle var4);

    public TextColor getColourFromString(@Nullable String var1);

    public TextStyle getTextStyleFromString(@Nullable String var1);

    public Text addUrls(String var1);

    public Text addUrls(String var1, boolean var2);

    public Text getTextForUrl(String var1, String var2, String var3, TextFormat var4, @Nullable String var5);

    public Text oldLegacy(String var1);

    public Text joinTextsWithColoursFlowing(Text ... var1);

    public static interface TextFormat {
        public TextColor colour();

        public TextStyle style();

        public Text textOf();
    }
}

