/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public abstract class PatternMatchingCommandElement
extends CommandElement {
    private static final Text nullKeyArg = SpongeApiTranslationHelper.t("argument", new Object[0]);
    final boolean useRegex;

    protected PatternMatchingCommandElement(@Nullable Text key, boolean yesIWantRegex) {
        super(key);
        this.useRegex = yesIWantRegex;
    }

    protected PatternMatchingCommandElement(@Nullable Text key) {
        this(key, false);
    }

    @Override
    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        Iterable ret;
        String arg;
        Iterable<String> choices = this.getChoices(source);
        Optional<Object> exactMatch = this.getExactMatch(choices, arg = args.next());
        if (exactMatch.isPresent()) {
            return Collections.singleton(exactMatch.get());
        }
        if (this.useRegex) {
            Pattern pattern = this.getFormattedPattern(arg);
            ret = Iterables.transform((Iterable)Iterables.filter(choices, element -> pattern.matcher((CharSequence)element).find()), this::getValue);
        } else {
            Iterable startsWith = Iterables.filter(choices, element -> element.regionMatches(true, 0, arg, 0, arg.length()));
            ret = Iterables.transform((Iterable)startsWith, this::getValue);
        }
        if (!ret.iterator().hasNext()) {
            throw args.createError(SpongeApiTranslationHelper.t("No values matching pattern '%s' present for %s!", arg, this.getKey() == null ? nullKeyArg : this.getKey()));
        }
        return ret;
    }

    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Iterable choices = this.getChoices(src);
        Optional<String> nextArg = args.nextIfPresent();
        if (nextArg.isPresent()) {
            if (this.useRegex) {
                choices = Iterables.filter(choices, input -> this.getFormattedPattern((String)nextArg.get()).matcher((CharSequence)input).find());
            } else {
                String arg = nextArg.get();
                choices = Iterables.filter((Iterable)choices, input -> input.regionMatches(true, 0, arg, 0, arg.length()));
            }
        }
        return ImmutableList.copyOf(choices);
    }

    Pattern getFormattedPattern(String input) {
        if (!input.startsWith("^")) {
            input = "^" + input;
        }
        return Pattern.compile(input, 2);
    }

    protected Optional<Object> getExactMatch(Iterable<String> choices, String potentialChoice) {
        return Iterables.tryFind(choices, potentialChoice::equalsIgnoreCase).toJavaUtil().map(this::getValue);
    }

    protected abstract Iterable<String> getChoices(CommandSource var1);

    protected abstract Object getValue(String var1) throws IllegalArgumentException;
}

