/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.context;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;

public interface ContextCalculator<T extends Contextual> {
    public static <T extends Contextual> ContextCalculator<T> forSingleContext(final String key, final Function<T, String> valueFunction) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valueFunction, "valueFunction");
        return new ContextCalculator<T>(){

            @Override
            public void accumulateContexts(T target, Set<Context> accumulator) {
                String value = (String)valueFunction.apply(target);
                if (value != null) {
                    accumulator.add(new Context(key, value));
                }
            }

            @Override
            public boolean matches(Context context, T target) {
                if (!context.getKey().equals(key)) {
                    return false;
                }
                return context.getValue().equals(valueFunction.apply(target));
            }
        };
    }

    public void accumulateContexts(T var1, Set<Context> var2);

    default public boolean matches(Context context, T target) {
        HashSet<Context> set = new HashSet<Context>();
        this.accumulateContexts(target, set);
        return set.contains(context);
    }
}

