/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.selector;

import java.util.Set;
import org.spongepowered.api.text.selector.ArgumentHolder;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.ArgumentTypes;

public interface Argument<T> {
    public static <T> Argument<T> create(ArgumentType<T> type, T value) {
        return ArgumentTypes.getFactory().createArgument(type, value);
    }

    public static <T> Invertible<T> create(ArgumentType.Invertible<T> type, T value, boolean inverted) {
        return ArgumentTypes.getFactory().createArgument(type, value, inverted);
    }

    public static <T, V> Set<Argument<T>> createSet(ArgumentHolder<? extends ArgumentType<T>> type, V value) {
        return ArgumentTypes.getFactory().createArguments(type, value);
    }

    public static Argument<?> parse(String argument) throws IllegalArgumentException {
        return ArgumentTypes.getFactory().parseArgument(argument);
    }

    public ArgumentType<T> getType();

    public T getValue();

    public String toPlain();

    public static interface Invertible<T>
    extends Argument<T> {
        public boolean isInverted();

        public Invertible<T> invert();
    }
}

