/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFoodData;
import org.spongepowered.api.data.manipulator.mutable.entity.FoodData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFoodData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.mixin.core.util.FoodStatsAccessor;

public class FoodDataProcessor
extends AbstractEntityDataProcessor<EntityPlayer, FoodData, ImmutableFoodData> {
    public FoodDataProcessor() {
        super(EntityPlayer.class);
    }

    @Override
    protected FoodData createManipulator() {
        return new SpongeFoodData(20, 0.0, 0.0);
    }

    @Override
    protected boolean doesDataExist(EntityPlayer entity) {
        return true;
    }

    @Override
    protected boolean set(EntityPlayer entity, Map<Key<?>, Object> keyValues) {
        entity.func_71024_bL().func_75114_a(((Integer)keyValues.get(Keys.FOOD_LEVEL)).intValue());
        ((FoodStatsAccessor)entity.func_71024_bL()).accessor$setFoodSaturationLevel(((Double)keyValues.get(Keys.SATURATION)).floatValue());
        ((FoodStatsAccessor)entity.func_71024_bL()).accessor$setFoodExhaustionLevel(((Double)keyValues.get(Keys.EXHAUSTION)).floatValue());
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityPlayer entity) {
        int food = entity.func_71024_bL().func_75116_a();
        double saturation = entity.func_71024_bL().func_75115_e();
        double exhaustion = ((FoodStatsAccessor)entity.func_71024_bL()).accessor$getFoodExhaustionLevel();
        return ImmutableMap.of(Keys.FOOD_LEVEL, (Object)food, Keys.SATURATION, (Object)saturation, Keys.EXHAUSTION, (Object)exhaustion);
    }

    @Override
    public Optional<FoodData> fill(DataContainer container, FoodData foodData) {
        foodData.set(Keys.FOOD_LEVEL, DataUtil.getData(container, Keys.FOOD_LEVEL));
        foodData.set(Keys.SATURATION, DataUtil.getData(container, Keys.SATURATION));
        foodData.set(Keys.EXHAUSTION, DataUtil.getData(container, Keys.EXHAUSTION));
        return Optional.of(foodData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

