/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl.fabric;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.bridge.item.inventory.InventoryBridge;
import org.spongepowered.common.item.inventory.lens.Fabric;

public class CompoundFabric
implements Fabric {
    private final Fabric fabric1;
    private final Fabric fabric2;
    private Translation displayName;

    public CompoundFabric(Fabric fabric1, Fabric fabric2) {
        this.fabric1 = fabric1;
        this.fabric2 = fabric2;
        this.displayName = fabric1.fabric$getDisplayName();
    }

    @Override
    public Collection<InventoryBridge> fabric$allInventories() {
        HashSet<InventoryBridge> inv = new HashSet<InventoryBridge>();
        inv.addAll(this.fabric1.fabric$allInventories());
        inv.addAll(this.fabric2.fabric$allInventories());
        return inv;
    }

    @Override
    public InventoryBridge fabric$get(int index) {
        if (index < this.fabric1.fabric$getSize()) {
            return this.fabric1.fabric$get(index);
        }
        return this.fabric2.fabric$get(index - this.fabric1.fabric$getSize());
    }

    @Override
    public ItemStack fabric$getStack(int index) {
        if (index < this.fabric1.fabric$getSize()) {
            return this.fabric1.fabric$getStack(index);
        }
        return this.fabric2.fabric$getStack(index - this.fabric1.fabric$getSize());
    }

    @Override
    public void fabric$setStack(int index, ItemStack stack) {
        if (index < this.fabric1.fabric$getSize()) {
            this.fabric1.fabric$setStack(index, stack);
        } else {
            this.fabric2.fabric$setStack(index - this.fabric1.fabric$getSize(), stack);
        }
    }

    @Override
    public int fabric$getMaxStackSize() {
        return Math.max(this.fabric1.fabric$getMaxStackSize(), this.fabric2.fabric$getMaxStackSize());
    }

    @Override
    public Translation fabric$getDisplayName() {
        return this.displayName;
    }

    @Override
    public int fabric$getSize() {
        return this.fabric1.fabric$getSize() + this.fabric2.fabric$getSize();
    }

    @Override
    public void fabric$clear() {
        this.fabric1.fabric$clear();
        this.fabric2.fabric$clear();
    }

    @Override
    public void fabric$markDirty() {
        this.fabric1.fabric$markDirty();
        this.fabric2.fabric$markDirty();
    }
}

