/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.query;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.common.item.inventory.EmptyInventoryImpl;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensSet;
import org.spongepowered.common.item.inventory.lens.impl.collections.MutableLensSetImpl;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.inventory.query.SpongeQueryOperation;
import org.spongepowered.common.item.inventory.query.result.MinecraftResultAdapterProvider;
import org.spongepowered.common.item.inventory.query.result.QueryResult;

public class Query {
    private static ResultAdapterProvider defaultResultProvider = new MinecraftResultAdapterProvider();
    private final InventoryAdapter adapter;
    private final Fabric inventory;
    private final Lens lens;
    private final QueryOperation<?>[] queries;

    private Query(InventoryAdapter adapter, QueryOperation<?>[] queries) {
        this.adapter = adapter;
        this.inventory = adapter.bridge$getFabric();
        this.lens = adapter.bridge$getRootLens();
        this.queries = queries;
    }

    public Inventory execute() {
        return this.execute(defaultResultProvider);
    }

    public Inventory execute(ResultAdapterProvider resultProvider) {
        if (this.matches(this.lens, null, this.inventory)) {
            return (Inventory)((Object)this.lens.getAdapter(this.inventory, (Inventory)((Object)this.adapter)));
        }
        return this.toResult(resultProvider, this.reduce(this.lens, this.depthFirstSearch(this.lens)));
    }

    private Inventory toResult(ResultAdapterProvider resultProvider, MutableLensSet matches) {
        if (matches.isEmpty()) {
            return new EmptyInventoryImpl((Inventory)((Object)this.adapter));
        }
        if (matches.size() == 1) {
            return (Inventory)((Object)matches.getLens(0).getAdapter(this.inventory, (Inventory)((Object)this.adapter)));
        }
        if (resultProvider != null) {
            return resultProvider.getResultAdapter(this.inventory, matches, (Inventory)((Object)this.adapter));
        }
        return defaultResultProvider.getResultAdapter(this.inventory, matches, (Inventory)((Object)this.adapter));
    }

    private MutableLensSet depthFirstSearch(Lens lens) {
        MutableLensSetImpl matches = new MutableLensSetImpl(true);
        for (Lens child : lens.getChildren()) {
            if (child == null) continue;
            if (!child.getChildren().isEmpty()) {
                matches.addAll(this.depthFirstSearch(child));
            }
            if (!this.matches(child, lens, this.inventory)) continue;
            matches.add(child);
        }
        if (matches.size() < 2) {
            return matches;
        }
        return matches;
    }

    private boolean matches(Lens lens, Lens parent, Fabric inventory) {
        for (QueryOperation<?> operation : this.queries) {
            if (!((SpongeQueryOperation)operation).matches(lens, parent, inventory)) continue;
            return true;
        }
        return false;
    }

    private MutableLensSet reduce(Lens lens, MutableLensSet matches) {
        if (matches.isEmpty()) {
            return matches;
        }
        if (lens.getSlots().equals(this.getSlots(matches)) && this.allLensesAreSlots(matches)) {
            matches.clear();
            matches.add(lens);
            return matches;
        }
        if (matches.size() == 1) {
            return matches;
        }
        for (Lens child : lens.getChildren()) {
            if (child == null || !child.isSubsetOf(matches)) continue;
            matches.removeAll(child.getChildren());
            matches.add(child);
        }
        return matches;
    }

    private boolean allLensesAreSlots(MutableLensSet lenses) {
        for (Lens lens : lenses) {
            if (lens instanceof SlotLens) continue;
            return false;
        }
        return true;
    }

    private IntSet getSlots(Collection<Lens> lenses) {
        IntOpenHashSet slots = new IntOpenHashSet();
        for (Lens lens : lenses) {
            slots.addAll((IntCollection)lens.getSlots());
        }
        return slots;
    }

    public static Query compile(InventoryAdapter adapter, QueryOperation<?> ... queries) {
        return new Query(adapter, queries);
    }

    public static void setDefaultResultProvider(ResultAdapterProvider defaultResultProvider) {
        Query.defaultResultProvider = defaultResultProvider;
    }

    public static interface ResultAdapterProvider {
        public QueryResult getResultAdapter(Fabric var1, MutableLensSet var2, Inventory var3);
    }
}

