/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.TargetedLocationData;
import org.spongepowered.api.data.manipulator.mutable.entity.CustomNameVisibleData;
import org.spongepowered.api.data.manipulator.mutable.entity.FlyingData;
import org.spongepowered.api.data.manipulator.mutable.entity.GlowingData;
import org.spongepowered.api.data.manipulator.mutable.entity.GravityData;
import org.spongepowered.api.data.manipulator.mutable.entity.GriefingData;
import org.spongepowered.api.data.manipulator.mutable.entity.IgniteableData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvisibilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvulnerabilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.PassengerData;
import org.spongepowered.api.data.manipulator.mutable.entity.SilentData;
import org.spongepowered.api.data.manipulator.mutable.entity.SneakingData;
import org.spongepowered.api.data.manipulator.mutable.entity.SprintData;
import org.spongepowered.api.data.manipulator.mutable.entity.VehicleData;
import org.spongepowered.api.data.manipulator.mutable.entity.VelocityData;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.RelativePositions;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.network.NetHandlerPlayServerBridge;
import org.spongepowered.common.bridge.world.TeleporterBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={net.minecraft.entity.Entity.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$")})
public abstract class EntityMixin_API
implements Entity {
    protected final SpongeEntityType entityType = EntityTypeRegistryModule.getInstance().getForClass(((net.minecraft.entity.Entity)this).getClass());
    @Shadow
    public net.minecraft.world.World field_70170_p;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    @Shadow
    public double field_70159_w;
    @Shadow
    public double field_70181_x;
    @Shadow
    public double field_70179_y;
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public boolean field_70122_E;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    public float field_70130_N;
    @Shadow
    public float field_70131_O;
    @Shadow
    protected Random field_70146_Z;
    @Shadow
    public int field_70173_aa;
    @Shadow
    public int field_190534_ay;
    @Shadow
    protected EntityDataManager field_70180_af;
    @Shadow
    public int field_71093_bK;
    @Shadow
    protected UUID field_96093_i;
    @Shadow
    public Set<String> field_184236_aF;

    @Shadow
    public abstract void func_70107_b(double var1, double var3, double var5);

    @Shadow
    public abstract void func_70106_y();

    @Shadow
    public abstract int func_70086_ai();

    @Shadow
    public abstract void func_70050_g(int var1);

    @Shadow
    public abstract float func_70047_e();

    @Shadow
    public abstract UUID func_110124_au();

    @Shadow
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow
    public abstract void func_70015_d(int var1);

    @Shadow
    public abstract NBTTagCompound func_189511_e(NBTTagCompound var1);

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract int func_145782_y();

    @Shadow
    public abstract List<net.minecraft.entity.Entity> shadow$func_184188_bt();

    @Shadow
    public abstract net.minecraft.entity.Entity func_184208_bv();

    @Shadow
    public abstract net.minecraft.entity.Entity func_184187_bx();

    @Shadow
    public abstract void func_184226_ay();

    @Shadow
    public abstract void func_184201_a(EntityEquipmentSlot var1, ItemStack var2);

    @Shadow
    public abstract void func_184185_a(SoundEvent var1, float var2, float var3);

    @Shadow
    public abstract boolean func_189652_ae();

    @Shadow
    protected abstract void shadow$func_70101_b(float var1, float var2);

    @Shadow
    public abstract boolean shadow$func_184211_a(String var1);

    @Shadow
    public abstract boolean shadow$func_184197_b(String var1);

    @Shadow
    public abstract void func_184210_p();

    @Override
    public EntitySnapshot createSnapshot() {
        return new SpongeEntitySnapshotBuilder().from(this).build();
    }

    @Override
    public Random getRandom() {
        return this.field_70146_Z;
    }

    public Vector3d getPosition() {
        return new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public Location<World> getLocation() {
        return new Location<World>((World)this.field_70170_p, this.getPosition());
    }

    @Override
    public boolean setLocationAndRotation(Location<World> location, Vector3d rotation) {
        boolean result = this.setLocation(location);
        if (result) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setLocation(Location<World> location) {
        Preconditions.checkNotNull(location, (Object)"The location was null!");
        if (this.isRemoved()) {
            return false;
        }
        if (!WorldManager.isKnownWorld((WorldServer)location.getExtent())) {
            return false;
        }
        Throwable throwable = null;
        try (BasicPluginContext context = PluginPhase.State.TELEPORT.createPhaseContext();){
            MoveEntityEvent.Teleport event;
            context.buildAndSwitch();
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                if (!frame.getCurrentContext().containsKey(EventContextKeys.TELEPORT_TYPE)) {
                    frame.addContext(EventContextKeys.TELEPORT_TYPE, TeleportTypes.PLUGIN);
                }
                if ((event = EntityUtil.handleDisplaceEntityTeleportEvent((net.minecraft.entity.Entity)this, location)).isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                location = event.getToTransform().getLocation();
                this.field_70125_A = (float)event.getToTransform().getPitch();
                this.field_70177_z = (float)event.getToTransform().getYaw();
            }
            ChunkProviderServerBridge chunkProviderServer = (ChunkProviderServerBridge)((WorldServer)this.field_70170_p).func_72863_F();
            boolean previous = chunkProviderServer.bridge$getForceChunkRequests();
            chunkProviderServer.bridge$setForceChunkRequests(true);
            try {
                double distance;
                List passengers = ((net.minecraft.entity.Entity)this).func_184188_bt();
                boolean isTeleporting = true;
                boolean isChangingDimension = false;
                if (location.getExtent().getUniqueId() != ((World)this.field_70170_p).getUniqueId()) {
                    if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP) {
                        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this;
                        if (entityPlayerMP.field_71070_bA != entityPlayerMP.field_71069_bz) {
                            ((Player)entityPlayerMP).closeInventory();
                        }
                        EntityUtil.transferPlayerToWorld(entityPlayerMP, event, (WorldServer)location.getExtent(), (TeleporterBridge)((WorldServer)location.getExtent()).func_85176_s());
                    } else {
                        EntityUtil.transferEntityToWorld((net.minecraft.entity.Entity)this, event, (WorldServer)location.getExtent(), (TeleporterBridge)((WorldServer)location.getExtent()).func_85176_s(), false);
                    }
                    isChangingDimension = true;
                }
                if ((distance = location.getPosition().distance(this.getPosition())) <= 4.0) {
                    isTeleporting = false;
                }
                if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP && ((EntityPlayerMP)((net.minecraft.entity.Entity)this)).field_71135_a != null) {
                    EntityPlayerMP player = (EntityPlayerMP)((net.minecraft.entity.Entity)this);
                    if (isTeleporting || isChangingDimension) {
                        if (player.field_71070_bA != player.field_71069_bz) {
                            ((Player)player).closeInventory();
                        }
                        ((WorldServer)location.getExtent()).func_72863_F().func_186028_c(location.getChunkPosition().getX(), location.getChunkPosition().getZ());
                    }
                    player.field_71135_a.func_147364_a(location.getX(), location.getY(), location.getZ(), ((net.minecraft.entity.Entity)this).field_70177_z, ((net.minecraft.entity.Entity)this).field_70125_A);
                    ((NetHandlerPlayServerBridge)player.field_71135_a).bridge$setLastMoveLocation(null);
                } else {
                    this.func_70107_b(location.getPosition().getX(), location.getPosition().getY(), location.getPosition().getZ());
                }
                if (isTeleporting || isChangingDimension) {
                    for (net.minecraft.entity.Entity passenger : passengers) {
                        if (((World)passenger.func_130014_f_()).getUniqueId() != ((World)this.field_70170_p).getUniqueId()) {
                            ((Entity)passenger).setLocation(location);
                        }
                        passenger.func_184205_a((net.minecraft.entity.Entity)this, true);
                    }
                }
                boolean bl = true;
                chunkProviderServer.bridge$setForceChunkRequests(previous);
                return bl;
            }
            catch (Throwable throwable2) {
                try {
                    chunkProviderServer.bridge$setForceChunkRequests(previous);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    @Override
    public boolean setLocationAndRotation(Location<World> location, Vector3d rotation, EnumSet<RelativePositions> relativePositions) {
        boolean relocated = true;
        if (relativePositions.isEmpty()) {
            relocated = this.setLocation(location);
            this.setRotation(rotation);
        } else if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP && ((EntityPlayerMP)((net.minecraft.entity.Entity)this)).field_71135_a != null) {
            EnumSet<SPacketPlayerPosLook.EnumFlags> relativeFlags = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            if (relativePositions.contains((Object)RelativePositions.X)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.X);
            }
            if (relativePositions.contains((Object)RelativePositions.Y)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.Y);
            }
            if (relativePositions.contains((Object)RelativePositions.Z)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.Z);
            }
            if (relativePositions.contains((Object)RelativePositions.PITCH)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.X_ROT);
            }
            if (relativePositions.contains((Object)RelativePositions.YAW)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.Y_ROT);
            }
            ((EntityPlayerMP)((net.minecraft.entity.Entity)this)).field_71135_a.func_175089_a(location.getPosition().getX(), location.getPosition().getY(), location.getPosition().getZ(), (float)rotation.getY(), (float)rotation.getX(), relativeFlags);
        } else {
            Location<World> resultantLocation = this.getLocation();
            Vector3d resultantRotation = this.getRotation();
            if (relativePositions.contains((Object)RelativePositions.X)) {
                resultantLocation = resultantLocation.add(location.getPosition().getX(), 0.0, 0.0);
            }
            if (relativePositions.contains((Object)RelativePositions.Y)) {
                resultantLocation = resultantLocation.add(0.0, location.getPosition().getY(), 0.0);
            }
            if (relativePositions.contains((Object)RelativePositions.Z)) {
                resultantLocation = resultantLocation.add(0.0, 0.0, location.getPosition().getZ());
            }
            if (relativePositions.contains((Object)RelativePositions.PITCH)) {
                resultantRotation = resultantRotation.add(rotation.getX(), 0.0, 0.0);
            }
            if (relativePositions.contains((Object)RelativePositions.YAW)) {
                resultantRotation = resultantRotation.add(0.0, rotation.getY(), 0.0);
            }
            relocated = this.setLocation(resultantLocation);
            this.setRotation(resultantRotation);
        }
        return relocated;
    }

    @Override
    public Vector3d getScale() {
        return Vector3d.ONE;
    }

    @Override
    public void setScale(Vector3d scale) {
    }

    @Override
    public Transform<World> getTransform() {
        return new Transform<World>(this.getWorld(), this.getPosition(), this.getRotation(), this.getScale());
    }

    @Override
    public boolean setTransform(Transform<World> transform) {
        Preconditions.checkNotNull(transform, (Object)"The transform cannot be null!");
        boolean result = this.setLocation(transform.getLocation());
        if (result) {
            this.setRotation(transform.getRotation());
            this.setScale(transform.getScale());
            return true;
        }
        return false;
    }

    @Override
    public boolean transferToWorld(World world, Vector3d position) {
        Preconditions.checkNotNull((Object)world, (Object)"World was null!");
        Preconditions.checkNotNull((Object)position, (Object)"Position was null!");
        return this.setLocation(new Location<World>(world, position));
    }

    @Override
    public Vector3d getRotation() {
        return new Vector3d(this.field_70125_A, this.field_70177_z, 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP && ((EntityPlayerMP)((net.minecraft.entity.Entity)this)).field_71135_a != null) {
            ((EntityPlayerMP)((net.minecraft.entity.Entity)this)).field_71135_a.func_175089_a(this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ(), (float)rotation.getY(), (float)rotation.getX(), EnumSet.noneOf(RelativePositions.class));
        } else {
            if (!this.field_70170_p.field_72995_K) {
                ((WorldServerBridge)((Object)this.getWorld())).bridge$addEntityRotationUpdate((net.minecraft.entity.Entity)this, rotation);
            }
            this.shadow$func_70101_b((float)rotation.getY(), (float)rotation.getX());
        }
    }

    @Override
    public Optional<AABB> getBoundingBox() {
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public boolean isOnGround() {
        return this.field_70122_E;
    }

    @Override
    public boolean isRemoved() {
        return this.field_70128_L;
    }

    @Override
    public boolean isLoaded() {
        return !this.isRemoved();
    }

    @Override
    public void remove() {
        this.func_70106_y();
    }

    @Override
    public boolean damage(double damage, org.spongepowered.api.event.cause.entity.damage.source.DamageSource damageSource) {
        if (!(damageSource instanceof DamageSource)) {
            SpongeImpl.getLogger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.func_70097_a((DamageSource)damageSource, (float)damage);
    }

    @Override
    public EntityType getType() {
        return this.entityType;
    }

    @Override
    public UUID getUniqueId() {
        return this.field_96093_i;
    }

    @Intrinsic
    public List<Entity> entity$getPassengers() {
        return this.shadow$func_184188_bt();
    }

    @Override
    public Optional<Entity> getVehicle() {
        return Optional.ofNullable((Entity)this.func_184187_bx());
    }

    @Override
    public Entity getBaseVehicle() {
        return (Entity)this.func_184208_bv();
    }

    @Override
    public boolean hasPassenger(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return entity.getPassengers().contains(this);
    }

    @Override
    public boolean addPassenger(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        if (entity.getPassengers().contains(this)) {
            throw new IllegalArgumentException(String.format("Cannot add entity %s as a passenger of %s, because the former already has the latter as a passenger!", entity, this));
        }
        return ((net.minecraft.entity.Entity)entity).func_184205_a((net.minecraft.entity.Entity)this, true);
    }

    @Override
    public void removePassenger(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        if (!entity.getPassengers().contains(this)) {
            throw new IllegalArgumentException(String.format("Cannot remove entity %s, because it is not a passenger of %s ", entity, this));
        }
        ((net.minecraft.entity.Entity)entity).func_184210_p();
    }

    @Override
    public void clearPassengers() {
        this.func_184226_ay();
    }

    @Override
    public boolean setVehicle(@Nullable Entity entity) {
        if (this.func_184187_bx() == null && entity == null) {
            return false;
        }
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        return entity != null && entity.addPassenger(this);
    }

    @Override
    public boolean validateRawData(DataView container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Transform<World> transform = this.getTransform();
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189511_e(compound);
        Constants.NBT.filterSpongeCustomData(compound);
        DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.Entity.CLASS, (Object)this.getClass().getName()).set(Queries.WORLD_ID, (Object)transform.getExtent().getUniqueId().toString()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, (Object)transform.getPosition().getX()).set(Queries.POSITION_Y, (Object)transform.getPosition().getY()).set(Queries.POSITION_Z, (Object)transform.getPosition().getZ()).getContainer().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, (Object)transform.getRotation().getX()).set(Queries.POSITION_Y, (Object)transform.getRotation().getY()).set(Queries.POSITION_Z, (Object)transform.getRotation().getZ()).getContainer().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, (Object)transform.getScale().getX()).set(Queries.POSITION_Y, (Object)transform.getScale().getY()).set(Queries.POSITION_Z, (Object)transform.getScale().getZ()).getContainer().set(Constants.Entity.TYPE, (Object)this.entityType.getId()).set(Constants.Sponge.UNSAFE_NBT, (Object)unsafeNbt);
        Collection<DataManipulator<?, ?>> manipulators = ((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators();
        if (!manipulators.isEmpty()) {
            container.set(Constants.Sponge.DATA_MANIPULATORS, DataUtil.getSerializedManipulatorList(manipulators));
        }
        return container;
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        ArrayList list = Lists.newArrayList();
        this.spongeApi$supplyVanillaManipulators(list);
        if (this instanceof CustomDataHolderBridge && ((CustomDataHolderBridge)((Object)this)).bridge$hasManipulators()) {
            list.addAll(((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators());
        }
        return list;
    }

    @Override
    public DataHolder copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            NBTTagCompound compound = new NBTTagCompound();
            this.func_189511_e(compound);
            net.minecraft.entity.Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.entityType.getId()), (net.minecraft.world.World)this.field_70170_p);
            compound.func_186854_a("UUID", entity.func_110124_au());
            entity.func_70020_e(compound);
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    @Override
    public Optional<UUID> getCreator() {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getNotifier() {
        return Optional.empty();
    }

    @Override
    public void setCreator(@Nullable UUID uuid) {
    }

    @Override
    public void setNotifier(@Nullable UUID uuid) {
    }

    @Override
    public Vector3d getVelocity() {
        return new Vector3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    @Override
    public Translation getTranslation() {
        return this.getType().getTranslation();
    }

    @Override
    public boolean canSee(Entity entity) {
        Optional<Boolean> optional = entity.get(Keys.VANISH);
        return (!optional.isPresent() || optional.get() == false) && !((VanishableBridge)((Object)entity)).bridge$isVanished();
    }

    @Override
    public EntityArchetype createArchetype() {
        return new SpongeEntityArchetypeBuilder().from(this).build();
    }

    @Override
    public Value<Boolean> gravity() {
        return this.getValue(Keys.HAS_GRAVITY).get();
    }

    protected void spongeApi$supplyVanillaManipulators(Collection<? super DataManipulator<?, ?>> manipulators) {
        this.get(CustomNameVisibleData.class).ifPresent(manipulators::add);
        this.get(DisplayNameData.class).ifPresent(manipulators::add);
        this.get(FlyingData.class).ifPresent(manipulators::add);
        this.get(GlowingData.class).ifPresent(manipulators::add);
        this.get(GravityData.class).ifPresent(manipulators::add);
        this.get(GriefingData.class).ifPresent(manipulators::add);
        this.get(IgniteableData.class).ifPresent(manipulators::add);
        this.get(InvisibilityData.class).ifPresent(manipulators::add);
        this.get(InvulnerabilityData.class).ifPresent(manipulators::add);
        this.get(PassengerData.class).ifPresent(manipulators::add);
        this.get(SilentData.class).ifPresent(manipulators::add);
        this.get(SneakingData.class).ifPresent(manipulators::add);
        this.get(SprintData.class).ifPresent(manipulators::add);
        this.get(TargetedLocationData.class).ifPresent(manipulators::add);
        this.get(VehicleData.class).ifPresent(manipulators::add);
        this.get(VelocityData.class).ifPresent(manipulators::add);
    }

    @Override
    public Collection<String> getTags() {
        return Collections.unmodifiableSet(this.field_184236_aF);
    }

    @Intrinsic
    public boolean entity$addTag(String tag) {
        return this.shadow$func_184211_a(tag);
    }

    @Intrinsic
    public boolean entity$removeTag(String tag) {
        return this.shadow$func_184197_b(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        Objects.requireNonNull(tag);
        return this.field_184236_aF.contains(tag);
    }
}

